package io.ciera.tool.sql.architecture.interfaces.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.interfaces.IfaceSet;
import io.ciera.tool.sql.architecture.interfaces.Message;
import io.ciera.tool.sql.architecture.interfaces.MessageSet;
import io.ciera.tool.sql.architecture.interfaces.PortMessageSet;
import io.ciera.tool.sql.architecture.interfaces.impl.IfaceSetImpl;
import io.ciera.tool.sql.architecture.interfaces.impl.PortMessageSetImpl;
import io.ciera.tool.sql.ooaofooa.component.ExecutablePropertySet;
import io.ciera.tool.sql.ooaofooa.component.impl.ExecutablePropertySetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class MessageSetImpl extends InstanceSet<MessageSet,Message> implements MessageSet {

    public MessageSetImpl() {
    }

    public MessageSetImpl(Comparator<? super Message> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setId( int m_id ) throws XtumlException {
        for ( Message message : this ) message.setId( m_id );
    }
    @Override
    public void setIface_name( String ref_iface_name ) throws XtumlException {
        for ( Message message : this ) message.setIface_name( ref_iface_name );
    }
    @Override
    public void setName( String m_name ) throws XtumlException {
        for ( Message message : this ) message.setName( m_name );
    }
    @Override
    public void setIface_package( String ref_iface_package ) throws XtumlException {
        for ( Message message : this ) message.setIface_package( ref_iface_package );
    }
    @Override
    public void setTo_provider( boolean m_to_provider ) throws XtumlException {
        for ( Message message : this ) message.setTo_provider( m_to_provider );
    }


    // selections
    @Override
    public IfaceSet R419_defines_message_format_for_Iface() throws XtumlException {
        IfaceSet ifaceset = new IfaceSetImpl();
        for ( Message message : this ) ifaceset.add( message.R419_defines_message_format_for_Iface() );
        return ifaceset;
    }
    @Override
    public PortMessageSet R420_is_implemented_within_PortMessage() throws XtumlException {
        PortMessageSet portmessageset = new PortMessageSetImpl();
        for ( Message message : this ) portmessageset.addAll( message.R420_is_implemented_within_PortMessage() );
        return portmessageset;
    }
    @Override
    public ExecutablePropertySet R4761_ExecutableProperty() throws XtumlException {
        ExecutablePropertySet executablepropertyset = new ExecutablePropertySetImpl();
        for ( Message message : this ) executablepropertyset.add( message.R4761_ExecutableProperty() );
        return executablepropertyset;
    }


    @Override
    public Message nullElement() {
        return MessageImpl.EMPTY_MESSAGE;
    }

    @Override
    public MessageSet emptySet() {
      return new MessageSetImpl();
    }

    @Override
    public MessageSet emptySet(Comparator<? super Message> comp) {
      return new MessageSetImpl(comp);
    }

    @Override
    public List<Message> elements() {
        Message[] elements = toArray(new Message[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
