package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.VariableReference;
import io.ciera.tool.sql.architecture.expression.VariableReferenceSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.statement.VariableSet;
import io.ciera.tool.sql.architecture.statement.impl.VariableSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class VariableReferenceSetImpl extends InstanceSet<VariableReferenceSet,VariableReference> implements VariableReferenceSet {

    public VariableReferenceSetImpl() {
    }

    public VariableReferenceSetImpl(Comparator<? super VariableReference> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( VariableReference variablereference : this ) variablereference.setParent_name( ref_parent_name );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( VariableReference variablereference : this ) variablereference.setBlock_number( ref_block_number );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( VariableReference variablereference : this ) variablereference.setStatement_number( ref_statement_number );
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( VariableReference variablereference : this ) variablereference.setExpression_number( ref_expression_number );
    }
    @Override
    public void setDeclaration( boolean m_declaration ) throws XtumlException {
        for ( VariableReference variablereference : this ) variablereference.setDeclaration( m_declaration );
    }
    @Override
    public void setVar_name( String ref_var_name ) throws XtumlException {
        for ( VariableReference variablereference : this ) variablereference.setVar_name( ref_var_name );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( VariableReference variablereference : this ) variablereference.setBody_name( ref_body_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( VariableReference variablereference : this ) variablereference.setParent_package( ref_parent_package );
    }
    @Override
    public void setVar_block_number( String ref_var_block_number ) throws XtumlException {
        for ( VariableReference variablereference : this ) variablereference.setVar_block_number( ref_var_block_number );
    }


    // selections
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( VariableReference variablereference : this ) expressionset.add( variablereference.R776_is_a_Expression() );
        return expressionset;
    }
    @Override
    public VariableSet R782_refers_to_local_Variable() throws XtumlException {
        VariableSet variableset = new VariableSetImpl();
        for ( VariableReference variablereference : this ) variableset.add( variablereference.R782_refers_to_local_Variable() );
        return variableset;
    }


    @Override
    public VariableReference nullElement() {
        return VariableReferenceImpl.EMPTY_VARIABLEREFERENCE;
    }

    @Override
    public VariableReferenceSet emptySet() {
      return new VariableReferenceSetImpl();
    }

    @Override
    public VariableReferenceSet emptySet(Comparator<? super VariableReference> comp) {
      return new VariableReferenceSetImpl(comp);
    }

    @Override
    public List<VariableReference> elements() {
        return Arrays.asList(toArray(new VariableReference[0]));
    }

}
