package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.Selector;
import io.ciera.tool.sql.architecture.classes.impl.SelectorImpl;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.Select;
import io.ciera.tool.sql.architecture.expression.SelectRelated;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;
import io.ciera.tool.sql.architecture.expression.impl.SelectImpl;


public class SelectRelatedImpl extends ModelInstance<SelectRelated,Sql> implements SelectRelated {

    public static final String KEY_LETTERS = "SelectRelated";
    public static final SelectRelated EMPTY_SELECTRELATED = new EmptySelectRelated();

    private Sql context;

    // constructors
    private SelectRelatedImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_expression_number = "";
        ref_root_expression_number = "";
        ref_selector_name = "";
        ref_selector_parent_name = "";
        ref_selector_parent_package = "";
        R789_is_a_Select_inst = SelectImpl.EMPTY_SELECT;
        R791_selects_instances_linked_from_instance_expressed_by_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R797_selects_instances_through_Selector_inst = SelectorImpl.EMPTY_SELECTOR;
    }

    private SelectRelatedImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_root_expression_number, String ref_selector_name, String ref_selector_parent_name, String ref_selector_parent_package ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_expression_number = ref_expression_number;
        this.ref_root_expression_number = ref_root_expression_number;
        this.ref_selector_name = ref_selector_name;
        this.ref_selector_parent_name = ref_selector_parent_name;
        this.ref_selector_parent_package = ref_selector_parent_package;
        R789_is_a_Select_inst = SelectImpl.EMPTY_SELECT;
        R791_selects_instances_linked_from_instance_expressed_by_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R797_selects_instances_through_Selector_inst = SelectorImpl.EMPTY_SELECTOR;
    }

    public static SelectRelated create( Sql context ) throws XtumlException {
        SelectRelated newSelectRelated = new SelectRelatedImpl( context );
        if ( context.addInstance( newSelectRelated ) ) {
            newSelectRelated.getRunContext().addChange(new InstanceCreatedDelta(newSelectRelated, KEY_LETTERS));
            return newSelectRelated;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SelectRelated create( Sql context, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_root_expression_number, String ref_selector_name, String ref_selector_parent_name, String ref_selector_parent_package ) throws XtumlException {
        return create(context, UniqueId.random(), ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, ref_root_expression_number, ref_selector_name, ref_selector_parent_name, ref_selector_parent_package);
    }

    public static SelectRelated create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_root_expression_number, String ref_selector_name, String ref_selector_parent_name, String ref_selector_parent_package ) throws XtumlException {
        SelectRelated newSelectRelated = new SelectRelatedImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, ref_root_expression_number, ref_selector_name, ref_selector_parent_name, ref_selector_parent_package );
        if ( context.addInstance( newSelectRelated ) ) {
            return newSelectRelated;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    private String ref_parent_package;
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    private String ref_body_name;
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    private String ref_block_number;
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    private String ref_statement_number;
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    private String ref_expression_number;
    @Override
    public String getExpression_number() throws XtumlException {
        checkLiving();
        return ref_expression_number;
    }
    @Override
    public void setExpression_number(String ref_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_expression_number, this.ref_expression_number)) {
            final String oldValue = this.ref_expression_number;
            this.ref_expression_number = ref_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_expression_number", oldValue, this.ref_expression_number));
        }
    }
    private String ref_root_expression_number;
    @Override
    public String getRoot_expression_number() throws XtumlException {
        checkLiving();
        return ref_root_expression_number;
    }
    @Override
    public void setRoot_expression_number(String ref_root_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_root_expression_number, this.ref_root_expression_number)) {
            final String oldValue = this.ref_root_expression_number;
            this.ref_root_expression_number = ref_root_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_root_expression_number", oldValue, this.ref_root_expression_number));
        }
    }
    private String ref_selector_name;
    @Override
    public String getSelector_name() throws XtumlException {
        checkLiving();
        return ref_selector_name;
    }
    @Override
    public void setSelector_name(String ref_selector_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_selector_name, this.ref_selector_name)) {
            final String oldValue = this.ref_selector_name;
            this.ref_selector_name = ref_selector_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_selector_name", oldValue, this.ref_selector_name));
        }
    }
    private String ref_selector_parent_name;
    @Override
    public void setSelector_parent_name(String ref_selector_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_selector_parent_name, this.ref_selector_parent_name)) {
            final String oldValue = this.ref_selector_parent_name;
            this.ref_selector_parent_name = ref_selector_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_selector_parent_name", oldValue, this.ref_selector_parent_name));
        }
    }
    @Override
    public String getSelector_parent_name() throws XtumlException {
        checkLiving();
        return ref_selector_parent_name;
    }
    private String ref_selector_parent_package;
    @Override
    public String getSelector_parent_package() throws XtumlException {
        checkLiving();
        return ref_selector_parent_package;
    }
    @Override
    public void setSelector_parent_package(String ref_selector_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_selector_parent_package, this.ref_selector_parent_package)) {
            final String oldValue = this.ref_selector_parent_package;
            this.ref_selector_parent_package = ref_selector_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_selector_parent_package", oldValue, this.ref_selector_parent_package));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number(), getExpression_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        Expression base_expression = self().R791_selects_instances_linked_from_instance_expressed_by_Expression();
        base_expression.render();
        String root_expression_body = context().T().body();
        context().T().pop_buffer();
        context().T().include( "expression/t.selectrelated.java", root_expression_body, self() );
    }

    @Override
    public boolean validateExpressionType() throws XtumlException {
        return false;
    }



    // static operations


    // events


    // selections
    private Select R789_is_a_Select_inst;
    @Override
    public void setR789_is_a_Select( Select inst ) {
        R789_is_a_Select_inst = inst;
    }
    @Override
    public Select R789_is_a_Select() throws XtumlException {
        return R789_is_a_Select_inst;
    }
    private Expression R791_selects_instances_linked_from_instance_expressed_by_Expression_inst;
    @Override
    public void setR791_selects_instances_linked_from_instance_expressed_by_Expression( Expression inst ) {
        R791_selects_instances_linked_from_instance_expressed_by_Expression_inst = inst;
    }
    @Override
    public Expression R791_selects_instances_linked_from_instance_expressed_by_Expression() throws XtumlException {
        return R791_selects_instances_linked_from_instance_expressed_by_Expression_inst;
    }
    private Selector R797_selects_instances_through_Selector_inst;
    @Override
    public void setR797_selects_instances_through_Selector( Selector inst ) {
        R797_selects_instances_through_Selector_inst = inst;
    }
    @Override
    public Selector R797_selects_instances_through_Selector() throws XtumlException {
        return R797_selects_instances_through_Selector_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SelectRelated self() {
        return this;
    }

    @Override
    public SelectRelated oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SELECTRELATED;
    }

}

class EmptySelectRelated extends ModelInstance<SelectRelated,Sql> implements SelectRelated {

    // attributes
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getExpression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getRoot_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRoot_expression_number( String ref_root_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSelector_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSelector_name( String ref_selector_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSelector_parent_name( String ref_selector_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSelector_parent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getSelector_parent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSelector_parent_package( String ref_selector_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public boolean validateExpressionType() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Select R789_is_a_Select() {
        return SelectImpl.EMPTY_SELECT;
    }
    @Override
    public Expression R791_selects_instances_linked_from_instance_expressed_by_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }
    @Override
    public Selector R797_selects_instances_through_Selector() {
        return SelectorImpl.EMPTY_SELECTOR;
    }


    @Override
    public String getKeyLetters() {
        return SelectRelatedImpl.KEY_LETTERS;
    }

    @Override
    public SelectRelated self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SelectRelated oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SelectRelatedImpl.EMPTY_SELECTRELATED;
    }

}
