package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.component.Utility;
import io.ciera.tool.sql.architecture.component.UtilityFunction;
import io.ciera.tool.sql.architecture.component.UtilityFunctionSet;
import io.ciera.tool.sql.architecture.component.UtilityReference;
import io.ciera.tool.sql.architecture.component.UtilityReferenceSet;
import io.ciera.tool.sql.architecture.component.impl.UtilityFunctionSetImpl;
import io.ciera.tool.sql.architecture.component.impl.UtilityReferenceSetImpl;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.file.impl.FileImpl;

import java.util.Iterator;

import types.ImportType;


public class UtilityImpl extends ModelInstance<Utility,Sql> implements Utility {

    public static final String KEY_LETTERS = "Utility";
    public static final Utility EMPTY_UTILITY = new EmptyUtility();

    private Sql context;

    // constructors
    private UtilityImpl( Sql context ) {
        this.context = context;
        ref_name = "";
        ref_package = "";
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R4558_used_within_context_of_UtilityReference_set = new UtilityReferenceSetImpl();
        R4559_provides_UtilityFunction_set = new UtilityFunctionSetImpl();
    }

    private UtilityImpl( Sql context, UniqueId instanceId, String ref_name, String ref_package ) {
        super(instanceId);
        this.context = context;
        this.ref_name = ref_name;
        this.ref_package = ref_package;
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R4558_used_within_context_of_UtilityReference_set = new UtilityReferenceSetImpl();
        R4559_provides_UtilityFunction_set = new UtilityFunctionSetImpl();
    }

    public static Utility create( Sql context ) throws XtumlException {
        Utility newUtility = new UtilityImpl( context );
        if ( context.addInstance( newUtility ) ) {
            newUtility.getRunContext().addChange(new InstanceCreatedDelta(newUtility, KEY_LETTERS));
            return newUtility;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Utility create( Sql context, String ref_name, String ref_package ) throws XtumlException {
        return create(context, UniqueId.random(), ref_name, ref_package);
    }

    public static Utility create( Sql context, UniqueId instanceId, String ref_name, String ref_package ) throws XtumlException {
        Utility newUtility = new UtilityImpl( context, instanceId, ref_name, ref_package );
        if ( context.addInstance( newUtility ) ) {
            return newUtility;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_name;
    @Override
    public void setName(String ref_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_name, this.ref_name)) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
            if ( !R4558_used_within_context_of_UtilityReference().isEmpty() ) R4558_used_within_context_of_UtilityReference().setUtility_name( ref_name );
            if ( !R4559_provides_UtilityFunction().isEmpty() ) R4559_provides_UtilityFunction().setUtility_name( ref_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return ref_name;
    }
    private String ref_package;
    @Override
    public void setPackage(String ref_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_package, this.ref_package)) {
            final String oldValue = this.ref_package;
            this.ref_package = ref_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_package", oldValue, this.ref_package));
            if ( !R4559_provides_UtilityFunction().isEmpty() ) R4559_provides_UtilityFunction().setUtility_package( ref_package );
            if ( !R4558_used_within_context_of_UtilityReference().isEmpty() ) R4558_used_within_context_of_UtilityReference().setUtility_package( ref_package );
        }
    }
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
        return ref_package;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        File file = self().R401_is_a_File();
        String imports = file.getFormattedImports( ImportType.IMPL );
        UtilityFunctionSet util_funcs = self().R4559_provides_UtilityFunction();
        UtilityFunction utility_function;
        for ( Iterator<UtilityFunction> _utility_function_iter = util_funcs.elements().iterator(); _utility_function_iter.hasNext(); ) {
            utility_function = _utility_function_iter.next();
            utility_function.render();
        }
        String utility_functions = context().T().body();
        context().T().clear();
        context().T().include( "component/t.utility.impl.java", imports, self(), utility_functions );
        context().T().emit( ( ( ( file.getPath() + "/impl/" ) + self().getName() ) + "Impl" ) + file.getExtension() );
        context().T().clear();
        imports = file.getFormattedImports( ImportType.INT );
        for ( Iterator<UtilityFunction> _utility_function_iter = util_funcs.elements().iterator(); _utility_function_iter.hasNext(); ) {
            utility_function = _utility_function_iter.next();
            utility_function.render_interface();
        }
        utility_functions = context().T().body();
        context().T().clear();
        context().T().include( "component/t.utility.java", imports, self(), utility_functions );
        context().T().emit( ( ( file.getPath() + "/" ) + self().getName() ) + file.getExtension() );
        context().T().clear();
    }



    // static operations


    // events


    // selections
    private File R401_is_a_File_inst;
    @Override
    public void setR401_is_a_File( File inst ) {
        R401_is_a_File_inst = inst;
    }
    @Override
    public File R401_is_a_File() throws XtumlException {
        return R401_is_a_File_inst;
    }
    private UtilityReferenceSet R4558_used_within_context_of_UtilityReference_set;
    @Override
    public void addR4558_used_within_context_of_UtilityReference( UtilityReference inst ) {
        R4558_used_within_context_of_UtilityReference_set.add(inst);
    }
    @Override
    public void removeR4558_used_within_context_of_UtilityReference( UtilityReference inst ) {
        R4558_used_within_context_of_UtilityReference_set.remove(inst);
    }
    @Override
    public UtilityReferenceSet R4558_used_within_context_of_UtilityReference() throws XtumlException {
        return R4558_used_within_context_of_UtilityReference_set;
    }
    private UtilityFunctionSet R4559_provides_UtilityFunction_set;
    @Override
    public void addR4559_provides_UtilityFunction( UtilityFunction inst ) {
        R4559_provides_UtilityFunction_set.add(inst);
    }
    @Override
    public void removeR4559_provides_UtilityFunction( UtilityFunction inst ) {
        R4559_provides_UtilityFunction_set.remove(inst);
    }
    @Override
    public UtilityFunctionSet R4559_provides_UtilityFunction() throws XtumlException {
        return R4559_provides_UtilityFunction_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Utility self() {
        return this;
    }

    @Override
    public Utility oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_UTILITY;
    }

}

class EmptyUtility extends ModelInstance<Utility,Sql> implements Utility {

    // attributes
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String ref_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public File R401_is_a_File() {
        return FileImpl.EMPTY_FILE;
    }
    @Override
    public UtilityReferenceSet R4558_used_within_context_of_UtilityReference() {
        return (new UtilityReferenceSetImpl());
    }
    @Override
    public UtilityFunctionSet R4559_provides_UtilityFunction() {
        return (new UtilityFunctionSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return UtilityImpl.KEY_LETTERS;
    }

    @Override
    public Utility self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Utility oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return UtilityImpl.EMPTY_UTILITY;
    }

}
