package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.AttributeAccessor;
import io.ciera.tool.sql.architecture.classes.AttributeAccessorSet;
import io.ciera.tool.sql.architecture.classes.InstSet;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.SetSelector;
import io.ciera.tool.sql.architecture.classes.SetSelectorSet;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstImpl;
import io.ciera.tool.sql.architecture.classes.impl.SetSelectorSetImpl;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.file.impl.FileImpl;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.impl.TypeImpl;

import java.util.Iterator;

import types.AttributeAccessorType;
import types.ImportType;


public class InstSetImpl extends ModelInstance<InstSet,Sql> implements InstSet {

    public static final String KEY_LETTERS = "ClassSet";
    public static final InstSet EMPTY_INSTSET = new EmptyInstSet();

    private Sql context;

    // constructors
    private InstSetImpl( Sql context ) {
        this.context = context;
        ref_name = "";
        ref_package = "";
        m_extends = "";
        ref_class_name = "";
        ref_class_package = "";
        ref_comp_name = "";
        ref_comp_package = "";
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R406_defines_set_with_elements_of_type_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R407_is_a_Type_inst = TypeImpl.EMPTY_TYPE;
        R444_selects_instances_through_SetSelector_set = new SetSelectorSetImpl();
    }

    private InstSetImpl( Sql context, UniqueId instanceId, String ref_name, String ref_package, String m_extends, String ref_class_name, String ref_class_package, String ref_comp_name, String ref_comp_package ) {
        super(instanceId);
        this.context = context;
        this.ref_name = ref_name;
        this.ref_package = ref_package;
        this.m_extends = m_extends;
        this.ref_class_name = ref_class_name;
        this.ref_class_package = ref_class_package;
        this.ref_comp_name = ref_comp_name;
        this.ref_comp_package = ref_comp_package;
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R406_defines_set_with_elements_of_type_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R407_is_a_Type_inst = TypeImpl.EMPTY_TYPE;
        R444_selects_instances_through_SetSelector_set = new SetSelectorSetImpl();
    }

    public static InstSet create( Sql context ) throws XtumlException {
        InstSet newInstSet = new InstSetImpl( context );
        if ( context.addInstance( newInstSet ) ) {
            newInstSet.getRunContext().addChange(new InstanceCreatedDelta(newInstSet, KEY_LETTERS));
            return newInstSet;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InstSet create( Sql context, String ref_name, String ref_package, String m_extends, String ref_class_name, String ref_class_package, String ref_comp_name, String ref_comp_package ) throws XtumlException {
        return create(context, UniqueId.random(), ref_name, ref_package, m_extends, ref_class_name, ref_class_package, ref_comp_name, ref_comp_package);
    }

    public static InstSet create( Sql context, UniqueId instanceId, String ref_name, String ref_package, String m_extends, String ref_class_name, String ref_class_package, String ref_comp_name, String ref_comp_package ) throws XtumlException {
        InstSet newInstSet = new InstSetImpl( context, instanceId, ref_name, ref_package, m_extends, ref_class_name, ref_class_package, ref_comp_name, ref_comp_package );
        if ( context.addInstance( newInstSet ) ) {
            return newInstSet;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return ref_name;
    }
    @Override
    public void setName(String ref_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_name, this.ref_name)) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
            if ( !R444_selects_instances_through_SetSelector().isEmpty() ) R444_selects_instances_through_SetSelector().setSet_parent_name( ref_name );
        }
    }
    private String ref_package;
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
        return ref_package;
    }
    @Override
    public void setPackage(String ref_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_package, this.ref_package)) {
            final String oldValue = this.ref_package;
            this.ref_package = ref_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_package", oldValue, this.ref_package));
            if ( !R444_selects_instances_through_SetSelector().isEmpty() ) R444_selects_instances_through_SetSelector().setSet_parent_package( ref_package );
        }
    }
    private String m_extends;
    @Override
    public String getExtends() throws XtumlException {
        checkLiving();
        return m_extends;
    }
    @Override
    public void setExtends(String m_extends) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_extends, this.m_extends)) {
            final String oldValue = this.m_extends;
            this.m_extends = m_extends;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_extends", oldValue, this.m_extends));
        }
    }
    private String ref_class_name;
    @Override
    public void setClass_name(String ref_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_name, this.ref_class_name)) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
        return ref_class_name;
    }
    private String ref_class_package;
    @Override
    public String getClass_package() throws XtumlException {
        checkLiving();
        return ref_class_package;
    }
    @Override
    public void setClass_package(String ref_class_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_package, this.ref_class_package)) {
            final String oldValue = this.ref_class_package;
            this.ref_class_package = ref_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_package", oldValue, this.ref_class_package));
        }
    }
    private String ref_comp_name;
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
        return ref_comp_name;
    }
    @Override
    public void setComp_name(String ref_comp_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_comp_name, this.ref_comp_name)) {
            final String oldValue = this.ref_comp_name;
            this.ref_comp_name = ref_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_name", oldValue, this.ref_comp_name));
        }
    }
    private String ref_comp_package;
    @Override
    public String getComp_package() throws XtumlException {
        checkLiving();
        return ref_comp_package;
    }
    @Override
    public void setComp_package(String ref_comp_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_comp_package, this.ref_comp_package)) {
            final String oldValue = this.ref_comp_package;
            this.ref_comp_package = ref_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_package", oldValue, this.ref_comp_package));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        File file = self().R401_is_a_File();
        String imports = file.getFormattedImports( ImportType.IMPL );
        AttributeAccessorSet accessors = ((AttributeAccessorSet)self().R406_defines_set_with_elements_of_type_ModelInst().R410_data_abstracted_by_Attribute().R4510_value_accessed_through_AttributeAccessor().where(selected -> ((AttributeAccessor)selected).getAccessor_type().equality(AttributeAccessorType.SETTER)));
        AttributeAccessor accessor;
        for ( Iterator<AttributeAccessor> _accessor_iter = accessors.elements().iterator(); _accessor_iter.hasNext(); ) {
            accessor = _accessor_iter.next();
            accessor.render_set();
        }
        String attributes = context().T().body();
        context().T().clear();
        SetSelectorSet selects = self().R444_selects_instances_through_SetSelector();
        SetSelector selector;
        for ( Iterator<SetSelector> _selector_iter = selects.elements().iterator(); _selector_iter.hasNext(); ) {
            selector = _selector_iter.next();
            selector.render();
        }
        String selectors = context().T().body();
        context().T().clear();
        context().T().include( "class/t.classset.impl.java", attributes, imports, selectors, self() );
        context().T().emit( ( ( ( file.getPath() + "/impl/" ) + self().getName() ) + "Impl" ) + file.getExtension() );
        context().T().clear();
        imports = file.getFormattedImports( ImportType.INT );
        for ( Iterator<AttributeAccessor> _accessor_iter = accessors.elements().iterator(); _accessor_iter.hasNext(); ) {
            accessor = _accessor_iter.next();
            accessor.render_interface();
        }
        attributes = context().T().body();
        context().T().clear();
        for ( Iterator<SetSelector> _selector_iter = selects.elements().iterator(); _selector_iter.hasNext(); ) {
            selector = _selector_iter.next();
            selector.render_interface();
        }
        selectors = context().T().body();
        context().T().clear();
        context().T().include( "class/t.classset.java", attributes, imports, selectors, self() );
        context().T().emit( ( ( file.getPath() + "/" ) + self().getName() ) + file.getExtension() );
        context().T().clear();
    }



    // static operations


    // events


    // selections
    private File R401_is_a_File_inst;
    @Override
    public void setR401_is_a_File( File inst ) {
        R401_is_a_File_inst = inst;
    }
    @Override
    public File R401_is_a_File() throws XtumlException {
        return R401_is_a_File_inst;
    }
    private ModelInst R406_defines_set_with_elements_of_type_ModelInst_inst;
    @Override
    public void setR406_defines_set_with_elements_of_type_ModelInst( ModelInst inst ) {
        R406_defines_set_with_elements_of_type_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R406_defines_set_with_elements_of_type_ModelInst() throws XtumlException {
        return R406_defines_set_with_elements_of_type_ModelInst_inst;
    }
    private Type R407_is_a_Type_inst;
    @Override
    public void setR407_is_a_Type( Type inst ) {
        R407_is_a_Type_inst = inst;
    }
    @Override
    public Type R407_is_a_Type() throws XtumlException {
        return R407_is_a_Type_inst;
    }
    private SetSelectorSet R444_selects_instances_through_SetSelector_set;
    @Override
    public void addR444_selects_instances_through_SetSelector( SetSelector inst ) {
        R444_selects_instances_through_SetSelector_set.add(inst);
    }
    @Override
    public void removeR444_selects_instances_through_SetSelector( SetSelector inst ) {
        R444_selects_instances_through_SetSelector_set.remove(inst);
    }
    @Override
    public SetSelectorSet R444_selects_instances_through_SetSelector() throws XtumlException {
        return R444_selects_instances_through_SetSelector_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InstSet self() {
        return this;
    }

    @Override
    public InstSet oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INSTSET;
    }

}

class EmptyInstSet extends ModelInstance<InstSet,Sql> implements InstSet {

    // attributes
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String ref_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getExtends() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExtends( String m_extends ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getClass_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_package( String ref_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public File R401_is_a_File() {
        return FileImpl.EMPTY_FILE;
    }
    @Override
    public ModelInst R406_defines_set_with_elements_of_type_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }
    @Override
    public Type R407_is_a_Type() {
        return TypeImpl.EMPTY_TYPE;
    }
    @Override
    public SetSelectorSet R444_selects_instances_through_SetSelector() {
        return (new SetSelectorSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return InstSetImpl.KEY_LETTERS;
    }

    @Override
    public InstSet self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InstSet oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InstSetImpl.EMPTY_INSTSET;
    }

}
