package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.AttributeAccessor;
import io.ciera.tool.sql.architecture.classes.AttributeDerivation;
import io.ciera.tool.sql.architecture.classes.impl.AttributeAccessorImpl;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectImpl;

import types.AttributeAccessorType;


public class AttributeDerivationImpl extends ModelInstance<AttributeDerivation,Sql> implements AttributeDerivation {

    public static final String KEY_LETTERS = "AttributeDerivation";
    public static final AttributeDerivation EMPTY_ATTRIBUTEDERIVATION = new EmptyAttributeDerivation();

    private Sql context;

    // constructors
    private AttributeDerivationImpl( Sql context ) {
        this.context = context;
        ref_class_name = "";
        ref_class_package = "";
        ref_attribute_name = "";
        ref_accessor_type = AttributeAccessorType.UNINITIALIZED_ENUM;
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R441_calculates_value_for_AttributeAccessor_inst = AttributeAccessorImpl.EMPTY_ATTRIBUTEACCESSOR;
    }

    private AttributeDerivationImpl( Sql context, UniqueId instanceId, String ref_class_name, String ref_class_package, String ref_attribute_name, AttributeAccessorType ref_accessor_type ) {
        super(instanceId);
        this.context = context;
        this.ref_class_name = ref_class_name;
        this.ref_class_package = ref_class_package;
        this.ref_attribute_name = ref_attribute_name;
        this.ref_accessor_type = ref_accessor_type;
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R441_calculates_value_for_AttributeAccessor_inst = AttributeAccessorImpl.EMPTY_ATTRIBUTEACCESSOR;
    }

    public static AttributeDerivation create( Sql context ) throws XtumlException {
        AttributeDerivation newAttributeDerivation = new AttributeDerivationImpl( context );
        if ( context.addInstance( newAttributeDerivation ) ) {
            newAttributeDerivation.getRunContext().addChange(new InstanceCreatedDelta(newAttributeDerivation, KEY_LETTERS));
            return newAttributeDerivation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AttributeDerivation create( Sql context, String ref_class_name, String ref_class_package, String ref_attribute_name, AttributeAccessorType ref_accessor_type ) throws XtumlException {
        return create(context, UniqueId.random(), ref_class_name, ref_class_package, ref_attribute_name, ref_accessor_type);
    }

    public static AttributeDerivation create( Sql context, UniqueId instanceId, String ref_class_name, String ref_class_package, String ref_attribute_name, AttributeAccessorType ref_accessor_type ) throws XtumlException {
        AttributeDerivation newAttributeDerivation = new AttributeDerivationImpl( context, instanceId, ref_class_name, ref_class_package, ref_attribute_name, ref_accessor_type );
        if ( context.addInstance( newAttributeDerivation ) ) {
            return newAttributeDerivation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_class_name;
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
        return ref_class_name;
    }
    @Override
    public void setClass_name(String ref_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_name, this.ref_class_name)) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }
    private String ref_class_package;
    @Override
    public String getClass_package() throws XtumlException {
        checkLiving();
        return ref_class_package;
    }
    @Override
    public void setClass_package(String ref_class_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_package, this.ref_class_package)) {
            final String oldValue = this.ref_class_package;
            this.ref_class_package = ref_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_package", oldValue, this.ref_class_package));
        }
    }
    private String ref_attribute_name;
    @Override
    public String getAttribute_name() throws XtumlException {
        checkLiving();
        return ref_attribute_name;
    }
    @Override
    public void setAttribute_name(String ref_attribute_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_attribute_name, this.ref_attribute_name)) {
            final String oldValue = this.ref_attribute_name;
            this.ref_attribute_name = ref_attribute_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attribute_name", oldValue, this.ref_attribute_name));
        }
    }
    private AttributeAccessorType ref_accessor_type;
    @Override
    public void setAccessor_type(AttributeAccessorType ref_accessor_type) throws XtumlException {
        checkLiving();
        if (ref_accessor_type.inequality( this.ref_accessor_type)) {
            final AttributeAccessorType oldValue = this.ref_accessor_type;
            this.ref_accessor_type = ref_accessor_type;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_accessor_type", oldValue, this.ref_accessor_type));
        }
    }
    @Override
    public AttributeAccessorType getAccessor_type() throws XtumlException {
        checkLiving();
        return ref_accessor_type;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getClass_name(), getClass_package(), getAttribute_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        InvocableObject invocable = self().R427_is_a_InvocableObject();
        String body = invocable.body();
        context().T().include( "class/t.attributederivation.java", body );
    }



    // static operations


    // events


    // selections
    private InvocableObject R427_is_a_InvocableObject_inst;
    @Override
    public void setR427_is_a_InvocableObject( InvocableObject inst ) {
        R427_is_a_InvocableObject_inst = inst;
    }
    @Override
    public InvocableObject R427_is_a_InvocableObject() throws XtumlException {
        return R427_is_a_InvocableObject_inst;
    }
    private AttributeAccessor R441_calculates_value_for_AttributeAccessor_inst;
    @Override
    public void setR441_calculates_value_for_AttributeAccessor( AttributeAccessor inst ) {
        R441_calculates_value_for_AttributeAccessor_inst = inst;
    }
    @Override
    public AttributeAccessor R441_calculates_value_for_AttributeAccessor() throws XtumlException {
        return R441_calculates_value_for_AttributeAccessor_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AttributeDerivation self() {
        return this;
    }

    @Override
    public AttributeDerivation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ATTRIBUTEDERIVATION;
    }

}

class EmptyAttributeDerivation extends ModelInstance<AttributeDerivation,Sql> implements AttributeDerivation {

    // attributes
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_package( String ref_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAttribute_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttribute_name( String ref_attribute_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setAccessor_type( AttributeAccessorType ref_accessor_type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public AttributeAccessorType getAccessor_type() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public InvocableObject R427_is_a_InvocableObject() {
        return InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }
    @Override
    public AttributeAccessor R441_calculates_value_for_AttributeAccessor() {
        return AttributeAccessorImpl.EMPTY_ATTRIBUTEACCESSOR;
    }


    @Override
    public String getKeyLetters() {
        return AttributeDerivationImpl.KEY_LETTERS;
    }

    @Override
    public AttributeDerivation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AttributeDerivation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return AttributeDerivationImpl.EMPTY_ATTRIBUTEDERIVATION;
    }

}
