package io.ciera.tool;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.template.util.ITemplate;
import io.ciera.runtime.template.util.ITemplateRegistry;
import io.ciera.runtime.template.util.Template;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.application.Application;
import io.ciera.tool.sql.architecture.application.ComponentInstantiation;
import io.ciera.tool.sql.architecture.classes.Attribute;
import io.ciera.tool.sql.architecture.classes.AttributeAccessor;
import io.ciera.tool.sql.architecture.classes.ClassRelationship;
import io.ciera.tool.sql.architecture.classes.InstSet;
import io.ciera.tool.sql.architecture.classes.InstanceSelector;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.Operation;
import io.ciera.tool.sql.architecture.classes.SetSelector;
import io.ciera.tool.sql.architecture.component.ComponentDefinition;
import io.ciera.tool.sql.architecture.component.Function;
import io.ciera.tool.sql.architecture.component.InstancePopulationSelector;
import io.ciera.tool.sql.architecture.component.RelationshipPopulationSelector;
import io.ciera.tool.sql.architecture.component.Utility;
import io.ciera.tool.sql.architecture.component.UtilityFunction;
import io.ciera.tool.sql.architecture.component.UtilityReference;
import io.ciera.tool.sql.architecture.expression.BinaryOperation;
import io.ciera.tool.sql.architecture.expression.ConstantReference;
import io.ciera.tool.sql.architecture.expression.Creation;
import io.ciera.tool.sql.architecture.expression.EnumeratorReference;
import io.ciera.tool.sql.architecture.expression.EventCreation;
import io.ciera.tool.sql.architecture.expression.Invocation;
import io.ciera.tool.sql.architecture.expression.Literal;
import io.ciera.tool.sql.architecture.expression.NamedReference;
import io.ciera.tool.sql.architecture.expression.ParameterReference;
import io.ciera.tool.sql.architecture.expression.Promotion;
import io.ciera.tool.sql.architecture.expression.SelectFromInstances;
import io.ciera.tool.sql.architecture.expression.SelectRelated;
import io.ciera.tool.sql.architecture.expression.Selected;
import io.ciera.tool.sql.architecture.expression.UnaryOperation;
import io.ciera.tool.sql.architecture.expression.VariableReference;
import io.ciera.tool.sql.architecture.expression.Where;
import io.ciera.tool.sql.architecture.file.GeneralFile;
import io.ciera.tool.sql.architecture.file.TypeImport;
import io.ciera.tool.sql.architecture.interfaces.Iface;
import io.ciera.tool.sql.architecture.interfaces.Message;
import io.ciera.tool.sql.architecture.interfaces.Port;
import io.ciera.tool.sql.architecture.interfaces.PortMessage;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.statemachine.Event;
import io.ciera.tool.sql.architecture.statemachine.State;
import io.ciera.tool.sql.architecture.statemachine.StateMachine;
import io.ciera.tool.sql.architecture.statemachine.StateTransition;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableCell;
import io.ciera.tool.sql.architecture.statement.Finalization;
import io.ciera.tool.sql.architecture.statement.ForSmt;
import io.ciera.tool.sql.architecture.statement.IfSmt;
import io.ciera.tool.sql.architecture.statement.RelateSmt;
import io.ciera.tool.sql.architecture.statement.UnrelateSmt;
import io.ciera.tool.sql.architecture.type.EnumeratedType;
import io.ciera.tool.sql.architecture.type.Enumerator;
import io.ciera.tool.sql.architecture.type.UserDefinedType;
import io.ciera.tool.sql.loader.AttributeComparison;
import io.ciera.tool.sql.loader.BatchRelator;
import io.ciera.tool.sql.loader.BooleanSerializer;
import io.ciera.tool.sql.loader.ClassInstanceLoader;
import io.ciera.tool.sql.loader.ClassInstanceSerializer;
import io.ciera.tool.sql.loader.EnumeratorLoader;
import io.ciera.tool.sql.loader.EventInstanceLoader;
import io.ciera.tool.sql.loader.EventInstanceSerializer;
import io.ciera.tool.sql.loader.GeneralLoader;
import io.ciera.tool.sql.loader.GeneralSerializer;
import io.ciera.tool.sql.loader.IntegerLoader;
import io.ciera.tool.sql.loader.IntegerSerializer;
import io.ciera.tool.sql.loader.PopulationLoader;
import io.ciera.tool.sql.loader.RealSerializer;
import io.ciera.tool.sql.loader.StringSerializer;
import io.ciera.tool.sql.loader.TimerInstanceLoader;
import io.ciera.tool.sql.loader.TimerInstanceSerializer;


public class SqlTemplateRegistry implements ITemplateRegistry {

    private Sql population;

    public SqlTemplateRegistry( Sql population ) {
        this.population = population;
    }

    @Override
    public ITemplate getTemplate( String filename ) {
        switch ( filename ) {
        case "application/t.application.async.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String component_instantiations = (String)symbols[0];
                    String component_satisfactions = (String)symbols[1];
                    String imports = (String)symbols[2];
                    int num_component_instances = (int)symbols[3];
                    Application self = (Application)symbols[4];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ";\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic class " );
                    context().T().append( self.getName() );
                    context().T().append( " implements IApplication {\n\n    private IComponent<?>[] components;\n    private ApplicationExecutor executor;\n\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( "() {\n        components = new IComponent<?>[" );
                    context().T().append( context().T().sub( "t", num_component_instances ) );
                    context().T().append( "];\n    }\n\n    @Override\n    public void setup( String[] args, ILogger logger ) {\n        if ( null != logger ) {\n            executor = new ApplicationExecutor(\"" );
                    context().T().append( self.getName() );
                    context().T().append( "Executor\", args, logger);\n        }\n        else {\n            executor = new ApplicationExecutor(\"" );
                    context().T().append( self.getName() );
                    context().T().append( "Executor\", args);\n        }\n" );
                    context().T().append( component_instantiations );
                    context().T().append( component_satisfactions );
                    context().T().append( "    }\n\n    @Override\n    public void printVersions() {\n        io.ciera.runtime.Version.printVersion();\n        for ( IComponent<?> c : components ) {\n            System.out.printf(\"%s: %s (%s)\", c.getClass().getName(), c.getVersion(), c.getVersionDate());\n            System.out.println();\n        }\n    }\n\n    public void handleSignal(final String data) {\n        final JSONObject msg = new JSONObject(data);\n        final int index = msg.getInt(\"componentId\");\n        final String portName = msg.getString(\"portName\");\n        // load population\n        try {\n            if (null!= components[index].getDefaultLoader()) components[index].getDefaultLoader().load();\n        } catch (XtumlException e) {/* fail silently */}\n        IChangeLog changeLog = executor.performTransaction(new ReceivedMessageTask() {\n            @Override\n            public void run() throws XtumlException {\n                // execute signal\n                try {\n                    Method portAccessor = components[index].getClass().getMethod(portName);\n                    IPort<?> port = (IPort<?>)portAccessor.invoke(components[index]);\n                    port.deliver(Message.deserialize(msg.getJSONObject(\"message\").toString()));\n                } catch (NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {\n                    throw new XtumlException(\"Could not deliver message\");\n                }\n            }\n        });\n        // serialize population\n        try {\n            if (null!= components[index].getDefaultLoader()) components[index].getDefaultLoader().serialize(changeLog);\n        } catch (XtumlException e) {/* fail silently */}\n    }\n\n    public void heartbeat() {\n        // load population\n        for ( IComponent<?> c : components ) {\n        	try {\n        	    if (null != c.getDefaultLoader()) c.getDefaultLoader().load();\n            } catch (XtumlException e) {/* fail silently */}\n        }\n        // tick\n        IChangeLog changeLog = executor.heartbeat();\n        // serialize population\n        for ( IComponent<?> c : components ) {\n        	try {\n        	    if (null != c.getDefaultLoader()) c.getDefaultLoader().serialize(changeLog);\n            } catch (XtumlException e) {/* fail silently */}\n        }\n    }\n\n    @Override\n    public void initialize() {}\n\n    @Override\n    public void start() {}\n\n    @Override\n    public void stop() {}\n\n    public static void main(String[] args) {\n        " );
                    context().T().append( self.getName() );
                    context().T().append( " app = new " );
                    context().T().append( self.getName() );
                    context().T().append( "();\n        app.setup(args, null);\n        CommandLine cmd = new CommandLine(args);\n        try {\n            cmd.register_flag(\"v\", \"Print version\");\n            cmd.register_flag(\"version\", \"Print version\");\n            cmd.register_flag(\"heartbeat\", \"Check ticking timers\");\n            cmd.register_value(\"signal\", \"signal_file\", \"File containing JSON signal data\", \"\", false);\n            cmd.read_command_line();\n            if (cmd.get_flag(\"v\") || cmd.get_flag(\"version\")) {\n                app.printVersions();\n            }\n            else {\n                if (cmd.get_flag(\"heartbeat\")) {\n                    app.heartbeat();\n                }\n                else if (!\"\".equals(cmd.get_value(\"signal\"))) {\n                    try {\n                        Scanner sc = new Scanner(new File(cmd.get_value(\"signal\")));\n                        String signalData = \"\";\n                        while (sc.hasNextLine()) signalData += sc.nextLine();\n                        sc.close();\n                        app.handleSignal(signalData);\n                    } catch (IOException e) {/* fail silently */}\n                }\n            }\n        } catch (XtumlException e) {/* fail silently */}\n    }\n\n}\n" );
                }

            };
        case "application/t.application.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String component_getters = (String)symbols[0];
                    String component_instantiations = (String)symbols[1];
                    String component_satisfactions = (String)symbols[2];
                    String imports = (String)symbols[3];
                    int num_component_instances = (int)symbols[4];
                    int num_executors = (int)symbols[5];
                    Application self = (Application)symbols[6];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ";\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic class " );
                    context().T().append( self.getName() );
                    context().T().append( " implements IApplication {\n\n    private IComponent<?>[] components;\n    private ApplicationExecutor[] executors;\n\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( "() {\n        components = new IComponent<?>[" );
                    context().T().append( context().T().sub( "t", num_component_instances ) );
                    context().T().append( "];\n        executors = new ApplicationExecutor[" );
                    context().T().append( context().T().sub( "t", num_executors ) );
                    context().T().append( "];\n    }\n\n    @Override\n    public void run() {\n        for (ApplicationExecutor executor : executors) {\n            executor.run();\n        }\n    }\n\n    @Override\n    public void setup( String[] args, ILogger logger ) {\n        for ( int i = 0; i < executors.length; i++ ) {\n            if ( null != logger ) {\n                executors[i] = new ApplicationExecutor( \"" );
                    context().T().append( self.getName() );
                    context().T().append( "Executor\" + i, args, logger );\n            }\n            else {\n                executors[i] = new ApplicationExecutor( \"" );
                    context().T().append( self.getName() );
                    context().T().append( "Executor\" + i, args );\n            }\n        }\n" );
                    context().T().append( component_instantiations );
                    context().T().append( component_satisfactions );
                    context().T().append( "    }\n\n" );
                    context().T().append( component_getters );
                    context().T().append( "\n    @Override\n    public void initialize() {\n        for ( IComponent<?> component : components ) {\n            component.getRunContext().execute( new GenericExecutionTask() {\n                @Override\n                public void run() throws XtumlException {\n                    component.initialize();\n                }\n            });\n        }\n    }\n\n    @Override\n    public void start() {\n        if (1 == executors.length) {\n            executors[0].run();\n        }\n        else {\n            for ( ApplicationExecutor executor : executors ) {\n                executor.start();\n            }\n        }\n    }\n\n    @Override\n    public void printVersions() {\n        io.ciera.runtime.Version.printVersion();\n        for ( IComponent<?> c : components ) {\n            System.out.printf(\"%s: %s (%s)\", c.getClass().getName(), c.getVersion(), c.getVersionDate());\n            System.out.println();\n        }\n    }\n\n    @Override\n    public void stop() {\n        for ( ApplicationExecutor executor : executors ) {\n            executor.execute(new HaltExecutionTask());\n        }\n    }\n\n    public static void main( String[] args ) {\n        IApplication app = new " );
                    context().T().append( self.getName() );
                    context().T().append( "();\n        app.setup( args, null );\n        if ( Arrays.asList(args).contains(\"-v\") || Arrays.asList(args).contains(\"--version\") ) {\n            app.printVersions();\n        }\n        else {\n            app.initialize();\n            app.start();\n        }\n    }\n\n}\n" );
                }

            };
        case "application/t.componentinstantiation.getter.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    ComponentInstantiation self = (ComponentInstantiation)symbols[0];
                    context().T().append( "    public " );
                    context().T().append( self.getComp_name() );
                    context().T().append( " " );
                    context().T().append( self.getComp_name() );
                    context().T().append( "() {\n        return (" );
                    context().T().append( self.getComp_name() );
                    context().T().append( ")components[" );
                    context().T().append( self.getIndex() );
                    context().T().append( "];\n    }\n" );
                }

            };
        case "application/t.componentinstantiation.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    ComponentInstantiation self = (ComponentInstantiation)symbols[0];
                    context().T().append( "        components[" );
                    context().T().append( context().T().sub( "t", self.getIndex() ) );
                    context().T().append( "] = new " );
                    context().T().append( self.getComp_name() );
                    context().T().append( "(this, " );
                    if ( ( -1 == self.getExecutor_index() ) ) {
                        context().T().append( "executor" );
                    }
                    else {
                        context().T().append( "executors[" );
                        context().T().append( context().T().sub( "t", self.getExecutor_index() ) );
                        context().T().append( "]" );
                    }
                    context().T().append( ", " );
                    context().T().append( context().T().sub( "t", self.getIndex() ) );
                    context().T().append( ");\n" );
                    if ( ( self.getSimulated_time() ) ) {
                        if ( ( -1 == self.getExecutor_index() ) ) {
                            context().T().append( "executor" );
                        }
                        else {
                            context().T().append( "executors[" );
                            context().T().append( context().T().sub( "t", self.getExecutor_index() ) );
                            context().T().append( "]" );
                        }
                        context().T().append( "        .enableSimulatedTime(true);\n" );
                    }
                    if ( ( StringUtil.inequality("", self.getInstance_loading()) ) ) {
                        context().T().append( "        components[" );
                        context().T().append( self.getIndex() );
                        context().T().append( "].addLoader(\"" );
                        context().T().append( self.getInstance_loading() );
                        context().T().append( "\", new " );
                        context().T().append( self.getComp_name() );
                        context().T().append( self.getInstance_loading() );
                        context().T().append( "Loader((" );
                        context().T().append( self.getComp_name() );
                        context().T().append( ")components[" );
                        context().T().append( self.getIndex() );
                        context().T().append( "]));\n" );
                    }
                }

            };
        case "application/t.satisfaction.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    int prov_comp_index = (int)symbols[0];
                    String prov_comp_name = (String)symbols[1];
                    String prov_port_name = (String)symbols[2];
                    int req_comp_index = (int)symbols[3];
                    String req_comp_name = (String)symbols[4];
                    String req_port_name = (String)symbols[5];
                    context().T().append( "        ((" );
                    context().T().append( req_comp_name );
                    context().T().append( ")components[" );
                    context().T().append( req_comp_index );
                    context().T().append( "])." );
                    context().T().append( req_port_name );
                    context().T().append( "().satisfy(((" );
                    context().T().append( prov_comp_name );
                    context().T().append( ")components[" );
                    context().T().append( prov_comp_index );
                    context().T().append( "])." );
                    context().T().append( prov_port_name );
                    context().T().append( "());\n        ((" );
                    context().T().append( prov_comp_name );
                    context().T().append( ")components[" );
                    context().T().append( prov_comp_index );
                    context().T().append( "])." );
                    context().T().append( prov_port_name );
                    context().T().append( "().satisfy(((" );
                    context().T().append( req_comp_name );
                    context().T().append( ")components[" );
                    context().T().append( req_comp_index );
                    context().T().append( "])." );
                    context().T().append( req_port_name );
                    context().T().append( "());\n" );
                }

            };
        case "class/t.attribute.deserializer.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    Attribute attribute = (Attribute)symbols[0];
                    boolean is_array = (boolean)symbols[1];
                    String setter_name = (String)symbols[2];
                    String type_name = (String)symbols[3];
                    if ( ( is_array ) ) {
                        context().T().append( "inst." );
                        context().T().append( setter_name );
                        context().T().append( "(ArrayUtil.deserialize(json.getString(\"" );
                        context().T().append( attribute.getBase_name() );
                        context().T().append( "\"), " );
                        context().T().append( type_name );
                        context().T().append( "::deserialize));\n" );
                    }
                    else {
                        context().T().append( "inst." );
                        context().T().append( setter_name );
                        context().T().append( "(" );
                        context().T().append( type_name );
                        context().T().append( ".deserialize(json.getString(\"" );
                        context().T().append( attribute.getBase_name() );
                        context().T().append( "\")));\n" );
                    }
                }

            };
        case "class/t.attribute.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    Attribute self = (Attribute)symbols[0];
                    context().T().append( "    private " );
                    context().T().append( self.getType_reference_name() );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( ";\n" );
                }

            };
        case "class/t.attribute.serializer.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    Attribute attribute = (Attribute)symbols[0];
                    String getter_name = (String)symbols[1];
                    String util_name = (String)symbols[2];
                    if ( ( StringUtil.inequality(util_name, "") ) ) {
                        context().T().append( "json.put(\"" );
                        context().T().append( attribute.getBase_name() );
                        context().T().append( "\", " );
                        context().T().append( util_name );
                        context().T().append( ".serialize(" );
                        context().T().append( getter_name );
                        context().T().append( "()));\n" );
                    }
                    else {
                        context().T().append( "json.put(\"" );
                        context().T().append( attribute.getBase_name() );
                        context().T().append( "\", " );
                        context().T().append( getter_name );
                        context().T().append( "().serialize());\n" );
                    }
                }

            };
        case "class/t.attributeaccessor.empty.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    boolean is_getter = (boolean)symbols[0];
                    String name = (String)symbols[1];
                    AttributeAccessor self = (AttributeAccessor)symbols[2];
                    String type_name = (String)symbols[3];
                    if ( ( is_getter ) ) {
                        context().T().append( "    public " );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( name );
                        context().T().append( "() throws XtumlException {\n        throw new EmptyInstanceException( \"Cannot get attribute of empty instance.\" );\n    }\n" );
                    }
                    else {
                        context().T().append( "    public void " );
                        context().T().append( name );
                        context().T().append( "( " );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( " ) throws XtumlException {\n        throw new EmptyInstanceException( \"Cannot set attribute of empty instance.\" );\n    }\n" );
                    }
                }

            };
        case "class/t.attributeaccessor.int.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    boolean is_getter = (boolean)symbols[0];
                    String name = (String)symbols[1];
                    AttributeAccessor self = (AttributeAccessor)symbols[2];
                    String type_name = (String)symbols[3];
                    if ( ( is_getter ) ) {
                        context().T().append( "    public " );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( name );
                        context().T().append( "() throws XtumlException;\n" );
                    }
                    else {
                        context().T().append( "    public void " );
                        context().T().append( name );
                        context().T().append( "( " );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( " ) throws XtumlException;\n" );
                    }
                }

            };
        case "class/t.attributeaccessor.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attribute_derivation = (String)symbols[0];
                    boolean is_array = (boolean)symbols[1];
                    boolean is_getter = (boolean)symbols[2];
                    boolean is_string = (boolean)symbols[3];
                    String name = (String)symbols[4];
                    boolean primitive = (boolean)symbols[5];
                    String propagations = (String)symbols[6];
                    AttributeAccessor self = (AttributeAccessor)symbols[7];
                    String type_name = (String)symbols[8];
                    if ( ( is_getter ) ) {
                        context().T().append( "    @Override\n    public " );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( name );
                        context().T().append( "() throws XtumlException {\n        checkLiving();\n" );
                        if ( ( StringUtil.inequality("", attribute_derivation) ) ) {
                            context().T().append( "        " );
                            context().T().append( attribute_derivation );
                            context().T().append( "" );
                        }
                        context().T().append( "        return " );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( ";\n    }\n" );
                    }
                    else {
                        context().T().append( "    @Override\n    public void " );
                        context().T().append( name );
                        context().T().append( "(" );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( ") throws XtumlException {\n        checkLiving();\n" );
                        if ( ( primitive ) ) {
                            context().T().append( "        if (" );
                            context().T().append( self.getAttribute_name() );
                            context().T().append( " != this." );
                            context().T().append( self.getAttribute_name() );
                            context().T().append( ") {\n" );
                        }
                        else {
                            if ( ( is_array ) ) {
                                context().T().append( "        if (ArrayUtil.inequality(" );
                                context().T().append( self.getAttribute_name() );
                                context().T().append( ", this." );
                                context().T().append( self.getAttribute_name() );
                                context().T().append( ")) {\n" );
                            }
                            else if ( ( is_string ) ) {
                                context().T().append( "        if (StringUtil.inequality(" );
                                context().T().append( self.getAttribute_name() );
                                context().T().append( ", this." );
                                context().T().append( self.getAttribute_name() );
                                context().T().append( ")) {\n" );
                            }
                            else {
                                context().T().append( "        if (" );
                                context().T().append( self.getAttribute_name() );
                                context().T().append( ".inequality( this." );
                                context().T().append( self.getAttribute_name() );
                                context().T().append( ")) {\n" );
                            }
                        }
                        context().T().append( "            final " );
                        context().T().append( type_name );
                        context().T().append( " oldValue = this." );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( ";\n            this." );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( " = " );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( ";\n            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, \"" );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( "\", oldValue, this." );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( "));\n" );
                        context().T().append( propagations );
                        context().T().append( "        }\n    }\n" );
                    }
                }

            };
        case "class/t.attributeaccessor.set.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    boolean is_getter = (boolean)symbols[0];
                    String name = (String)symbols[1];
                    AttributeAccessor self = (AttributeAccessor)symbols[2];
                    String type_name = (String)symbols[3];
                    if ( ( is_getter ) ) {
                    }
                    else {
                        context().T().append( "    @Override\n    public void " );
                        context().T().append( name );
                        context().T().append( "( " );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( " ) throws XtumlException {\n        for ( " );
                        context().T().append( self.getClass_name() );
                        context().T().append( " " );
                        context().T().append( context().T().sub( "l", self.getClass_name() ) );
                        context().T().append( " : this ) " );
                        context().T().append( context().T().sub( "l", self.getClass_name() ) );
                        context().T().append( "." );
                        context().T().append( name );
                        context().T().append( "( " );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( " );\n    }\n" );
                    }
                }

            };
        case "class/t.attributeaccessor.unmanaged.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    boolean is_getter = (boolean)symbols[0];
                    String name = (String)symbols[1];
                    AttributeAccessor self = (AttributeAccessor)symbols[2];
                    String type_name = (String)symbols[3];
                    if ( ( is_getter ) ) {
                        context().T().append( "    public " );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( name );
                        context().T().append( "() {\n        return " );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( ";\n    }\n" );
                    }
                    else {
                        context().T().append( "    public void " );
                        context().T().append( name );
                        context().T().append( "(" );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( ") {\n        this." );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( " = " );
                        context().T().append( self.getAttribute_name() );
                        context().T().append( ";\n    }\n" );
                    }
                }

            };
        case "class/t.attributederivation.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String body = (String)symbols[0];
                    context().T().append( body );
                    context().T().append( "" );
                }

            };
        case "class/t.attributeinitializer.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String initializer = (String)symbols[0];
                    Attribute self = (Attribute)symbols[1];
                    context().T().append( "        " );
                    context().T().append( self.getName() );
                    context().T().append( " = " );
                    context().T().append( initializer );
                    context().T().append( ";\n" );
                }

            };
        case "class/t.attributepropagation.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String accessor_name = (String)symbols[0];
                    String attribute_name = (String)symbols[1];
                    String selector_name = (String)symbols[2];
                    context().T().append( "            if ( !" );
                    context().T().append( selector_name );
                    context().T().append( "().isEmpty() ) " );
                    context().T().append( selector_name );
                    context().T().append( "()." );
                    context().T().append( accessor_name );
                    context().T().append( "( " );
                    context().T().append( attribute_name );
                    context().T().append( " );\n" );
                }

            };
        case "class/t.class.impl.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attribute_initializers = (String)symbols[0];
                    String attribute_initializers2 = (String)symbols[1];
                    String attribute_invocation_list = (String)symbols[2];
                    String attribute_list = (String)symbols[3];
                    String attributes = (String)symbols[4];
                    String empty_attributes = (String)symbols[5];
                    String empty_operations = (String)symbols[6];
                    String empty_selectors = (String)symbols[7];
                    String id1_attributes = (String)symbols[8];
                    String id2_attributes = (String)symbols[9];
                    String id3_attributes = (String)symbols[10];
                    String imports = (String)symbols[11];
                    String initial_state = (String)symbols[12];
                    String initial_state2 = (String)symbols[13];
                    String operations = (String)symbols[14];
                    String relationship_initializers = (String)symbols[15];
                    String selectors = (String)symbols[16];
                    ModelInst self = (ModelInst)symbols[17];
                    String state_machine_decl = (String)symbols[18];
                    String state_machine_events = (String)symbols[19];
                    String state_machine_initializer = (String)symbols[20];
                    String state_machine_initializer2 = (String)symbols[21];
                    String static_operations = (String)symbols[22];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ".impl;\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic class " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl extends " );
                    context().T().append( self.getExtends() );
                    context().T().append( " implements " );
                    context().T().append( self.getName() );
                    context().T().append( " {\n\n    public static final String KEY_LETTERS = \"" );
                    context().T().append( self.getKey_letters() );
                    context().T().append( "\";\n    public static final " );
                    context().T().append( self.getName() );
                    context().T().append( " EMPTY_" );
                    context().T().append( context().T().sub( "u_", self.getName() ) );
                    context().T().append( " = new Empty" );
                    context().T().append( self.getName() );
                    context().T().append( "();\n\n    private " );
                    context().T().append( self.getComp_name() );
                    context().T().append( " context;\n\n    // constructors\n    private " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl( " );
                    context().T().append( self.getComp_name() );
                    context().T().append( " context ) {\n        this.context = context;\n" );
                    context().T().append( attribute_initializers );
                    context().T().append( relationship_initializers );
                    context().T().append( state_machine_initializer );
                    context().T().append( "    }\n\n    private " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl( " );
                    context().T().append( self.getComp_name() );
                    context().T().append( " context, UniqueId instanceId" );
                    context().T().append( attribute_list );
                    context().T().append( initial_state );
                    context().T().append( " ) {\n        super(instanceId);\n        this.context = context;\n" );
                    context().T().append( attribute_initializers2 );
                    context().T().append( relationship_initializers );
                    context().T().append( state_machine_initializer2 );
                    context().T().append( "    }\n\n    public static " );
                    context().T().append( self.getName() );
                    context().T().append( " create( " );
                    context().T().append( self.getComp_name() );
                    context().T().append( " context ) throws XtumlException {\n        " );
                    context().T().append( self.getName() );
                    context().T().append( " new" );
                    context().T().append( self.getName() );
                    context().T().append( " = new " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl( context );\n        if ( context.addInstance( new" );
                    context().T().append( self.getName() );
                    context().T().append( " ) ) {\n            new" );
                    context().T().append( self.getName() );
                    context().T().append( ".getRunContext().addChange(new InstanceCreatedDelta(new" );
                    context().T().append( self.getName() );
                    context().T().append( ", KEY_LETTERS));\n            return new" );
                    context().T().append( self.getName() );
                    context().T().append( ";\n        }\n        else throw new InstancePopulationException( \"Instance already exists within this population.\" );\n    }\n\n" );
                    if ( ( StringUtil.inequality(attribute_list, "") ) ) {
                        context().T().append( "    public static " );
                        context().T().append( self.getName() );
                        context().T().append( " create( " );
                        context().T().append( self.getComp_name() );
                        context().T().append( " context" );
                        context().T().append( attribute_list );
                        context().T().append( initial_state );
                        context().T().append( " ) throws XtumlException {\n        return create(context, UniqueId.random()" );
                        context().T().append( attribute_invocation_list );
                        context().T().append( initial_state2 );
                        context().T().append( ");\n    }\n" );
                    }
                    context().T().append( "\n    public static " );
                    context().T().append( self.getName() );
                    context().T().append( " create( " );
                    context().T().append( self.getComp_name() );
                    context().T().append( " context, UniqueId instanceId" );
                    context().T().append( attribute_list );
                    context().T().append( initial_state );
                    context().T().append( " ) throws XtumlException {\n        " );
                    context().T().append( self.getName() );
                    context().T().append( " new" );
                    context().T().append( self.getName() );
                    context().T().append( " = new " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl( context, instanceId" );
                    context().T().append( attribute_invocation_list );
                    context().T().append( initial_state2 );
                    context().T().append( " );\n        if ( context.addInstance( new" );
                    context().T().append( self.getName() );
                    context().T().append( " ) ) {\n            return new" );
                    context().T().append( self.getName() );
                    context().T().append( ";\n        }\n        else throw new InstancePopulationException( \"Instance already exists within this population.\" );\n    }\n\n" );
                    context().T().append( state_machine_decl );
                    context().T().append( "\n\n    // attributes\n" );
                    context().T().append( attributes );
                    context().T().append( "\n\n    // instance identifiers\n" );
                    if ( ( StringUtil.inequality("", id1_attributes) ) ) {
                        context().T().append( "    @Override\n    public IInstanceIdentifier getId1() {\n        try {\n            return new InstanceIdentifier(" );
                        context().T().append( id1_attributes );
                        context().T().append( ");\n        }\n        catch ( XtumlException e ) {\n            getRunContext().getLog().error(e);\n            System.exit(1);\n            return null;\n        }\n    }\n" );
                    }
                    if ( ( StringUtil.inequality("", id2_attributes) ) ) {
                        context().T().append( "    @Override\n    public IInstanceIdentifier getId2() {\n        try {\n            return new InstanceIdentifier(" );
                        context().T().append( id2_attributes );
                        context().T().append( ");\n        }\n        catch ( XtumlException e ) {\n            getRunContext().getLog().error(e);\n            System.exit(1);\n            return null;\n        }\n    }\n" );
                    }
                    if ( ( StringUtil.inequality("", id3_attributes) ) ) {
                        context().T().append( "    @Override\n    public IInstanceIdentifier getId3() {\n        try {\n            return new InstanceIdentifier(" );
                        context().T().append( id3_attributes );
                        context().T().append( ");\n        }\n        catch ( XtumlException e ) {\n            getRunContext().getLog().error(e);\n            System.exit(1);\n            return null;\n        }\n    }\n" );
                    }
                    context().T().append( "\n    // operations\n" );
                    context().T().append( operations );
                    context().T().append( "\n\n    // static operations\n" );
                    context().T().append( static_operations );
                    context().T().append( "\n\n    // events\n" );
                    context().T().append( state_machine_events );
                    context().T().append( "\n\n    // selections\n" );
                    context().T().append( selectors );
                    context().T().append( "\n\n    @Override\n    public IRunContext getRunContext() {\n        return context().getRunContext();\n    }\n\n    @Override\n    public " );
                    context().T().append( self.getComp_name() );
                    context().T().append( " context() {\n        return context;\n    }\n\n    @Override\n    public String getKeyLetters() {\n        return KEY_LETTERS;\n    }\n\n    @Override\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( " self() {\n        return this;\n    }\n\n    @Override\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( " oneWhere(IWhere<IXtumlType> condition) throws XtumlException {\n        if (null == condition) throw new XtumlException(\"Null condition passed to selection.\");\n        if (condition.evaluate(this)) return this;\n        else return EMPTY_" );
                    context().T().append( context().T().sub( "u_", self.getName() ) );
                    context().T().append( ";\n    }\n\n" );
                    if ( ( StringUtil.inequality(self.getComparator(), "") ) ) {
                        context().T().append( "    @Override\n    @SuppressWarnings(\"unchecked\")\n    public int compareTo(" );
                        context().T().append( self.getName() );
                        context().T().append( " o) {\n        try {\n            Object val = " );
                        context().T().append( self.getComparator() );
                        context().T().append( "();\n            int cmpval = ((Comparable<Object>)val).compareTo(o." );
                        context().T().append( self.getComparator() );
                        context().T().append( "());\n            return cmpval != 0 ? cmpval : super.compareTo(o);\n        } catch (Exception e) {\n            return super.compareTo(o);\n        }\n    }\n\n" );
                    }
                    context().T().append( "}\n\nclass Empty" );
                    context().T().append( self.getName() );
                    context().T().append( " extends " );
                    context().T().append( self.getExtends() );
                    context().T().append( " implements " );
                    context().T().append( self.getName() );
                    context().T().append( " {\n\n    // attributes\n" );
                    context().T().append( empty_attributes );
                    context().T().append( "\n\n    // operations\n" );
                    context().T().append( empty_operations );
                    context().T().append( "\n\n    // selections\n" );
                    context().T().append( empty_selectors );
                    context().T().append( "\n\n    @Override\n    public String getKeyLetters() {\n        return " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl.KEY_LETTERS;\n    }\n\n    @Override\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( " self() {\n        return this;\n    }\n\n    @Override\n    public boolean isEmpty() {\n        return true;\n    }\n\n    @Override\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( " oneWhere(IWhere<IXtumlType> condition) throws XtumlException {\n        if (null == condition) throw new XtumlException(\"Null condition passed to selection.\");\n        return " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl.EMPTY_" );
                    context().T().append( context().T().sub( "u_", self.getName() ) );
                    context().T().append( ";\n    }\n\n}\n" );
                }

            };
        case "class/t.class.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attributes = (String)symbols[0];
                    String imports = (String)symbols[1];
                    String operations = (String)symbols[2];
                    String selectors = (String)symbols[3];
                    ModelInst self = (ModelInst)symbols[4];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ";\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic interface " );
                    context().T().append( self.getName() );
                    context().T().append( " extends IModelInstance<" );
                    context().T().append( self.getName() );
                    context().T().append( "," );
                    context().T().append( self.getComp_name() );
                    context().T().append( "> {\n\n    // attributes\n" );
                    context().T().append( attributes );
                    context().T().append( "\n\n    // operations\n" );
                    context().T().append( operations );
                    context().T().append( "\n\n    // selections\n" );
                    context().T().append( selectors );
                    context().T().append( "\n\n}\n" );
                }

            };
        case "class/t.class.unmanaged.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attribute_deserializers = (String)symbols[0];
                    String attribute_initializers = (String)symbols[1];
                    String attribute_serializers = (String)symbols[2];
                    String attributes = (String)symbols[3];
                    String imports = (String)symbols[4];
                    ModelInst self = (ModelInst)symbols[5];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ";\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic class " );
                    context().T().append( self.getName() );
                    context().T().append( " implements IXtumlType {\n\n    // constructors\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( "() {\n" );
                    context().T().append( attribute_initializers );
                    context().T().append( "    }\n\n    // attributes\n" );
                    context().T().append( attributes );
                    context().T().append( "\n\n    @Override\n    public String serialize() throws XtumlException {\n        final JSONObject json = new JSONObject();\n        " );
                    context().T().append( attribute_serializers );
                    context().T().append( "\n        return json.toString();\n    }\n\n    public static " );
                    context().T().append( self.getName() );
                    context().T().append( " deserialize(Object o) throws XtumlException {\n        if (o instanceof " );
                    context().T().append( self.getName() );
                    context().T().append( ") {\n            return (" );
                    context().T().append( self.getName() );
                    context().T().append( ") o;\n        } else if (o instanceof String) {\n            final " );
                    context().T().append( self.getName() );
                    context().T().append( " inst = new " );
                    context().T().append( self.getName() );
                    context().T().append( "();\n            final JSONObject json = new JSONObject((String) o);\n            " );
                    context().T().append( attribute_deserializers );
                    context().T().append( "        }\n        throw new XtumlException(\"Cannot deserialize value: \" + o);\n    }\n\n\n}\n" );
                }

            };
        case "class/t.classset.impl.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attributes = (String)symbols[0];
                    String imports = (String)symbols[1];
                    String selectors = (String)symbols[2];
                    InstSet self = (InstSet)symbols[3];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ".impl;\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic class " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl extends " );
                    context().T().append( self.getExtends() );
                    context().T().append( " implements " );
                    context().T().append( self.getName() );
                    context().T().append( " {\n\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl() {\n    }\n\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl(Comparator<? super " );
                    context().T().append( self.getClass_name() );
                    context().T().append( "> comp) {\n        super(comp);\n    }\n\n    // attributes\n" );
                    context().T().append( attributes );
                    context().T().append( "\n\n    // selections\n" );
                    context().T().append( selectors );
                    context().T().append( "\n\n    @Override\n    public " );
                    context().T().append( self.getClass_name() );
                    context().T().append( " nullElement() {\n        return " );
                    context().T().append( self.getClass_name() );
                    context().T().append( "Impl.EMPTY_" );
                    context().T().append( context().T().sub( "u_", self.getClass_name() ) );
                    context().T().append( ";\n    }\n\n    @Override\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( " emptySet() {\n      return new " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl();\n    }\n\n    @Override\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( " emptySet(Comparator<? super " );
                    context().T().append( self.getClass_name() );
                    context().T().append( "> comp) {\n      return new " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl(comp);\n    }\n\n    @Override\n    public List<" );
                    context().T().append( self.getClass_name() );
                    context().T().append( "> elements() {\n        return Arrays.asList(toArray(new " );
                    context().T().append( self.getClass_name() );
                    context().T().append( "[0]));\n    }\n\n}\n" );
                }

            };
        case "class/t.classset.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attributes = (String)symbols[0];
                    String imports = (String)symbols[1];
                    String selectors = (String)symbols[2];
                    InstSet self = (InstSet)symbols[3];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ";\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic interface " );
                    context().T().append( self.getName() );
                    context().T().append( " extends IInstanceSet<" );
                    context().T().append( self.getName() );
                    context().T().append( "," );
                    context().T().append( self.getClass_name() );
                    context().T().append( "> {\n\n    // attributes\n" );
                    context().T().append( attributes );
                    context().T().append( "\n\n    // selections\n" );
                    context().T().append( selectors );
                    context().T().append( "\n\n}\n" );
                }

            };
        case "class/t.instanceselector.empty.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    boolean multiplicity_many = (boolean)symbols[0];
                    InstanceSelector self = (InstanceSelector)symbols[1];
                    String type_name = (String)symbols[2];
                    if ( ( multiplicity_many ) ) {
                        context().T().append( "    @Override\n    public " );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( self.getName() );
                        context().T().append( "() {\n        return (new " );
                        context().T().append( type_name );
                        context().T().append( "Impl());\n    }\n" );
                    }
                    else {
                        context().T().append( "    @Override\n    public " );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( self.getName() );
                        context().T().append( "() {\n        return " );
                        context().T().append( type_name );
                        context().T().append( "Impl.EMPTY_" );
                        context().T().append( context().T().sub( "u_", type_name ) );
                        context().T().append( ";\n    }\n" );
                    }
                }

            };
        case "class/t.instanceselector.int.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String inst_type_name = (String)symbols[0];
                    boolean multiplicity_many = (boolean)symbols[1];
                    InstanceSelector self = (InstanceSelector)symbols[2];
                    String type_name = (String)symbols[3];
                    if ( ( multiplicity_many ) ) {
                        context().T().append( "    default public void add" );
                        context().T().append( self.getName() );
                        context().T().append( "( " );
                        context().T().append( inst_type_name );
                        context().T().append( " inst ) {}\n    default public void remove" );
                        context().T().append( self.getName() );
                        context().T().append( "( " );
                        context().T().append( inst_type_name );
                        context().T().append( " inst ) {}\n" );
                    }
                    else {
                        context().T().append( "    default public void set" );
                        context().T().append( self.getName() );
                        context().T().append( "( " );
                        context().T().append( inst_type_name );
                        context().T().append( " inst ) {}\n" );
                    }
                    context().T().append( "    public " );
                    context().T().append( type_name );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( "() throws XtumlException;\n" );
                }

            };
        case "class/t.instanceselector.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String inst_type_name = (String)symbols[0];
                    boolean multiplicity_many = (boolean)symbols[1];
                    InstanceSelector self = (InstanceSelector)symbols[2];
                    String type_name = (String)symbols[3];
                    if ( ( multiplicity_many ) ) {
                        context().T().append( "    private " );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( self.getName() );
                        context().T().append( "_set;\n    @Override\n    public void add" );
                        context().T().append( self.getName() );
                        context().T().append( "( " );
                        context().T().append( inst_type_name );
                        context().T().append( " inst ) {\n        " );
                        context().T().append( self.getName() );
                        context().T().append( "_set.add(inst);\n    }\n    @Override\n    public void remove" );
                        context().T().append( self.getName() );
                        context().T().append( "( " );
                        context().T().append( inst_type_name );
                        context().T().append( " inst ) {\n        " );
                        context().T().append( self.getName() );
                        context().T().append( "_set.remove(inst);\n    }\n" );
                    }
                    else {
                        context().T().append( "    private " );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( self.getName() );
                        context().T().append( "_inst;\n    @Override\n    public void set" );
                        context().T().append( self.getName() );
                        context().T().append( "( " );
                        context().T().append( inst_type_name );
                        context().T().append( " inst ) {\n        " );
                        context().T().append( self.getName() );
                        context().T().append( "_inst = inst;\n    }\n" );
                    }
                    context().T().append( "    @Override\n    public " );
                    context().T().append( type_name );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( "() throws XtumlException {\n" );
                    if ( ( multiplicity_many ) ) {
                        context().T().append( "        return " );
                        context().T().append( self.getName() );
                        context().T().append( "_set;\n" );
                    }
                    else {
                        context().T().append( "        return " );
                        context().T().append( self.getName() );
                        context().T().append( "_inst;\n" );
                    }
                    context().T().append( "    }\n" );
                }

            };
        case "class/t.operation.empty.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String modifiers = (String)symbols[0];
                    String parameter_list = (String)symbols[1];
                    Operation self = (Operation)symbols[2];
                    String type_name = (String)symbols[3];
                    context().T().append( "    public " );
                    context().T().append( modifiers );
                    context().T().append( type_name );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( "(" );
                    context().T().append( parameter_list );
                    context().T().append( ") throws XtumlException {\n        throw new EmptyInstanceException( \"Cannot invoke operation on empty instance.\" );\n    }\n" );
                }

            };
        case "class/t.operation.int.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String modifiers = (String)symbols[0];
                    String parameter_list = (String)symbols[1];
                    Operation self = (Operation)symbols[2];
                    String type_name = (String)symbols[3];
                    context().T().append( "    public " );
                    context().T().append( modifiers );
                    context().T().append( type_name );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( "(" );
                    context().T().append( parameter_list );
                    context().T().append( ") throws XtumlException;\n" );
                }

            };
        case "class/t.operation.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String body = (String)symbols[0];
                    String modifiers = (String)symbols[1];
                    String parameter_list = (String)symbols[2];
                    Operation self = (Operation)symbols[3];
                    String type_name = (String)symbols[4];
                    if ( ( !self.getIs_class_based() ) ) {
                        context().T().append( "    @Override\n    public " );
                        context().T().append( modifiers );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( self.getName() );
                        context().T().append( "(" );
                        context().T().append( parameter_list );
                        context().T().append( ") throws XtumlException " );
                        context().T().append( body );
                        context().T().append( "\n" );
                    }
                    else {
                        context().T().append( "        public " );
                        context().T().append( modifiers );
                        context().T().append( type_name );
                        context().T().append( " " );
                        context().T().append( self.getName() );
                        context().T().append( "(" );
                        context().T().append( parameter_list );
                        context().T().append( ") throws XtumlException " );
                        context().T().append( body );
                        context().T().append( "\n" );
                    }
                }

            };
        case "class/t.operations.static.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String operations = (String)symbols[0];
                    ModelInst self = (ModelInst)symbols[1];
                    context().T().append( "    public static class CLASS extends ActionHome<" );
                    context().T().append( self.getComp_name() );
                    context().T().append( "> {\n\n        public CLASS( " );
                    context().T().append( self.getComp_name() );
                    context().T().append( " context ) {\n            super( context );\n        }\n\n" );
                    context().T().append( operations );
                    context().T().append( "\n\n    }\n" );
                }

            };
        case "class/t.setselector.int.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    SetSelector self = (SetSelector)symbols[0];
                    String type_name = (String)symbols[1];
                    context().T().append( "    public " );
                    context().T().append( type_name );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( "() throws XtumlException;\n" );
                }

            };
        case "class/t.setselector.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    boolean multiplicity_many = (boolean)symbols[0];
                    SetSelector self = (SetSelector)symbols[1];
                    String type_name = (String)symbols[2];
                    context().T().append( "    @Override\n    public " );
                    context().T().append( type_name );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( "() throws XtumlException {\n        " );
                    context().T().append( type_name );
                    context().T().append( " " );
                    context().T().append( context().T().sub( "l", type_name ) );
                    context().T().append( " = new " );
                    context().T().append( type_name );
                    context().T().append( "Impl();\n        for ( " );
                    context().T().append( self.getSelector_class_name() );
                    context().T().append( " " );
                    context().T().append( context().T().sub( "l", self.getSelector_class_name() ) );
                    context().T().append( " : this ) " );
                    context().T().append( context().T().sub( "l", type_name ) );
                    context().T().append( ".add" );
                    if ( ( multiplicity_many ) ) {
                        context().T().append( "All" );
                    }
                    context().T().append( "( " );
                    context().T().append( context().T().sub( "l", self.getSelector_class_name() ) );
                    context().T().append( "." );
                    context().T().append( self.getSelector_name() );
                    context().T().append( "() );\n        return " );
                    context().T().append( context().T().sub( "l", type_name ) );
                    context().T().append( ";\n    }\n" );
                }

            };
        case "component/t.componentdefinition.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String class_directory = (String)symbols[0];
                    String functions = (String)symbols[1];
                    String imports = (String)symbols[2];
                    String init = (String)symbols[3];
                    String instance_adds = (String)symbols[4];
                    String instance_extent_initializers = (String)symbols[5];
                    String instance_removes = (String)symbols[6];
                    String instance_selectors = (String)symbols[7];
                    String ports = (String)symbols[8];
                    String relationship_extent_initializers = (String)symbols[9];
                    String relationship_modifiers = (String)symbols[10];
                    String relationship_selectors = (String)symbols[11];
                    ComponentDefinition self = (ComponentDefinition)symbols[12];
                    String utilities = (String)symbols[13];
                    String utility_initializers = (String)symbols[14];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ";\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic class " );
                    context().T().append( self.getName() );
                    context().T().append( " extends " );
                    context().T().append( self.getExtends() );
                    context().T().append( " {\n\n    private Map<String, Class<?>> classDirectory;\n\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( "(IApplication app, IRunContext runContext, int populationId) {\n        super(app, runContext, populationId);\n" );
                    context().T().append( instance_extent_initializers );
                    context().T().append( "\n" );
                    context().T().append( relationship_extent_initializers );
                    context().T().append( "\n" );
                    context().T().append( utility_initializers );
                    context().T().append( "\n        classDirectory = new TreeMap<>();\n" );
                    context().T().append( class_directory );
                    context().T().append( "\n    }\n\n    // domain functions\n" );
                    context().T().append( functions );
                    context().T().append( "\n\n    // relates and unrelates\n" );
                    context().T().append( relationship_modifiers );
                    context().T().append( "\n\n    // instance selections\n" );
                    context().T().append( instance_selectors );
                    context().T().append( "\n\n    // relationship selections\n" );
                    context().T().append( relationship_selectors );
                    context().T().append( "\n\n    // ports\n" );
                    context().T().append( ports );
                    context().T().append( "\n\n    // utilities\n" );
                    context().T().append( utilities );
                    context().T().append( "\n\n    // component initialization function\n    @Override\n    public void initialize() throws XtumlException {\n" );
                    context().T().append( init );
                    context().T().append( "\n    }\n\n" );
                    if ( ( StringUtil.inequality("", self.getVersion()) ) ) {
                        context().T().append( "    @Override\n    public String getVersion() {\n        Properties prop = new Properties();\n        try {\n            prop.load(getClass().getResourceAsStream(\"" );
                        context().T().append( self.getName() );
                        context().T().append( "Properties.properties\"));\n        } catch (IOException e) { /* do nothing */ }\n        return prop.getProperty(\"version\", \"Unknown\");\n    }\n" );
                    }
                    if ( ( StringUtil.inequality("", self.getVersion_date()) ) ) {
                        context().T().append( "    @Override\n    public String getVersionDate() {\n        Properties prop = new Properties();\n        try {\n            prop.load(getClass().getResourceAsStream(\"" );
                        context().T().append( self.getName() );
                        context().T().append( "Properties.properties\"));\n        } catch (IOException e) { /* do nothing */ }\n        return prop.getProperty(\"version_date\", \"Unknown\");\n    }\n" );
                    }
                    context().T().append( "\n    @Override\n    public boolean addInstance( IModelInstance<?,?> instance ) throws XtumlException {\n        if ( null == instance ) throw new BadArgumentException( \"Null instance passed.\" );\n        if ( instance.isEmpty() ) throw new EmptyInstanceException( \"Cannot add empty instance to population.\" );\n" );
                    context().T().append( instance_adds );
                    context().T().append( "\n        return false;\n    }\n\n    @Override\n    public boolean removeInstance( IModelInstance<?,?> instance ) throws XtumlException {\n        if ( null == instance ) throw new BadArgumentException( \"Null instance passed.\" );\n        if ( instance.isEmpty() ) throw new EmptyInstanceException( \"Cannot remove empty instance from population.\" );\n" );
                    context().T().append( instance_removes );
                    context().T().append( "\n        return false;\n    }\n\n    @Override\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( " context() {\n        return this;\n    }\n\n    @Override\n    public Class<?> getClassByKeyLetters(String keyLetters) {\n        return classDirectory.get(keyLetters);\n    }\n\n}\n" );
                }

            };
        case "component/t.function.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String body = (String)symbols[0];
                    String parameter_list = (String)symbols[1];
                    Function self = (Function)symbols[2];
                    String type_name = (String)symbols[3];
                    context().T().append( "    public " );
                    context().T().append( type_name );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( "(" );
                    context().T().append( parameter_list );
                    context().T().append( ") throws XtumlException " );
                    context().T().append( body );
                    context().T().append( "\n" );
                }

            };
        case "component/t.instancepopulationselector.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    InstancePopulationSelector self = (InstancePopulationSelector)symbols[0];
                    String set_name = (String)symbols[1];
                    context().T().append( "    private " );
                    context().T().append( set_name );
                    context().T().append( " " );
                    context().T().append( self.getClass_name() );
                    context().T().append( "_extent;\n    public " );
                    context().T().append( set_name );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( "() {\n        " );
                    context().T().append( set_name );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( " = new " );
                    context().T().append( set_name );
                    context().T().append( "Impl();\n        " );
                    context().T().append( self.getName() );
                    context().T().append( ".addAll(" );
                    context().T().append( self.getClass_name() );
                    context().T().append( "_extent);\n        return " );
                    context().T().append( self.getName() );
                    context().T().append( ";\n    }\n" );
                }

            };
        case "component/t.relationshippopulationselector.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    RelationshipPopulationSelector self = (RelationshipPopulationSelector)symbols[0];
                    context().T().append( "    private IRelationshipSet " );
                    context().T().append( self.getRel_name() );
                    context().T().append( "_extent;\n    public IRelationshipSet " );
                    context().T().append( self.getName() );
                    context().T().append( "() throws XtumlException {\n        return " );
                    context().T().append( self.getRel_name() );
                    context().T().append( "_extent;\n    }\n" );
                }

            };
        case "component/t.utility.impl.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String imports = (String)symbols[0];
                    Utility self = (Utility)symbols[1];
                    String utility_functions = (String)symbols[2];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ".impl;\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic class " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl<C extends IComponent<C>> extends Utility<C> implements " );
                    context().T().append( self.getName() );
                    context().T().append( " {\n\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( "Impl( C context ) {\n        super( context );\n    }\n\n" );
                    context().T().append( utility_functions );
                    context().T().append( "\n\n}\n" );
                }

            };
        case "component/t.utility.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String imports = (String)symbols[0];
                    Utility self = (Utility)symbols[1];
                    String utility_functions = (String)symbols[2];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ";\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic interface " );
                    context().T().append( self.getName() );
                    context().T().append( " {\n\n" );
                    context().T().append( utility_functions );
                    context().T().append( "\n\n}\n" );
                }

            };
        case "component/t.utilityfunction.int.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String parameter_list = (String)symbols[0];
                    UtilityFunction self = (UtilityFunction)symbols[1];
                    String type_name = (String)symbols[2];
                    context().T().append( "    public " );
                    context().T().append( type_name );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( "(" );
                    context().T().append( parameter_list );
                    context().T().append( ");\n" );
                }

            };
        case "component/t.utilityfunction.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String body = (String)symbols[0];
                    String parameter_list = (String)symbols[1];
                    UtilityFunction self = (UtilityFunction)symbols[2];
                    String type_name = (String)symbols[3];
                    context().T().append( "    public " );
                    context().T().append( type_name );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( "(" );
                    context().T().append( parameter_list );
                    context().T().append( ") " );
                    context().T().append( body );
                    context().T().append( "\n" );
                }

            };
        case "component/t.utilityreference.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    UtilityReference self = (UtilityReference)symbols[0];
                    context().T().append( "    private " );
                    context().T().append( self.getUtility_name() );
                    context().T().append( " " );
                    context().T().append( self.getUtility_name() );
                    context().T().append( ";\n    public " );
                    context().T().append( self.getUtility_name() );
                    context().T().append( " " );
                    context().T().append( self.getUtility_name() );
                    context().T().append( "() {\n        if ( null == " );
                    context().T().append( self.getUtility_name() );
                    context().T().append( " ) " );
                    context().T().append( self.getUtility_name() );
                    context().T().append( " = new " );
                    context().T().append( self.getUtility_name() );
                    context().T().append( "Impl<>( this );\n        return " );
                    context().T().append( self.getUtility_name() );
                    context().T().append( ";\n    }\n" );
                }

            };
        case "component/t.version.properties":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    ComponentDefinition self = (ComponentDefinition)symbols[0];
                    context().T().append( "version=" );
                    context().T().append( self.getVersion() );
                    context().T().append( "\nversion_date=" );
                    context().T().append( self.getVersion_date() );
                    context().T().append( "\n" );
                }

            };
        case "expression/t.actualparameter.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String expression_body = (String)symbols[0];
                    context().T().append( expression_body );
                    context().T().append( "" );
                }

            };
        case "expression/t.any.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String root_expression_body = (String)symbols[0];
                    context().T().append( root_expression_body );
                    context().T().append( ".any()" );
                }

            };
        case "expression/t.arrayelementreference.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String index_expression_body = (String)symbols[0];
                    String root_expression_body = (String)symbols[1];
                    context().T().append( root_expression_body );
                    context().T().append( "[" );
                    context().T().append( index_expression_body );
                    context().T().append( "]" );
                }

            };
        case "expression/t.arraylengthaccess.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String root_expression_body = (String)symbols[0];
                    context().T().append( root_expression_body );
                    context().T().append( ".length" );
                }

            };
        case "expression/t.attributeaccess.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String accessor = (String)symbols[0];
                    String root_expression_body = (String)symbols[1];
                    context().T().append( root_expression_body );
                    context().T().append( "." );
                    context().T().append( accessor );
                    context().T().append( "()" );
                }

            };
        case "expression/t.binaryoperation.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String left_operand_body = (String)symbols[0];
                    String operator = (String)symbols[1];
                    String right_operand_body = (String)symbols[2];
                    BinaryOperation self = (BinaryOperation)symbols[3];
                    if ( ( StringUtil.inequality(self.getCast(), "") ) ) {
                        context().T().append( "((" );
                        context().T().append( self.getCast() );
                        context().T().append( ")" );
                    }
                    if ( ( self.getInvocation() ) ) {
                        if ( ( self.getUtil() ) ) {
                            context().T().append( operator );
                            context().T().append( "(" );
                            context().T().append( left_operand_body );
                            context().T().append( ", " );
                            context().T().append( right_operand_body );
                            context().T().append( ")" );
                        }
                        else {
                            context().T().append( left_operand_body );
                            context().T().append( "." );
                            context().T().append( operator );
                            context().T().append( "(" );
                            context().T().append( right_operand_body );
                            context().T().append( ")" );
                        }
                    }
                    else {
                        context().T().append( left_operand_body );
                        context().T().append( " " );
                        context().T().append( operator );
                        context().T().append( " " );
                        context().T().append( right_operand_body );
                        context().T().append( "" );
                    }
                    if ( ( StringUtil.inequality(self.getCast(), "") ) ) {
                        context().T().append( ")" );
                    }
                }

            };
        case "expression/t.constantreference.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    boolean is_string = (boolean)symbols[0];
                    ConstantReference self = (ConstantReference)symbols[1];
                    if ( ( is_string ) ) {
                        context().T().append( "\"" );
                        context().T().append( self.getValue() );
                        context().T().append( "\"" );
                    }
                    else {
                        context().T().append( self.getValue() );
                        context().T().append( "" );
                    }
                }

            };
        case "expression/t.creation.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    Creation self = (Creation)symbols[0];
                    context().T().append( self.getClass_name() );
                    context().T().append( "Impl.create( context() )" );
                }

            };
        case "expression/t.enumeratorreference.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    EnumeratorReference self = (EnumeratorReference)symbols[0];
                    context().T().append( self.getEnum_type_name() );
                    context().T().append( "." );
                    context().T().append( self.getEnum_name() );
                    context().T().append( "" );
                }

            };
        case "expression/t.eventcreation.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String evt_expr = (String)symbols[0];
                    EventCreation self = (EventCreation)symbols[1];
                    String target_expr = (String)symbols[2];
                    context().T().append( evt_expr );
                    context().T().append( ".to" );
                    if ( ( self.getTo_self() ) ) {
                        context().T().append( "Self" );
                    }
                    context().T().append( "(" );
                    context().T().append( target_expr );
                    context().T().append( ")" );
                }

            };
        case "expression/t.invocation.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String base_name = (String)symbols[0];
                    boolean is_event_creation = (boolean)symbols[1];
                    String parameter_list = (String)symbols[2];
                    Invocation self = (Invocation)symbols[3];
                    if ( ( is_event_creation ) ) {
                        context().T().append( "new " );
                        context().T().append( base_name );
                        context().T().append( "." );
                        context().T().append( self.getInvoked_name() );
                        context().T().append( "(getRunContext(), context().getId()" );
                        if ( ( StringUtil.inequality("", parameter_list) ) ) {
                            context().T().append( ", " );
                            context().T().append( parameter_list );
                            context().T().append( "" );
                        }
                        context().T().append( ")" );
                    }
                    else {
                        context().T().append( base_name );
                        context().T().append( "." );
                        context().T().append( self.getInvoked_name() );
                        context().T().append( "(" );
                        context().T().append( parameter_list );
                        context().T().append( ")" );
                    }
                }

            };
        case "expression/t.literal.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    boolean is_string = (boolean)symbols[0];
                    Literal self = (Literal)symbols[1];
                    if ( ( is_string ) ) {
                        context().T().append( "\"" );
                        context().T().append( self.getValue() );
                        context().T().append( "\"" );
                    }
                    else {
                        context().T().append( self.getValue() );
                        context().T().append( "" );
                    }
                }

            };
        case "expression/t.namedreference.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    NamedReference self = (NamedReference)symbols[0];
                    context().T().append( self.getName() );
                    context().T().append( "" );
                }

            };
        case "expression/t.parameterreference.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    ParameterReference self = (ParameterReference)symbols[0];
                    context().T().append( self.getParam_name() );
                    context().T().append( "" );
                }

            };
        case "expression/t.parenthesizedexpression.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String root_expression_body = (String)symbols[0];
                    context().T().append( "( " );
                    context().T().append( root_expression_body );
                    context().T().append( " )" );
                }

            };
        case "expression/t.promotion.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String cast_function = (String)symbols[0];
                    String root_expression_body = (String)symbols[1];
                    Promotion self = (Promotion)symbols[2];
                    String type_name = (String)symbols[3];
                    if ( ( self.getCast() ) ) {
                        if ( ( StringUtil.equality("", cast_function) ) ) {
                            context().T().append( "((" );
                            context().T().append( type_name );
                            context().T().append( ")(" );
                            context().T().append( root_expression_body );
                            context().T().append( "))" );
                        }
                        else {
                            context().T().append( root_expression_body );
                            context().T().append( "." );
                            context().T().append( cast_function );
                            context().T().append( "()" );
                        }
                    }
                    else {
                        context().T().append( "new " );
                        context().T().append( type_name );
                        context().T().append( "(" );
                        context().T().append( root_expression_body );
                        context().T().append( ")" );
                    }
                }

            };
        case "expression/t.selected.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    Selected self = (Selected)symbols[0];
                    context().T().append( "((" );
                    context().T().append( self.getCast() );
                    context().T().append( ")selected)" );
                }

            };
        case "expression/t.selectfrominstances.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    SelectFromInstances self = (SelectFromInstances)symbols[0];
                    context().T().append( "context()." );
                    context().T().append( self.getSelector_name() );
                    context().T().append( "()" );
                }

            };
        case "expression/t.selectrelated.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String root_expression_body = (String)symbols[0];
                    SelectRelated self = (SelectRelated)symbols[1];
                    context().T().append( root_expression_body );
                    context().T().append( "." );
                    context().T().append( self.getSelector_name() );
                    context().T().append( "()" );
                }

            };
        case "expression/t.unaryoperation.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String operand_body = (String)symbols[0];
                    UnaryOperation self = (UnaryOperation)symbols[1];
                    if ( ( self.getInvocation() ) ) {
                        context().T().append( operand_body );
                        context().T().append( "." );
                        context().T().append( self.getOperator() );
                        context().T().append( "()" );
                    }
                    else {
                        context().T().append( self.getOperator() );
                        context().T().append( operand_body );
                        context().T().append( "" );
                    }
                }

            };
        case "expression/t.variablereference.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    VariableReference self = (VariableReference)symbols[0];
                    String type_name = (String)symbols[1];
                    String var_prefix = (String)symbols[2];
                    boolean var_readonly = (boolean)symbols[3];
                    if ( ( self.getDeclaration() ) ) {
                        if ( ( var_readonly ) ) {
                            context().T().append( "final " );
                        }
                        context().T().append( type_name );
                        context().T().append( " " );
                    }
                    context().T().append( var_prefix );
                    context().T().append( self.getVar_name() );
                    context().T().append( "" );
                }

            };
        case "expression/t.where.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String accessor = (String)symbols[0];
                    String root_expression_body = (String)symbols[1];
                    Where self = (Where)symbols[2];
                    boolean sort_descending = (boolean)symbols[3];
                    boolean sorted = (boolean)symbols[4];
                    boolean use_util = (boolean)symbols[5];
                    String util_name = (String)symbols[6];
                    String where_expression_body = (String)symbols[7];
                    if ( ( ( StringUtil.equality("many", self.getMultiplicity()) ) || ( StringUtil.equality("one", self.getMultiplicity()) ) ) ) {
                        context().T().append( "((" );
                        context().T().append( self.getCast() );
                        context().T().append( ")" );
                    }
                    context().T().append( root_expression_body );
                    context().T().append( "" );
                    if ( ( sorted ) ) {
                        context().T().append( ".sorted((_a, _b) -> {try {int comp = " );
                        if ( ( use_util ) ) {
                            context().T().append( util_name );
                            context().T().append( ".compareTo(_a." );
                            context().T().append( accessor );
                            context().T().append( "(), _b." );
                            context().T().append( accessor );
                            context().T().append( "())" );
                        }
                        else {
                            context().T().append( "_a." );
                            context().T().append( accessor );
                            context().T().append( "().compareTo(_b." );
                            context().T().append( accessor );
                            context().T().append( "())" );
                        }
                        context().T().append( ";return comp == 0 ? _a.compareTo(_b) : comp;} catch (XtumlException _e) {return 0;}}\n" );
                        if ( ( sort_descending ) ) {
                            context().T().append( ", false" );
                        }
                        context().T().append( ")" );
                    }
                    if ( ( StringUtil.equality("one", self.getMultiplicity()) ) ) {
                        context().T().append( ".oneWhere(selected -> " );
                        context().T().append( where_expression_body );
                        context().T().append( "))" );
                    }
                    else if ( ( StringUtil.equality("any", self.getMultiplicity()) ) ) {
                        context().T().append( ".anyWhere(selected -> " );
                        context().T().append( where_expression_body );
                        context().T().append( ")" );
                    }
                    else {
                        context().T().append( ".where(selected -> " );
                        context().T().append( where_expression_body );
                        context().T().append( "))" );
                    }
                }

            };
        case "file/t.generalfile.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    GeneralFile self = (GeneralFile)symbols[0];
                    context().T().append( self.getContents() );
                    context().T().append( "" );
                }

            };
        case "file/t.typeimport.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    TypeImport self = (TypeImport)symbols[0];
                    context().T().append( "import " );
                    context().T().append( self.getFully_qualified_name() );
                    context().T().append( ";\n" );
                }

            };
        case "interface/t.interface.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String from_provider_message_block = (String)symbols[0];
                    String imports = (String)symbols[1];
                    Iface self = (Iface)symbols[2];
                    String to_provider_message_block = (String)symbols[3];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ";\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic interface " );
                    context().T().append( self.getName() );
                    context().T().append( " {\n\n    // to provider messages\n" );
                    context().T().append( to_provider_message_block );
                    context().T().append( "\n\n    // from provider messages\n" );
                    context().T().append( from_provider_message_block );
                    context().T().append( "\n\n}\n" );
                }

            };
        case "interface/t.message.deliver.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String message_parameter_list = (String)symbols[0];
                    PortMessage self = (PortMessage)symbols[1];
                    String type_name = (String)symbols[2];
                    context().T().append( "            case " );
                    context().T().append( self.getIface_name() );
                    context().T().append( ".SIGNAL_NO_" );
                    context().T().append( context().T().sub( "u", self.getMsg_name() ) );
                    context().T().append( ":\n" );
                    if ( ( StringUtil.equality(type_name, "void") ) ) {
                        context().T().append( "                " );
                        context().T().append( self.getMsg_name() );
                        context().T().append( "(" );
                        context().T().append( message_parameter_list );
                        context().T().append( ");\n                return null;\n" );
                    }
                    else {
                        context().T().append( "                return " );
                        context().T().append( self.getMsg_name() );
                        context().T().append( "(" );
                        context().T().append( message_parameter_list );
                        context().T().append( ");\n" );
                    }
                }

            };
        case "interface/t.message.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String invocation_parameter_list = (String)symbols[0];
                    String parameter_list = (String)symbols[1];
                    Message self = (Message)symbols[2];
                    String type_name = (String)symbols[3];
                    context().T().append( "    public static final int SIGNAL_NO_" );
                    context().T().append( context().T().sub( "u", self.getName() ) );
                    context().T().append( " = " );
                    context().T().append( self.getId() );
                    context().T().append( ";\n    public static class S" );
                    context().T().append( context().T().sub( "c", self.getName() ) );
                    context().T().append( " extends Message {\n" );
                    if ( ( StringUtil.inequality("", parameter_list) ) ) {
                        context().T().append( "        public S" );
                        context().T().append( context().T().sub( "c", self.getName() ) );
                        context().T().append( "(" );
                        context().T().append( parameter_list );
                        context().T().append( ") {\n            super(new Object[]{" );
                        context().T().append( invocation_parameter_list );
                        context().T().append( "});\n        }\n" );
                    }
                    context().T().append( "        @Override\n        public int getId() {\n            return SIGNAL_NO_" );
                    context().T().append( context().T().sub( "u", self.getName() ) );
                    context().T().append( ";\n        }\n \n    }\n    public " );
                    context().T().append( type_name );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( "(" );
                    context().T().append( parameter_list );
                    context().T().append( ") throws XtumlException;\n" );
                }

            };
        case "interface/t.port.http.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String endpoint = (String)symbols[0];
                    context().T().append( "    @Override\n    public String getEndpoint() {\n        return \"" );
                    context().T().append( endpoint );
                    context().T().append( "\";\n    }\n" );
                }

            };
        case "interface/t.port.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String extra_parameters = (String)symbols[0];
                    String imports = (String)symbols[1];
                    String inbound_message_block = (String)symbols[2];
                    String message_switch_block = (String)symbols[3];
                    String outbound_message_block = (String)symbols[4];
                    Port self = (Port)symbols[5];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ";\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic class " );
                    context().T().append( self.getName() );
                    context().T().append( " extends " );
                    context().T().append( self.getBase_class() );
                    context().T().append( "<" );
                    context().T().append( self.getComp_name() );
                    context().T().append( "> implements " );
                    context().T().append( self.getIface_name() );
                    context().T().append( " {\n\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( "( " );
                    context().T().append( self.getComp_name() );
                    context().T().append( " context, IPort<?> peer ) {\n        super( context, peer );\n    }\n\n    // inbound messages\n" );
                    context().T().append( inbound_message_block );
                    context().T().append( "\n\n    // outbound messages\n" );
                    context().T().append( outbound_message_block );
                    context().T().append( "\n\n    @Override\n    public Object deliver( IMessage message ) throws XtumlException {\n        if ( null == message ) throw new BadArgumentException( \"Cannot deliver null message.\" );\n        switch ( message.getId() ) {\n" );
                    context().T().append( message_switch_block );
                    context().T().append( "        default:\n            throw new BadArgumentException( \"Message not implemented by this port.\" );\n        }\n    }\n\n" );
                    context().T().append( extra_parameters );
                    context().T().append( "\n\n    @Override\n    public String getName() {\n        return \"" );
                    context().T().append( self.getPort_name() );
                    context().T().append( "\";\n    }\n\n}\n" );
                }

            };
        case "interface/t.portaccessor.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    Port self = (Port)symbols[0];
                    context().T().append( "    private " );
                    context().T().append( self.getName() );
                    context().T().append( " " );
                    context().T().append( self.getName() );
                    context().T().append( ";\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( " " );
                    context().T().append( self.getPort_name() );
                    context().T().append( "() {\n        if ( null == " );
                    context().T().append( self.getName() );
                    context().T().append( " ) " );
                    context().T().append( self.getName() );
                    context().T().append( " = new " );
                    context().T().append( self.getImpl_class() );
                    context().T().append( "( this, null );\n        return " );
                    context().T().append( self.getName() );
                    context().T().append( ";\n    }\n" );
                }

            };
        case "interface/t.portmessage.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String body = (String)symbols[0];
                    boolean inbound = (boolean)symbols[1];
                    String invocation_parameter_list = (String)symbols[2];
                    String parameter_list = (String)symbols[3];
                    PortMessage self = (PortMessage)symbols[4];
                    String type_name = (String)symbols[5];
                    context().T().append( "    public " );
                    context().T().append( type_name );
                    context().T().append( " " );
                    context().T().append( self.getMsg_name() );
                    context().T().append( "(" );
                    context().T().append( parameter_list );
                    context().T().append( ") throws XtumlException " );
                    if ( ( inbound ) ) {
                        context().T().append( body );
                        context().T().append( "\n" );
                    }
                    else {
                        context().T().append( "{\n        if ( satisfied() ) {\n" );
                        if ( ( StringUtil.equality(type_name, "void") ) ) {
                            context().T().append( "            send(new " );
                            context().T().append( self.getIface_name() );
                            context().T().append( ".S" );
                            context().T().append( context().T().sub( "c", self.getMsg_name() ) );
                            context().T().append( "(" );
                            context().T().append( invocation_parameter_list );
                            context().T().append( "));\n" );
                        }
                        else {
                            context().T().append( "            return (" );
                            context().T().append( type_name );
                            context().T().append( ") syncSend(new " );
                            context().T().append( self.getIface_name() );
                            context().T().append( ".S" );
                            context().T().append( context().T().sub( "c", self.getMsg_name() ) );
                            context().T().append( "(" );
                            context().T().append( invocation_parameter_list );
                            context().T().append( "));\n" );
                        }
                        context().T().append( "        } else " );
                        context().T().append( body );
                        context().T().append( "    }\n" );
                    }
                }

            };
        case "invocable/t.codeblock.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    boolean include_suffix = (boolean)symbols[0];
                    String indent = (String)symbols[1];
                    boolean is_else_if = (boolean)symbols[2];
                    CodeBlock self = (CodeBlock)symbols[3];
                    String statements = (String)symbols[4];
                    if ( ( is_else_if ) ) {
                        context().T().append( statements );
                        context().T().append( "" );
                    }
                    else {
                        context().T().append( "{\n" );
                        context().T().append( self.getPrefix() );
                        context().T().append( statements );
                        context().T().append( "" );
                        if ( ( include_suffix ) ) {
                            context().T().append( self.getSuffix() );
                            context().T().append( "" );
                        }
                        context().T().append( indent );
                        context().T().append( "}\n" );
                    }
                }

            };
        case "loader/t.attributecomparison.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    AttributeComparison self = (AttributeComparison)symbols[0];
                    if ( ( self.getPrimitive() ) ) {
                        context().T().append( "selected." );
                        context().T().append( self.getPart_accessor() );
                        context().T().append( " == form." );
                        context().T().append( self.getForm_accessor() );
                        context().T().append( "" );
                    }
                    else {
                        if ( ( self.getIs_string() ) ) {
                            context().T().append( "StringUtil.equality( selected." );
                            context().T().append( self.getPart_accessor() );
                            context().T().append( ", form." );
                            context().T().append( self.getForm_accessor() );
                            context().T().append( " )" );
                        }
                        else {
                            context().T().append( "selected." );
                            context().T().append( self.getPart_accessor() );
                            context().T().append( ".equality( form." );
                            context().T().append( self.getForm_accessor() );
                            context().T().append( " )" );
                        }
                    }
                }

            };
        case "loader/t.attributeserializer.sep.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    context().T().append( "        out.print(\",\");\n" );
                }

            };
        case "loader/t.batchrelator.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attribute_comparisons = (String)symbols[0];
                    BatchRelator self = (BatchRelator)symbols[1];
                    context().T().append( "    public void batch_relate_" );
                    context().T().append( self.getRel_name() );
                    context().T().append( "() throws XtumlException {\n        for ( " );
                    context().T().append( self.getForm_name() );
                    context().T().append( " form : population." );
                    context().T().append( self.getForm_name() );
                    context().T().append( "_instances() ) {\n" );
                    if ( ( self.getUnconditional() ) ) {
                        context().T().append( "            population.relate_" );
                        context().T().append( self.getRel_name() );
                        context().T().append( "( form, population." );
                        context().T().append( self.getPart_name() );
                        context().T().append( "_instances().getById" );
                        context().T().append( context().T().sub( "t", self.getId_num() ) );
                        context().T().append( "(new InstanceIdentifier(" );
                        context().T().append( attribute_comparisons );
                        context().T().append( ")));\n" );
                    }
                    else {
                        context().T().append( "            " );
                        context().T().append( self.getPart_name() );
                        context().T().append( " part = population." );
                        context().T().append( self.getPart_name() );
                        context().T().append( "_instances().getById" );
                        context().T().append( context().T().sub( "t", self.getId_num() ) );
                        context().T().append( "(new InstanceIdentifier(" );
                        context().T().append( attribute_comparisons );
                        context().T().append( "));\n            if ( !part.isEmpty() ) population.relate_" );
                        context().T().append( self.getRel_name() );
                        context().T().append( "( form, part );\n" );
                    }
                    context().T().append( "        }\n    }\n" );
                }

            };
        case "loader/t.booleanloader.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    int value_index = (int)symbols[0];
                    context().T().append( "(int)values.get(" );
                    context().T().append( context().T().sub( "t", value_index ) );
                    context().T().append( ") == 1 ? true : false" );
                }

            };
        case "loader/t.booleanserializer.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String cast = (String)symbols[0];
                    BooleanSerializer self = (BooleanSerializer)symbols[1];
                    if ( ( StringUtil.equality("", cast) ) ) {
                        context().T().append( "        out.printf( \"%d\", " );
                        context().T().append( context().T().sub( "l", self.getClass_name() ) );
                        context().T().append( "_inst." );
                        context().T().append( self.getValue() );
                        context().T().append( " ? 1 : 0 );\n" );
                    }
                    else {
                        context().T().append( "        out.printf( \"%d\", (" );
                        context().T().append( cast );
                        context().T().append( context().T().sub( "l", self.getClass_name() ) );
                        context().T().append( "_inst." );
                        context().T().append( self.getValue() );
                        context().T().append( ") ? 1 : 0 );\n" );
                    }
                }

            };
        case "loader/t.classinstanceloader.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attribute_loaders = (String)symbols[0];
                    ClassInstanceLoader self = (ClassInstanceLoader)symbols[1];
                    context().T().append( "        case \"" );
                    context().T().append( self.getClass_key_letters() );
                    context().T().append( "\":\n            " );
                    context().T().append( self.getClass_name() );
                    context().T().append( "Impl.create(population, " );
                    context().T().append( attribute_loaders );
                    context().T().append( ");\n            break;\n" );
                }

            };
        case "loader/t.classinstanceserializer.def.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attribute_serializers = (String)symbols[0];
                    ClassInstanceSerializer self = (ClassInstanceSerializer)symbols[1];
                    context().T().append( "    public void serialize_" );
                    context().T().append( self.getClass_name() );
                    context().T().append( "( " );
                    context().T().append( self.getClass_name() );
                    context().T().append( " " );
                    context().T().append( context().T().sub( "l", self.getClass_name() ) );
                    context().T().append( "_inst, PrintStream out ) throws XtumlException {\n        out.print( \"INSERT INTO " );
                    context().T().append( self.getClass_key_letters() );
                    context().T().append( " VALUES(\" );\n" );
                    context().T().append( attribute_serializers );
                    context().T().append( "        out.println( \");\" );\n    }\n" );
                }

            };
        case "loader/t.classinstanceserializer.init.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    context().T().append( "" );
                }

            };
        case "loader/t.classinstanceserializer.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    ClassInstanceSerializer self = (ClassInstanceSerializer)symbols[0];
                    context().T().append( "        for ( " );
                    context().T().append( self.getClass_name() );
                    context().T().append( " " );
                    context().T().append( context().T().sub( "l", self.getClass_name() ) );
                    context().T().append( "_inst : population." );
                    context().T().append( self.getClass_name() );
                    context().T().append( "_instances() ) serialize_" );
                    context().T().append( self.getClass_name() );
                    context().T().append( "( " );
                    context().T().append( context().T().sub( "l", self.getClass_name() ) );
                    context().T().append( "_inst, out );\n" );
                }

            };
        case "loader/t.enumeratorloader.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    EnumeratorLoader self = (EnumeratorLoader)symbols[0];
                    int value_index = (int)symbols[1];
                    context().T().append( self.getType_name() );
                    context().T().append( ".deserialize( (int)values.get(" );
                    context().T().append( context().T().sub( "t", value_index ) );
                    context().T().append( ") )" );
                }

            };
        case "loader/t.eventinstanceloader.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attribute_loaders = (String)symbols[0];
                    String class_name = (String)symbols[1];
                    String event_handle = (String)symbols[2];
                    String event_target = (String)symbols[3];
                    String population_id = (String)symbols[4];
                    EventInstanceLoader self = (EventInstanceLoader)symbols[5];
                    context().T().append( "        case \"" );
                    context().T().append( self.getEvt_class_name() );
                    context().T().append( "\":\n            new " );
                    context().T().append( class_name );
                    context().T().append( "(population.getRunContext(), " );
                    context().T().append( population_id );
                    context().T().append( "" );
                    if ( ( StringUtil.inequality("", attribute_loaders) ) ) {
                        context().T().append( ", " );
                        context().T().append( attribute_loaders );
                        context().T().append( "" );
                    }
                    context().T().append( ").to(" );
                    context().T().append( event_handle );
                    context().T().append( ", population." );
                    context().T().append( self.getClass_name() );
                    context().T().append( "_instances().anyWhere(selected -> selected.getInstanceId().equality(" );
                    context().T().append( event_target );
                    context().T().append( ")));\n            break;\n" );
                }

            };
        case "loader/t.eventinstanceserializer.def.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attribute_serializers = (String)symbols[0];
                    String class_name = (String)symbols[1];
                    EventInstanceSerializer self = (EventInstanceSerializer)symbols[2];
                    context().T().append( "    public void serialize_" );
                    context().T().append( self.getClass_name() );
                    context().T().append( "( " );
                    context().T().append( class_name );
                    context().T().append( " " );
                    context().T().append( context().T().sub( "l", self.getClass_name() ) );
                    context().T().append( "_inst, PrintStream out ) throws XtumlException {\n        out.print( \"INSERT INTO " );
                    context().T().append( self.getClass_name() );
                    context().T().append( " VALUES(\" );\n" );
                    context().T().append( attribute_serializers );
                    context().T().append( "        out.println( \");\" );\n    }\n" );
                }

            };
        case "loader/t.eventinstanceserializer.init.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    context().T().append( "" );
                }

            };
        case "loader/t.eventinstanceserializer.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String class_name = (String)symbols[0];
                    EventInstanceSerializer self = (EventInstanceSerializer)symbols[1];
                    context().T().append( "        for ( IEvent " );
                    context().T().append( context().T().sub( "l", self.getClass_name() ) );
                    context().T().append( "_inst : population.getRunContext().getActiveEvents().where(selected -> selected instanceof " );
                    context().T().append( class_name );
                    context().T().append( ") ) serialize_" );
                    context().T().append( self.getClass_name() );
                    context().T().append( "( (" );
                    context().T().append( class_name );
                    context().T().append( ")" );
                    context().T().append( context().T().sub( "l", self.getClass_name() ) );
                    context().T().append( "_inst, out );\n" );
                }

            };
        case "loader/t.generalloader.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    GeneralLoader self = (GeneralLoader)symbols[0];
                    int value_index = (int)symbols[1];
                    if ( ( StringUtil.equality("boolean", self.getType_name()) ) ) {
                        context().T().append( "false" );
                    }
                    else if ( ( StringUtil.equality("int", self.getType_name()) ) ) {
                        context().T().append( "0" );
                    }
                    else if ( ( StringUtil.equality("double", self.getType_name()) ) ) {
                        context().T().append( "0d" );
                    }
                    else {
                        if ( ( self.getLoad_value() ) ) {
                            context().T().append( self.getType_name() );
                            context().T().append( ".deserialize(values.get(" );
                            context().T().append( context().T().sub( "t", value_index ) );
                            context().T().append( "))" );
                        }
                        else {
                            context().T().append( "new " );
                            context().T().append( self.getType_name() );
                            context().T().append( "()" );
                        }
                    }
                }

            };
        case "loader/t.generalserializer.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String cast = (String)symbols[0];
                    GeneralSerializer self = (GeneralSerializer)symbols[1];
                    if ( ( StringUtil.equality("", cast) ) ) {
                        context().T().append( "        out.printf( \"%s\", " );
                        context().T().append( context().T().sub( "l", self.getClass_name() ) );
                        context().T().append( "_inst." );
                        context().T().append( self.getValue() );
                        context().T().append( ".serialize() );\n" );
                    }
                    else {
                        context().T().append( "        out.printf( \"%s\", (" );
                        context().T().append( cast );
                        context().T().append( context().T().sub( "l", self.getClass_name() ) );
                        context().T().append( "_inst." );
                        context().T().append( self.getValue() );
                        context().T().append( ").serialize() );\n" );
                    }
                }

            };
        case "loader/t.integerloader.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    IntegerLoader self = (IntegerLoader)symbols[0];
                    int value_index = (int)symbols[1];
                    if ( ( self.getIs_long() ) ) {
                        context().T().append( "(long)values.get(" );
                        context().T().append( context().T().sub( "t", value_index ) );
                        context().T().append( ")" );
                    }
                    else {
                        context().T().append( "(int)values.get(" );
                        context().T().append( context().T().sub( "t", value_index ) );
                        context().T().append( ")" );
                    }
                }

            };
        case "loader/t.integerserializer.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String cast = (String)symbols[0];
                    IntegerSerializer self = (IntegerSerializer)symbols[1];
                    if ( ( StringUtil.equality("", cast) ) ) {
                        context().T().append( "        out.printf( \"%d\", " );
                        context().T().append( context().T().sub( "l", self.getClass_name() ) );
                        context().T().append( "_inst." );
                        context().T().append( self.getValue() );
                        context().T().append( " );\n" );
                    }
                    else {
                        context().T().append( "        out.printf( \"%d\", (" );
                        context().T().append( cast );
                        context().T().append( context().T().sub( "l", self.getClass_name() ) );
                        context().T().append( "_inst." );
                        context().T().append( self.getValue() );
                        context().T().append( ")" );
                        if ( ( StringUtil.inequality("", self.getValue2()) ) ) {
                            context().T().append( "." );
                            context().T().append( self.getValue2() );
                            context().T().append( "" );
                        }
                        context().T().append( " );\n" );
                    }
                }

            };
        case "loader/t.linkloader.multi.relate.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    boolean declare = (boolean)symbols[0];
                    String form_class = (String)symbols[1];
                    String formvar = (String)symbols[2];
                    String part_class = (String)symbols[3];
                    String partvar = (String)symbols[4];
                    String rel_name = (String)symbols[5];
                    if ( ( declare ) ) {
                        context().T().append( "            " );
                        context().T().append( part_class );
                        context().T().append( " " );
                        context().T().append( partvar );
                        context().T().append( " = population." );
                        context().T().append( part_class );
                        context().T().append( "_instances().getByInstanceId( UniqueId.deserialize(instids.get(1)) );\n" );
                    }
                    context().T().append( "            " );
                    context().T().append( form_class );
                    context().T().append( " " );
                    context().T().append( formvar );
                    context().T().append( " = population." );
                    context().T().append( form_class );
                    context().T().append( "_instances().getByInstanceId( UniqueId.deserialize(instids.get(0)) );\n            if ( ! " );
                    context().T().append( formvar );
                    context().T().append( ".isEmpty() ) {\n                population.relate_" );
                    context().T().append( rel_name );
                    context().T().append( "( " );
                    context().T().append( formvar );
                    context().T().append( ", " );
                    context().T().append( partvar );
                    context().T().append( " ); \n                break;\n            }\n" );
                }

            };
        case "loader/t.linkloader.ref.relate.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String form_class = (String)symbols[0];
                    String formvar = (String)symbols[1];
                    int index = (int)symbols[2];
                    String part_class = (String)symbols[3];
                    String partvar = (String)symbols[4];
                    String rel_name = (String)symbols[5];
                    String vtyp = (String)symbols[6];
                    if ( ( index == 1 ) ) {
                        context().T().append( "            " );
                        context().T().append( form_class );
                        context().T().append( " " );
                        context().T().append( formvar );
                        context().T().append( " = population." );
                        context().T().append( form_class );
                        context().T().append( "_instances().getByInstanceId( UniqueId.deserialize(instids.get(0)) );\n" );
                    }
                    context().T().append( "	        " );
                    context().T().append( vtyp );
                    context().T().append( partvar );
                    context().T().append( " = population." );
                    context().T().append( part_class );
                    context().T().append( "_instances().getByInstanceId( UniqueId.deserialize(instids.get(" );
                    context().T().append( index );
                    context().T().append( ")) );\n            population.relate_" );
                    context().T().append( rel_name );
                    context().T().append( "( " );
                    context().T().append( formvar );
                    context().T().append( ", " );
                    context().T().append( partvar );
                    context().T().append( " );\n" );
                }

            };
        case "loader/t.linkloader.relate.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String relates = (String)symbols[0];
                    String rnum_str = (String)symbols[1];
                    context().T().append( "        case " );
                    context().T().append( rnum_str );
                    context().T().append( ":\n" );
                    context().T().append( relates );
                    context().T().append( "            break;\n" );
                }

            };
        case "loader/t.linkserializer.invoke.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String class_name = (String)symbols[0];
                    String rnum_str = (String)symbols[1];
                    context().T().append( "        for ( " );
                    context().T().append( class_name );
                    context().T().append( " " );
                    context().T().append( context().T().sub( "l", class_name ) );
                    context().T().append( "_inst : population." );
                    context().T().append( class_name );
                    context().T().append( "_instances() ) serialize_" );
                    context().T().append( rnum_str );
                    context().T().append( "( " );
                    context().T().append( context().T().sub( "l", class_name ) );
                    context().T().append( "_inst, out );\n" );
                }

            };
        case "loader/t.linkserializer.method.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String class_name = (String)symbols[0];
                    String init = (String)symbols[1];
                    String referred_ids = (String)symbols[2];
                    String rnum_str = (String)symbols[3];
                    String self_serialize = (String)symbols[4];
                    context().T().append( "    public void serialize_" );
                    context().T().append( rnum_str );
                    context().T().append( "( " );
                    context().T().append( class_name );
                    context().T().append( " " );
                    context().T().append( context().T().sub( "l", class_name ) );
                    context().T().append( "_inst, PrintStream out ) throws XtumlException {\n" );
                    context().T().append( init );
                    context().T().append( "\n    " );
                    context().T().append( self_serialize );
                    context().T().append( " " );
                    context().T().append( referred_ids );
                    context().T().append( "           out.println( \");\" );\n    	}\n    }\n" );
                }

            };
        case "loader/t.linkserializer.reference.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String ref_out = (String)symbols[0];
                    context().T().append( "           out.print(\",\");\n    " );
                    context().T().append( ref_out );
                    context().T().append( " " );
                }

            };
        case "loader/t.multilinkserializer.init.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String iterator = (String)symbols[0];
                    String link_type = (String)symbols[1];
                    String referred_name = (String)symbols[2];
                    String referring_class = (String)symbols[3];
                    String rnum_str = (String)symbols[4];
                    String selector_name = (String)symbols[5];
                    String set_type_name = (String)symbols[6];
                    context().T().append( "        " );
                    context().T().append( set_type_name );
                    context().T().append( " links = " );
                    context().T().append( context().T().sub( "l", referring_class ) );
                    context().T().append( "_inst." );
                    context().T().append( selector_name );
                    context().T().append( "();\n        for ( " );
                    context().T().append( referred_name );
                    context().T().append( " " );
                    context().T().append( iterator );
                    context().T().append( "_inst : links ) {\n            out.print( \"" );
                    context().T().append( link_type );
                    context().T().append( " " );
                    context().T().append( rnum_str );
                    context().T().append( " IDS(\" ); " );
                }

            };
        case "loader/t.populationloader.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String batch_relator_definitions = (String)symbols[0];
                    String batch_relators = (String)symbols[1];
                    String imports = (String)symbols[2];
                    String instance_loaders = (String)symbols[3];
                    String instance_serializer_definitions = (String)symbols[4];
                    String instance_serializers = (String)symbols[5];
                    String link_serializer_definitions = (String)symbols[6];
                    String link_serializer_relates = (String)symbols[7];
                    String link_serializers = (String)symbols[8];
                    PopulationLoader self = (PopulationLoader)symbols[9];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ";\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic class " );
                    context().T().append( self.getName() );
                    context().T().append( " extends SqlLoader {\n\n    private " );
                    context().T().append( self.getComp_name() );
                    context().T().append( " population;\n\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( "( " );
                    context().T().append( self.getComp_name() );
                    context().T().append( " population ) {\n        super(population.getRunContext());\n        this.population = population;\n    }\n\n    @Override\n    public void insert(String tableName, List<Object> values) throws XtumlException {\n        switch ( tableName ) {\n" );
                    context().T().append( instance_loaders );
                    context().T().append( "        default:\n            //throw new XtumlException( \"Class not supported by this population.\" );\n            break;\n        }\n    }\n\n    @Override\n    public void link(Integer relNumber, List<Object> instids) throws XtumlException {\n    	switch ( relNumber ) {\n" );
                    context().T().append( link_serializer_relates );
                    context().T().append( "        default:\n            //throw new XtumlException( \"Cannot relate instances.\" );\n            break;\n        }\n    }\n\n    @Override\n    public void batchRelate() throws XtumlException {\n" );
                    context().T().append( batch_relators );
                    context().T().append( "    }\n\n" );
                    context().T().append( batch_relator_definitions );
                    context().T().append( "\n\n    @Override\n    public void serialize() throws XtumlException {\n        PrintStream out = new PrintStream(getOut());\n" );
                    context().T().append( instance_serializers );
                    context().T().append( "\n        //  association data\n" );
                    context().T().append( link_serializers );
                    context().T().append( "\n        out.flush();\n    }\n\n" );
                    context().T().append( instance_serializer_definitions );
                    context().T().append( "\n\n" );
                    context().T().append( link_serializer_definitions );
                    context().T().append( "\n\n}\n" );
                }

            };
        case "loader/t.realloader.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    int value_index = (int)symbols[0];
                    context().T().append( "(double)values.get(" );
                    context().T().append( context().T().sub( "t", value_index ) );
                    context().T().append( ")" );
                }

            };
        case "loader/t.realserializer.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String cast = (String)symbols[0];
                    RealSerializer self = (RealSerializer)symbols[1];
                    if ( ( StringUtil.equality("", cast) ) ) {
                        context().T().append( "        out.printf( \"%f\", " );
                        context().T().append( context().T().sub( "l", self.getClass_name() ) );
                        context().T().append( "_inst." );
                        context().T().append( self.getValue() );
                        context().T().append( " );\n" );
                    }
                    else {
                        context().T().append( "        out.printf( \"%f\", (" );
                        context().T().append( cast );
                        context().T().append( context().T().sub( "l", self.getClass_name() ) );
                        context().T().append( "_inst." );
                        context().T().append( self.getValue() );
                        context().T().append( ") );\n" );
                    }
                }

            };
        case "loader/t.singlelinkserializer.init.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String class_name = (String)symbols[0];
                    String link_type = (String)symbols[1];
                    String rnum_str = (String)symbols[2];
                    String selector_name = (String)symbols[3];
                    context().T().append( "        if ( !" );
                    context().T().append( context().T().sub( "l", class_name ) );
                    context().T().append( "_inst." );
                    context().T().append( selector_name );
                    context().T().append( "().isEmpty() ) {\n            out.print( \"" );
                    context().T().append( link_type );
                    context().T().append( " " );
                    context().T().append( rnum_str );
                    context().T().append( " IDS(\" ); " );
                }

            };
        case "loader/t.stringloader.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    int value_index = (int)symbols[0];
                    context().T().append( "(String)values.get(" );
                    context().T().append( context().T().sub( "t", value_index ) );
                    context().T().append( ")" );
                }

            };
        case "loader/t.stringserializer.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String cast = (String)symbols[0];
                    StringSerializer self = (StringSerializer)symbols[1];
                    if ( ( StringUtil.equality("", cast) ) ) {
                        context().T().append( "        out.printf( \"'%s'\", " );
                        context().T().append( context().T().sub( "l", self.getClass_name() ) );
                        context().T().append( "_inst." );
                        context().T().append( self.getValue() );
                        context().T().append( ".replaceAll( \"'\", \"''\" ) );\n" );
                    }
                    else {
                        context().T().append( "        out.printf( \"'%s'\", (" );
                        context().T().append( cast );
                        context().T().append( context().T().sub( "l", self.getClass_name() ) );
                        context().T().append( "_inst." );
                        context().T().append( self.getValue() );
                        context().T().append( ").replaceAll( \"'\", \"''\" ) );\n" );
                    }
                }

            };
        case "loader/t.timerinstanceloader.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attribute_loaders = (String)symbols[0];
                    TimerInstanceLoader self = (TimerInstanceLoader)symbols[1];
                    context().T().append( "        case \"" );
                    context().T().append( self.getClass_name() );
                    context().T().append( "\":\n            population.getRunContext().addTimer(new Timer(" );
                    context().T().append( attribute_loaders );
                    context().T().append( "));\n            break;\n" );
                }

            };
        case "loader/t.timerinstanceserializer.def.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attribute_serializers = (String)symbols[0];
                    TimerInstanceSerializer self = (TimerInstanceSerializer)symbols[1];
                    context().T().append( "    public void serialize_" );
                    context().T().append( self.getClass_name() );
                    context().T().append( "( Timer " );
                    context().T().append( context().T().sub( "l", self.getClass_name() ) );
                    context().T().append( "_inst, PrintStream out ) throws XtumlException {\n        out.print( \"INSERT INTO " );
                    context().T().append( self.getClass_name() );
                    context().T().append( " VALUES(\" );\n" );
                    context().T().append( attribute_serializers );
                    context().T().append( "        out.println( \");\" );\n    }\n" );
                }

            };
        case "loader/t.timerinstanceserializer.init.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    context().T().append( "" );
                }

            };
        case "loader/t.timerinstanceserializer.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    TimerInstanceSerializer self = (TimerInstanceSerializer)symbols[0];
                    context().T().append( "        for ( Timer " );
                    context().T().append( context().T().sub( "l", self.getClass_name() ) );
                    context().T().append( "_inst : population.getRunContext().getActiveTimers().where(selected -> selected.getPopulationId() == population.getId()) ) serialize_" );
                    context().T().append( self.getClass_name() );
                    context().T().append( "( " );
                    context().T().append( context().T().sub( "l", self.getClass_name() ) );
                    context().T().append( "_inst, out );\n" );
                }

            };
        case "loader/t.uniqueidserializer.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String class_name = (String)symbols[0];
                    String quote = (String)symbols[1];
                    String value = (String)symbols[2];
                    context().T().append( "        out.printf( \"" );
                    context().T().append( quote );
                    context().T().append( "%s" );
                    context().T().append( quote );
                    context().T().append( "\", " );
                    context().T().append( context().T().sub( "l", class_name ) );
                    context().T().append( "_inst." );
                    context().T().append( value );
                    context().T().append( ".serialize() );\n" );
                }

            };
        case "relationship/t.referentialattributeinitialization.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String form_accessor_name = (String)symbols[0];
                    String part_accessor_name = (String)symbols[1];
                    context().T().append( "            form." );
                    context().T().append( form_accessor_name );
                    context().T().append( "( part." );
                    context().T().append( part_accessor_name );
                    context().T().append( "() );\n" );
                }

            };
        case "relationship/t.relationshipmodifiers.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String attribute_propagations = (String)symbols[0];
                    String cardinality_check = (String)symbols[1];
                    String relationship_setters = (String)symbols[2];
                    String relationship_unsetters = (String)symbols[3];
                    ClassRelationship self = (ClassRelationship)symbols[4];
                    context().T().append( "    public void relate_" );
                    context().T().append( self.getName() );
                    context().T().append( "( " );
                    context().T().append( self.getForm_name() );
                    context().T().append( " form, " );
                    context().T().append( self.getPart_name() );
                    context().T().append( " part ) throws XtumlException {\n        if ( null == form || null == part ) throw new BadArgumentException( \"Null instances passed.\" );\n        if ( form.isEmpty() || part.isEmpty() ) throw new EmptyInstanceException( \"Cannot relate empty instances.\" );\n" );
                    context().T().append( cardinality_check );
                    context().T().append( "        if ( " );
                    context().T().append( self.getName() );
                    context().T().append( "_extent.add( new Relationship( form.getInstanceId(), part.getInstanceId() ) ) ) {\n" );
                    context().T().append( relationship_setters );
                    context().T().append( attribute_propagations );
                    context().T().append( "        }\n        else throw new ModelIntegrityException( \"Instances could not be related.\" );\n    }\n\n    public void unrelate_" );
                    context().T().append( self.getName() );
                    context().T().append( "( " );
                    context().T().append( self.getForm_name() );
                    context().T().append( " form, " );
                    context().T().append( self.getPart_name() );
                    context().T().append( " part ) throws XtumlException {\n        if ( null == form || null == part ) throw new BadArgumentException( \"Null instances passed.\" );\n        if ( form.isEmpty() || part.isEmpty() ) throw new EmptyInstanceException( \"Cannot unrelate empty instances.\" );\n        if ( " );
                    context().T().append( self.getName() );
                    context().T().append( "_extent.remove( " );
                    context().T().append( self.getName() );
                    context().T().append( "_extent.get( form.getInstanceId(), part.getInstanceId() ) ) ) {\n" );
                    context().T().append( relationship_unsetters );
                    context().T().append( "        }\n        else throw new ModelIntegrityException( \"Instances could not be unrelated.\" );\n    }\n" );
                }

            };
        case "statemachine/t.event.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String class_name = (String)symbols[0];
                    String invocation_parameter_list = (String)symbols[1];
                    String parameter_list = (String)symbols[2];
                    Event self = (Event)symbols[3];
                    context().T().append( "    public static class " );
                    context().T().append( self.getName() );
                    context().T().append( " extends Event {\n        public " );
                    context().T().append( self.getName() );
                    context().T().append( "(IRunContext runContext, int populationId" );
                    if ( ( StringUtil.inequality("", parameter_list) ) ) {
                        context().T().append( ", " );
                        context().T().append( parameter_list );
                        context().T().append( "" );
                    }
                    context().T().append( ") {\n            super(runContext, populationId" );
                    if ( ( StringUtil.inequality("", parameter_list) ) ) {
                        context().T().append( ", new Object[]{" );
                        context().T().append( invocation_parameter_list );
                        context().T().append( "}" );
                    }
                    context().T().append( ");\n        }\n        @Override\n        public int getId() {\n            return " );
                    context().T().append( self.getId() );
                    context().T().append( ";\n        }\n        @Override\n        public String getClassName() {\n            return \"" );
                    context().T().append( class_name );
                    context().T().append( "\";\n        }\n    }\n" );
                }

            };
        case "statemachine/t.state.decl.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    State self = (State)symbols[0];
                    context().T().append( "    public static final int " );
                    context().T().append( self.getName() );
                    context().T().append( " = " );
                    context().T().append( self.getNumber() );
                    context().T().append( ";\n" );
                }

            };
        case "statemachine/t.state.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String body = (String)symbols[0];
                    String parameter_list = (String)symbols[1];
                    State self = (State)symbols[2];
                    context().T().append( "    private void " );
                    context().T().append( self.getName() );
                    context().T().append( "_entry_action(" );
                    context().T().append( parameter_list );
                    context().T().append( ") throws XtumlException " );
                    context().T().append( body );
                    context().T().append( "\n" );
                }

            };
        case "statemachine/t.statemachine.decl.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    StateMachine self = (StateMachine)symbols[0];
                    context().T().append( "    private final " );
                    context().T().append( self.getName() );
                    context().T().append( " statemachine;\n    \n    @Override\n    public void accept(IEvent event) throws XtumlException {\n        if (isAlive()) {\n            statemachine.transition(event);\n        }\n    }\n\n    @Override\n    public int getCurrentState() {\n        return statemachine.getCurrentState();\n    }\n" );
                }

            };
        case "statemachine/t.statemachine.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String imports = (String)symbols[0];
                    String initial_state = (String)symbols[1];
                    StateMachine self = (StateMachine)symbols[2];
                    String state_actions = (String)symbols[3];
                    String state_declarations = (String)symbols[4];
                    String transition_table_rows = (String)symbols[5];
                    String txn_actions = (String)symbols[6];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ".impl;\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic class " );
                    context().T().append( self.getName() );
                    context().T().append( " extends StateMachine<" );
                    context().T().append( self.getClass_name() );
                    context().T().append( "," );
                    context().T().append( self.getComp_name() );
                    context().T().append( "> {\n\n" );
                    context().T().append( state_declarations );
                    context().T().append( "\n\n    private " );
                    context().T().append( self.getClass_name() );
                    context().T().append( " self;\n\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( "(" );
                    context().T().append( self.getClass_name() );
                    context().T().append( " self, " );
                    context().T().append( self.getComp_name() );
                    context().T().append( " context) {\n" );
                    if ( ( StringUtil.inequality("", initial_state) ) ) {
                        context().T().append( "        this(self, context, " );
                        context().T().append( initial_state );
                        context().T().append( ");\n    }\n\n    public " );
                        context().T().append( self.getName() );
                        context().T().append( "(" );
                        context().T().append( self.getClass_name() );
                        context().T().append( " self, " );
                        context().T().append( self.getComp_name() );
                        context().T().append( " context, int initialState) {\n        super(context, initialState);\n        this.self = self;\n    }\n" );
                    }
                    else {
                        context().T().append( "        super(context);\n        this.self = self;\n    }\n" );
                    }
                    context().T().append( "\n" );
                    context().T().append( state_actions );
                    context().T().append( "\n\n" );
                    context().T().append( txn_actions );
                    context().T().append( "\n\n    @Override\n    public ITransition[][] getStateEventMatrix() {\n        return new ITransition[][] {\n" );
                    context().T().append( transition_table_rows );
                    context().T().append( "\n        };\n    }\n\n    @Override\n    public " );
                    context().T().append( self.getClass_name() );
                    context().T().append( " self() {\n        return self;\n    }\n\n    @Override\n    public String getClassName() {\n        return \"" );
                    context().T().append( self.getClass_name() );
                    context().T().append( "\";\n    }\n\n}\n" );
                }

            };
        case "statemachine/t.transition.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String body = (String)symbols[0];
                    String parameter_list = (String)symbols[1];
                    StateTransition self = (StateTransition)symbols[2];
                    context().T().append( "    private void " );
                    context().T().append( self.getStart_state_name() );
                    context().T().append( "_" );
                    context().T().append( self.getEvent_name() );
                    context().T().append( "_txn_to_" );
                    context().T().append( self.getEnd_state_name() );
                    context().T().append( "_action(" );
                    context().T().append( parameter_list );
                    context().T().append( ") throws XtumlException " );
                    context().T().append( body );
                    context().T().append( "\n" );
                }

            };
        case "statemachine/t.transitiontablecell.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    boolean cant_happen = (boolean)symbols[0];
                    String end_state_name = (String)symbols[1];
                    boolean event_ignored = (boolean)symbols[2];
                    String evt_name = (String)symbols[3];
                    boolean has_entry_action = (boolean)symbols[4];
                    boolean has_txn_action = (boolean)symbols[5];
                    String parameter_list = (String)symbols[6];
                    TransitionTableCell self = (TransitionTableCell)symbols[7];
                    String state_parameter_list = (String)symbols[8];
                    if ( ( cant_happen ) ) {
                        context().T().append( "CANT_HAPPEN" );
                    }
                    else if ( ( event_ignored ) ) {
                        context().T().append( "IGNORE" );
                    }
                    else {
                        context().T().append( "(event) -> {" );
                        if ( ( has_txn_action ) ) {
                            context().T().append( self.getState_name() );
                            context().T().append( "_" );
                            context().T().append( evt_name );
                            context().T().append( "_txn_to_" );
                            context().T().append( end_state_name );
                            context().T().append( "_action(" );
                            context().T().append( parameter_list );
                            context().T().append( ");" );
                        }
                        if ( ( has_entry_action ) ) {
                            context().T().append( end_state_name );
                            context().T().append( "_entry_action(" );
                            context().T().append( state_parameter_list );
                            context().T().append( ");" );
                        }
                        context().T().append( "return " );
                        context().T().append( end_state_name );
                        context().T().append( ";}" );
                    }
                }

            };
        case "statemachine/t.transitiontablerow.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String transition_table_cells = (String)symbols[0];
                    context().T().append( "            { " );
                    context().T().append( transition_table_cells );
                    context().T().append( "\n            }" );
                }

            };
        case "statement/t.break.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String actions = (String)symbols[0];
                    String indent = (String)symbols[1];
                    String prefix = (String)symbols[2];
                    if ( ( StringUtil.inequality("", actions) ) ) {
                        context().T().append( indent );
                        context().T().append( "/* " );
                        context().T().append( actions );
                        context().T().append( " */\n" );
                    }
                    context().T().append( prefix );
                    context().T().append( indent );
                    context().T().append( "break;\n" );
                }

            };
        case "statement/t.continue.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String actions = (String)symbols[0];
                    String indent = (String)symbols[1];
                    String prefix = (String)symbols[2];
                    if ( ( StringUtil.inequality("", actions) ) ) {
                        context().T().append( indent );
                        context().T().append( "/* " );
                        context().T().append( actions );
                        context().T().append( " */\n" );
                    }
                    context().T().append( prefix );
                    context().T().append( indent );
                    context().T().append( "continue;\n" );
                }

            };
        case "statement/t.delete.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String actions = (String)symbols[0];
                    String indent = (String)symbols[1];
                    String inst_expr = (String)symbols[2];
                    String prefix = (String)symbols[3];
                    if ( ( StringUtil.inequality("", actions) ) ) {
                        context().T().append( indent );
                        context().T().append( "/* " );
                        context().T().append( actions );
                        context().T().append( " */\n" );
                    }
                    context().T().append( prefix );
                    context().T().append( indent );
                    context().T().append( inst_expr );
                    context().T().append( ".delete();\n" );
                }

            };
        case "statement/t.expressionasstatement.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String actions = (String)symbols[0];
                    String expression_body = (String)symbols[1];
                    String indent = (String)symbols[2];
                    String prefix = (String)symbols[3];
                    if ( ( StringUtil.inequality("", actions) ) ) {
                        context().T().append( indent );
                        context().T().append( "/* " );
                        context().T().append( actions );
                        context().T().append( " */\n" );
                    }
                    context().T().append( prefix );
                    context().T().append( indent );
                    context().T().append( expression_body );
                    context().T().append( ";\n" );
                }

            };
        case "statement/t.finalization.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    int finalization_num = (int)symbols[0];
                    String indent = (String)symbols[1];
                    Finalization self = (Finalization)symbols[2];
                    String type_name = (String)symbols[3];
                    context().T().append( indent );
                    context().T().append( "final " );
                    context().T().append( type_name );
                    context().T().append( " _final" );
                    context().T().append( context().T().sub( "t", finalization_num ) );
                    context().T().append( "_" );
                    context().T().append( self.getVar_name() );
                    context().T().append( " = " );
                    context().T().append( self.getVar_name() );
                    context().T().append( ";\n" );
                }

            };
        case "statement/t.for.iter.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String indent = (String)symbols[0];
                    ForSmt self = (ForSmt)symbols[1];
                    context().T().append( indent );
                    context().T().append( self.getIterator_name() );
                    context().T().append( " = _" );
                    context().T().append( self.getIterator_name() );
                    context().T().append( "_iter.next();\n" );
                }

            };
        case "statement/t.for.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String actions = (String)symbols[0];
                    String control_block = (String)symbols[1];
                    String indent = (String)symbols[2];
                    String iterable_expr = (String)symbols[3];
                    String iterator_type = (String)symbols[4];
                    String prefix = (String)symbols[5];
                    ForSmt self = (ForSmt)symbols[6];
                    if ( ( StringUtil.inequality("", actions) ) ) {
                        context().T().append( indent );
                        context().T().append( "/* " );
                        context().T().append( actions );
                        context().T().append( " */\n" );
                    }
                    context().T().append( prefix );
                    context().T().append( indent );
                    context().T().append( "for ( Iterator<" );
                    context().T().append( iterator_type );
                    context().T().append( "> _" );
                    context().T().append( self.getIterator_name() );
                    context().T().append( "_iter = " );
                    context().T().append( iterable_expr );
                    context().T().append( ".elements().iterator(); _" );
                    context().T().append( self.getIterator_name() );
                    context().T().append( "_iter.hasNext(); ) " );
                    context().T().append( control_block );
                    context().T().append( "" );
                }

            };
        case "statement/t.generate.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String actions = (String)symbols[0];
                    String evt_expr = (String)symbols[1];
                    String indent = (String)symbols[2];
                    String prefix = (String)symbols[3];
                    if ( ( StringUtil.inequality("", actions) ) ) {
                        context().T().append( indent );
                        context().T().append( "/* " );
                        context().T().append( actions );
                        context().T().append( " */\n" );
                    }
                    context().T().append( prefix );
                    context().T().append( indent );
                    context().T().append( "context().generate(" );
                    context().T().append( evt_expr );
                    context().T().append( ");\n" );
                }

            };
        case "statement/t.halt.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String actions = (String)symbols[0];
                    String indent = (String)symbols[1];
                    String prefix = (String)symbols[2];
                    if ( ( StringUtil.inequality("", actions) ) ) {
                        context().T().append( indent );
                        context().T().append( "/* " );
                        context().T().append( actions );
                        context().T().append( " */\n" );
                    }
                    context().T().append( prefix );
                    context().T().append( indent );
                    context().T().append( "getRunContext().execute( new HaltExecutionTask() );\n" );
                }

            };
        case "statement/t.if.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String cond_expr = (String)symbols[0];
                    String else_actions = (String)symbols[1];
                    String else_block = (String)symbols[2];
                    String if_actions = (String)symbols[3];
                    String indent = (String)symbols[4];
                    IfSmt self = (IfSmt)symbols[5];
                    String then_block = (String)symbols[6];
                    if ( ( StringUtil.inequality("", if_actions) ) ) {
                        context().T().append( indent );
                        context().T().append( "/* " );
                        context().T().append( if_actions );
                        context().T().append( " */\n" );
                    }
                    if ( ( !self.getIs_else_if() ) ) {
                        context().T().append( indent );
                        context().T().append( "" );
                    }
                    context().T().append( "if ( " );
                    context().T().append( cond_expr );
                    context().T().append( " ) " );
                    context().T().append( then_block );
                    context().T().append( "" );
                    if ( ( StringUtil.inequality("", else_block) ) ) {
                        if ( ( StringUtil.inequality("", else_actions) ) ) {
                            context().T().append( indent );
                            context().T().append( "/* " );
                            context().T().append( else_actions );
                            context().T().append( " */\n" );
                        }
                        context().T().append( indent );
                        context().T().append( "else " );
                        context().T().append( else_block );
                        context().T().append( "" );
                    }
                }

            };
        case "statement/t.relate.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String actions = (String)symbols[0];
                    String form_expr = (String)symbols[1];
                    String indent = (String)symbols[2];
                    String part_expr = (String)symbols[3];
                    String prefix = (String)symbols[4];
                    RelateSmt self = (RelateSmt)symbols[5];
                    if ( ( StringUtil.inequality("", actions) ) ) {
                        context().T().append( indent );
                        context().T().append( "/* " );
                        context().T().append( actions );
                        context().T().append( " */\n" );
                    }
                    context().T().append( prefix );
                    context().T().append( indent );
                    context().T().append( "context().relate_" );
                    context().T().append( self.getRel_name() );
                    context().T().append( "( " );
                    context().T().append( form_expr );
                    context().T().append( ", " );
                    context().T().append( part_expr );
                    context().T().append( " );\n" );
                }

            };
        case "statement/t.return.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String actions = (String)symbols[0];
                    String block_suffix = (String)symbols[1];
                    String indent = (String)symbols[2];
                    String prefix = (String)symbols[3];
                    String ret_expression_body = (String)symbols[4];
                    if ( ( StringUtil.inequality("", actions) ) ) {
                        context().T().append( indent );
                        context().T().append( "/* " );
                        context().T().append( actions );
                        context().T().append( " */\n" );
                    }
                    context().T().append( prefix );
                    context().T().append( "" );
                    if ( ( StringUtil.equality("", ret_expression_body) ) ) {
                        context().T().append( block_suffix );
                        context().T().append( indent );
                        context().T().append( "return;\n" );
                    }
                    else {
                        context().T().append( block_suffix );
                        context().T().append( indent );
                        context().T().append( "return " );
                        context().T().append( ret_expression_body );
                        context().T().append( ";\n" );
                    }
                }

            };
        case "statement/t.unrelate.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String actions = (String)symbols[0];
                    String form_expr = (String)symbols[1];
                    String indent = (String)symbols[2];
                    String part_expr = (String)symbols[3];
                    String prefix = (String)symbols[4];
                    UnrelateSmt self = (UnrelateSmt)symbols[5];
                    if ( ( StringUtil.inequality("", actions) ) ) {
                        context().T().append( indent );
                        context().T().append( "/* " );
                        context().T().append( actions );
                        context().T().append( " */\n" );
                    }
                    context().T().append( prefix );
                    context().T().append( indent );
                    context().T().append( "context().unrelate_" );
                    context().T().append( self.getRel_name() );
                    context().T().append( "( " );
                    context().T().append( form_expr );
                    context().T().append( ", " );
                    context().T().append( part_expr );
                    context().T().append( " );\n" );
                }

            };
        case "statement/t.while.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String actions = (String)symbols[0];
                    String cond_expr = (String)symbols[1];
                    String control_block = (String)symbols[2];
                    String indent = (String)symbols[3];
                    String prefix = (String)symbols[4];
                    if ( ( StringUtil.inequality("", actions) ) ) {
                        context().T().append( indent );
                        context().T().append( "/* " );
                        context().T().append( actions );
                        context().T().append( " */\n" );
                    }
                    context().T().append( prefix );
                    context().T().append( indent );
                    context().T().append( "while ( " );
                    context().T().append( cond_expr );
                    context().T().append( " ) " );
                    context().T().append( control_block );
                    context().T().append( "" );
                }

            };
        case "type/t.enumeratedtype.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String enumerator_accessors = (String)symbols[0];
                    String enumerators = (String)symbols[1];
                    String imports = (String)symbols[2];
                    EnumeratedType self = (EnumeratedType)symbols[3];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ";\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic enum " );
                    context().T().append( self.getName() );
                    context().T().append( " implements IXtumlType {\n\n    UNINITIALIZED_ENUM( -1 )" );
                    context().T().append( enumerators );
                    context().T().append( "\n\n    private final int value;\n\n    " );
                    context().T().append( self.getName() );
                    context().T().append( "() {\n        value = -1;\n    }\n\n    " );
                    context().T().append( self.getName() );
                    context().T().append( "( int value ) {\n        this.value = value;\n    }\n\n    public int getValue() {\n        return value;\n    }\n\n    @Override\n    public boolean equality( IXtumlType value ) throws XtumlException {\n        if (value instanceof " );
                    context().T().append( self.getName() );
                    context().T().append( ") {\n            return null != value && this.value == ((" );
                    context().T().append( self.getName() );
                    context().T().append( ")value).getValue();\n        }\n        else return false;\n    }\n\n    @Override\n    public String serialize() {\n        return Integer.toString(value);\n    }\n\n    public static " );
                    context().T().append( self.getName() );
                    context().T().append( " deserialize(Object o) throws XtumlException {\n        if (o instanceof " );
                    context().T().append( self.getName() );
                    context().T().append( ") {\n            return (" );
                    context().T().append( self.getName() );
                    context().T().append( ")o;\n        }\n        else if (o instanceof Integer) {\n            return valueOf((int)o);\n        }\n        else if (o instanceof String) {\n            try {\n                return valueOf(Integer.parseInt((String)o));\n            }\n            catch (NumberFormatException e1) {\n                Matcher m = Pattern.compile(\"([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)\").matcher((String)o);\n                if (m.matches() && \"" );
                    context().T().append( context().T().sub( "l", self.getName() ) );
                    context().T().append( "\".equals(m.group(1).toLowerCase())) {\n                    try {\n                        return Enum.valueOf(" );
                    context().T().append( self.getName() );
                    context().T().append( ".class, m.group(2).toUpperCase());\n                    } catch (IllegalArgumentException e2) {/* do nothing */}\n                }\n            }\n        }\n        throw new XtumlException(\"Cannot deserialize value: \" + o != null ? o.toString() : \"null\");\n    }\n\n    public static " );
                    context().T().append( self.getName() );
                    context().T().append( " valueOf(int value) {\n        switch( value ) {\n" );
                    context().T().append( enumerator_accessors );
                    context().T().append( "        default:\n            return UNINITIALIZED_ENUM;\n        }\n    }\n\n}\n" );
                }

            };
        case "type/t.enumerator.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    Enumerator self = (Enumerator)symbols[0];
                    context().T().append( "    " );
                    context().T().append( self.getName() );
                    context().T().append( "( " );
                    context().T().append( context().T().sub( "t", self.getValue() ) );
                    context().T().append( " )" );
                }

            };
        case "type/t.enumeratoraccessor.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    Enumerator self = (Enumerator)symbols[0];
                    context().T().append( "        case " );
                    context().T().append( context().T().sub( "t", self.getValue() ) );
                    context().T().append( ":\n            return " );
                    context().T().append( self.getName() );
                    context().T().append( ";\n" );
                }

            };
        case "type/t.userdefinedtype.java":
            return new Template<Sql>( population ) {
                @Override
                public void evaluate(Object ... symbols) throws XtumlException {
                    String extends_type = (String)symbols[0];
                    String imports = (String)symbols[1];
                    UserDefinedType self = (UserDefinedType)symbols[2];
                    context().T().append( "package " );
                    context().T().append( self.getPackage() );
                    context().T().append( ";\n\n" );
                    context().T().append( imports );
                    context().T().append( "\n\npublic class " );
                    context().T().append( self.getName() );
                    context().T().append( " extends " );
                    context().T().append( extends_type );
                    context().T().append( " implements IXtumlType {\n\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( "() {\n        super();\n    }\n\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( "(Object value) throws XtumlException {\n        super(value);\n    }\n\n    @SuppressWarnings(\"unchecked\")\n    public " );
                    context().T().append( self.getName() );
                    context().T().append( " promote(Object o) throws XtumlException {\n        return new " );
                    context().T().append( self.getName() );
                    context().T().append( "(cast(o));\n    }\n\n    public static " );
                    context().T().append( self.getName() );
                    context().T().append( " deserialize(Object o) throws XtumlException {\n        throw new NotImplementedException(\"Type cannot be deserialized\");\n    }\n}\n" );
                }

            };
        default:
            return (symbolTable) -> {};
        }
    }

}
