package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum SynchronizationType implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    PULL( 0 ),
    PUSH( 1 );

    private final int value;

    SynchronizationType() {
        value = -1;
    }

    SynchronizationType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof SynchronizationType) {
            return null != value && this.value == ((SynchronizationType)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static SynchronizationType deserialize(Object o) throws XtumlException {
        if (o instanceof SynchronizationType) {
            return (SynchronizationType)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "synchronizationtype".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(SynchronizationType.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static SynchronizationType valueOf(int value) {
        switch( value ) {
        case 0:
            return PULL;
        case 1:
            return PUSH;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
