package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum Scope implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    CLASS( 0 ),
    INSTANCE( 1 );

    private final int value;

    Scope() {
        value = -1;
    }

    Scope( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof Scope) {
            return null != value && this.value == ((Scope)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Scope deserialize(Object o) throws XtumlException {
        if (o instanceof Scope) {
            return (Scope)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "scope".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(Scope.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static Scope valueOf(int value) {
        switch( value ) {
        case 0:
            return CLASS;
        case 1:
            return INSTANCE;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
