package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum RunStateType implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    RUNNING( 0 ),
    STEPPING( 1 ),
    SUSPENDED( 2 ),
    TERMINATED( 3 );

    private final int value;

    RunStateType() {
        value = -1;
    }

    RunStateType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof RunStateType) {
            return null != value && this.value == ((RunStateType)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static RunStateType deserialize(Object o) throws XtumlException {
        if (o instanceof RunStateType) {
            return (RunStateType)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "runstatetype".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(RunStateType.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static RunStateType valueOf(int value) {
        switch( value ) {
        case 0:
            return RUNNING;
        case 1:
            return STEPPING;
        case 2:
            return SUSPENDED;
        case 3:
            return TERMINATED;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
