package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum ModelEventNotification implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    DELTA_ATTRIBUTE_CHANGE( 0 ),
    DELTA_DELETE( 1 ),
    DELTA_ELEMENT_RELATED( 2 ),
    DELTA_ELEMENT_UNRELATED( 3 ),
    DELTA_NEW( 4 ),
    MASK_ALL_DELTAS( 5 ),
    MASK_ALL_EVENTS( 6 ),
    MASK_NO_DELTAS( 7 ),
    MASK_NO_EVENTS( 8 ),
    MODEL_ELEMENT_CHANGED( 9 ),
    MODEL_ELEMENT_LOADED( 10 ),
    MODEL_ELEMENT_PRE_DELETE( 11 ),
    MODEL_ELEMENT_PRE_RELOAD( 12 ),
    MODEL_ELEMENT_RELOAD( 13 ),
    MODEL_ELEMENT_UNLOADED( 14 ),
    MODEL_EXECUTION_STOPPED( 15 ),
    UNKNOWN( 16 );

    private final int value;

    ModelEventNotification() {
        value = -1;
    }

    ModelEventNotification( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof ModelEventNotification) {
            return null != value && this.value == ((ModelEventNotification)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static ModelEventNotification deserialize(Object o) throws XtumlException {
        if (o instanceof ModelEventNotification) {
            return (ModelEventNotification)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "modeleventnotification".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(ModelEventNotification.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static ModelEventNotification valueOf(int value) {
        switch( value ) {
        case 0:
            return DELTA_ATTRIBUTE_CHANGE;
        case 1:
            return DELTA_DELETE;
        case 2:
            return DELTA_ELEMENT_RELATED;
        case 3:
            return DELTA_ELEMENT_UNRELATED;
        case 4:
            return DELTA_NEW;
        case 5:
            return MASK_ALL_DELTAS;
        case 6:
            return MASK_ALL_EVENTS;
        case 7:
            return MASK_NO_DELTAS;
        case 8:
            return MASK_NO_EVENTS;
        case 9:
            return MODEL_ELEMENT_CHANGED;
        case 10:
            return MODEL_ELEMENT_LOADED;
        case 11:
            return MODEL_ELEMENT_PRE_DELETE;
        case 12:
            return MODEL_ELEMENT_PRE_RELOAD;
        case 13:
            return MODEL_ELEMENT_RELOAD;
        case 14:
            return MODEL_ELEMENT_UNLOADED;
        case 15:
            return MODEL_EXECUTION_STOPPED;
        case 16:
            return UNKNOWN;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
