package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum ImplementationScope implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    DEPLOYMENT( 1 ),
    DOMAIN( 0 );

    private final int value;

    ImplementationScope() {
        value = -1;
    }

    ImplementationScope( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof ImplementationScope) {
            return null != value && this.value == ((ImplementationScope)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static ImplementationScope deserialize(Object o) throws XtumlException {
        if (o instanceof ImplementationScope) {
            return (ImplementationScope)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "implementationscope".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(ImplementationScope.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static ImplementationScope valueOf(int value) {
        switch( value ) {
        case 1:
            return DEPLOYMENT;
        case 0:
            return DOMAIN;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
