package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.value.InstanceSetReference;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class InstanceSetReferenceImpl extends ModelInstance<InstanceSetReference,Sql> implements InstanceSetReference {

    public static final String KEY_LETTERS = "V_ISR";
    public static final InstanceSetReference EMPTY_INSTANCESETREFERENCE = new EmptyInstanceSetReference();

    private Sql context;

    // constructors
    private InstanceSetReferenceImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_Var_ID = UniqueId.random();
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R809_refers_to_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
    }

    private InstanceSetReferenceImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Var_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Var_ID = ref_Var_ID;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R809_refers_to_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
    }

    public static InstanceSetReference create( Sql context ) throws XtumlException {
        InstanceSetReference newInstanceSetReference = new InstanceSetReferenceImpl( context );
        if ( context.addInstance( newInstanceSetReference ) ) {
            newInstanceSetReference.getRunContext().addChange(new InstanceCreatedDelta(newInstanceSetReference, KEY_LETTERS));
            return newInstanceSetReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InstanceSetReference create( Sql context, UniqueId ref_Value_ID, UniqueId ref_Var_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Value_ID, ref_Var_ID);
    }

    public static InstanceSetReference create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Var_ID ) throws XtumlException {
        InstanceSetReference newInstanceSetReference = new InstanceSetReferenceImpl( context, instanceId, ref_Value_ID, ref_Var_ID );
        if ( context.addInstance( newInstanceSetReference ) ) {
            return newInstanceSetReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    private UniqueId ref_Var_ID;
    @Override
    public void setVar_ID(UniqueId ref_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Var_ID.inequality( this.ref_Var_ID)) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
        }
    }
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
        return ref_Var_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private V_VAR R809_refers_to_V_VAR_inst;
    @Override
    public void setR809_refers_to_V_VAR( V_VAR inst ) {
        R809_refers_to_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R809_refers_to_V_VAR() throws XtumlException {
        return R809_refers_to_V_VAR_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InstanceSetReference self() {
        return this;
    }

    @Override
    public InstanceSetReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INSTANCESETREFERENCE;
    }

}

class EmptyInstanceSetReference extends ModelInstance<InstanceSetReference,Sql> implements InstanceSetReference {

    // attributes
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public V_VAR R809_refers_to_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }


    @Override
    public String getKeyLetters() {
        return InstanceSetReferenceImpl.KEY_LETTERS;
    }

    @Override
    public InstanceSetReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InstanceSetReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InstanceSetReferenceImpl.EMPTY_INSTANCESETREFERENCE;
    }

}
