package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.S_SYNC;
import io.ciera.tool.sql.ooaofooa.domain.impl.S_SYNCImpl;
import io.ciera.tool.sql.ooaofooa.value.FunctionValue;
import io.ciera.tool.sql.ooaofooa.value.V_PAR;
import io.ciera.tool.sql.ooaofooa.value.V_PARSet;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.V_PARSetImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class FunctionValueImpl extends ModelInstance<FunctionValue,Sql> implements FunctionValue {

    public static final String KEY_LETTERS = "V_FNV";
    public static final FunctionValue EMPTY_FUNCTIONVALUE = new EmptyFunctionValue();

    private Sql context;

    // constructors
    private FunctionValueImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_Sync_ID = UniqueId.random();
        m_ParmListOK = false;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R817_has_V_PAR_set = new V_PARSetImpl();
        R827_S_SYNC_inst = S_SYNCImpl.EMPTY_S_SYNC;
    }

    private FunctionValueImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Sync_ID, boolean m_ParmListOK ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Sync_ID = ref_Sync_ID;
        this.m_ParmListOK = m_ParmListOK;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R817_has_V_PAR_set = new V_PARSetImpl();
        R827_S_SYNC_inst = S_SYNCImpl.EMPTY_S_SYNC;
    }

    public static FunctionValue create( Sql context ) throws XtumlException {
        FunctionValue newFunctionValue = new FunctionValueImpl( context );
        if ( context.addInstance( newFunctionValue ) ) {
            newFunctionValue.getRunContext().addChange(new InstanceCreatedDelta(newFunctionValue, KEY_LETTERS));
            return newFunctionValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static FunctionValue create( Sql context, UniqueId ref_Value_ID, UniqueId ref_Sync_ID, boolean m_ParmListOK ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Value_ID, ref_Sync_ID, m_ParmListOK);
    }

    public static FunctionValue create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Sync_ID, boolean m_ParmListOK ) throws XtumlException {
        FunctionValue newFunctionValue = new FunctionValueImpl( context, instanceId, ref_Value_ID, ref_Sync_ID, m_ParmListOK );
        if ( context.addInstance( newFunctionValue ) ) {
            return newFunctionValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
            if ( !R817_has_V_PAR().isEmpty() ) R817_has_V_PAR().setInvocation_Value_ID( ref_Value_ID );
        }
    }
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    private UniqueId ref_Sync_ID;
    @Override
    public void setSync_ID(UniqueId ref_Sync_ID) throws XtumlException {
        checkLiving();
        if (ref_Sync_ID.inequality( this.ref_Sync_ID)) {
            final UniqueId oldValue = this.ref_Sync_ID;
            this.ref_Sync_ID = ref_Sync_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Sync_ID", oldValue, this.ref_Sync_ID));
        }
    }
    @Override
    public UniqueId getSync_ID() throws XtumlException {
        checkLiving();
        return ref_Sync_ID;
    }
    private boolean m_ParmListOK;
    @Override
    public boolean getParmListOK() throws XtumlException {
        checkLiving();
        return m_ParmListOK;
    }
    @Override
    public void setParmListOK(boolean m_ParmListOK) throws XtumlException {
        checkLiving();
        if (m_ParmListOK != this.m_ParmListOK) {
            final boolean oldValue = this.m_ParmListOK;
            this.m_ParmListOK = m_ParmListOK;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_ParmListOK", oldValue, this.m_ParmListOK));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private V_PARSet R817_has_V_PAR_set;
    @Override
    public void addR817_has_V_PAR( V_PAR inst ) {
        R817_has_V_PAR_set.add(inst);
    }
    @Override
    public void removeR817_has_V_PAR( V_PAR inst ) {
        R817_has_V_PAR_set.remove(inst);
    }
    @Override
    public V_PARSet R817_has_V_PAR() throws XtumlException {
        return R817_has_V_PAR_set;
    }
    private S_SYNC R827_S_SYNC_inst;
    @Override
    public void setR827_S_SYNC( S_SYNC inst ) {
        R827_S_SYNC_inst = inst;
    }
    @Override
    public S_SYNC R827_S_SYNC() throws XtumlException {
        return R827_S_SYNC_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public FunctionValue self() {
        return this;
    }

    @Override
    public FunctionValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_FUNCTIONVALUE;
    }

}

class EmptyFunctionValue extends ModelInstance<FunctionValue,Sql> implements FunctionValue {

    // attributes
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSync_ID( UniqueId ref_Sync_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSync_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getParmListOK() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParmListOK( boolean m_ParmListOK ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public V_PARSet R817_has_V_PAR() {
        return (new V_PARSetImpl());
    }
    @Override
    public S_SYNC R827_S_SYNC() {
        return S_SYNCImpl.EMPTY_S_SYNC;
    }


    @Override
    public String getKeyLetters() {
        return FunctionValueImpl.KEY_LETTERS;
    }

    @Override
    public FunctionValue self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public FunctionValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return FunctionValueImpl.EMPTY_FUNCTIONVALUE;
    }

}
