package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.value.ArrayLengthValue;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class ArrayLengthValueImpl extends ModelInstance<ArrayLengthValue,Sql> implements ArrayLengthValue {

    public static final String KEY_LETTERS = "V_ALV";
    public static final ArrayLengthValue EMPTY_ARRAYLENGTHVALUE = new EmptyArrayLengthValue();

    private Sql context;

    // constructors
    private ArrayLengthValueImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_Array_Value_ID = UniqueId.random();
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R840_returns_length_of_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    private ArrayLengthValueImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Array_Value_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Array_Value_ID = ref_Array_Value_ID;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R840_returns_length_of_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    public static ArrayLengthValue create( Sql context ) throws XtumlException {
        ArrayLengthValue newArrayLengthValue = new ArrayLengthValueImpl( context );
        if ( context.addInstance( newArrayLengthValue ) ) {
            newArrayLengthValue.getRunContext().addChange(new InstanceCreatedDelta(newArrayLengthValue, KEY_LETTERS));
            return newArrayLengthValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ArrayLengthValue create( Sql context, UniqueId ref_Value_ID, UniqueId ref_Array_Value_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Value_ID, ref_Array_Value_ID);
    }

    public static ArrayLengthValue create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Array_Value_ID ) throws XtumlException {
        ArrayLengthValue newArrayLengthValue = new ArrayLengthValueImpl( context, instanceId, ref_Value_ID, ref_Array_Value_ID );
        if ( context.addInstance( newArrayLengthValue ) ) {
            return newArrayLengthValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    private UniqueId ref_Array_Value_ID;
    @Override
    public void setArray_Value_ID(UniqueId ref_Array_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Array_Value_ID.inequality( this.ref_Array_Value_ID)) {
            final UniqueId oldValue = this.ref_Array_Value_ID;
            this.ref_Array_Value_ID = ref_Array_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Array_Value_ID", oldValue, this.ref_Array_Value_ID));
        }
    }
    @Override
    public UniqueId getArray_Value_ID() throws XtumlException {
        checkLiving();
        return ref_Array_Value_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private Value R840_returns_length_of_Value_inst;
    @Override
    public void setR840_returns_length_of_Value( Value inst ) {
        R840_returns_length_of_Value_inst = inst;
    }
    @Override
    public Value R840_returns_length_of_Value() throws XtumlException {
        return R840_returns_length_of_Value_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ArrayLengthValue self() {
        return this;
    }

    @Override
    public ArrayLengthValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ARRAYLENGTHVALUE;
    }

}

class EmptyArrayLengthValue extends ModelInstance<ArrayLengthValue,Sql> implements ArrayLengthValue {

    // attributes
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setArray_Value_ID( UniqueId ref_Array_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getArray_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public Value R840_returns_length_of_Value() {
        return ValueImpl.EMPTY_VALUE;
    }


    @Override
    public String getKeyLetters() {
        return ArrayLengthValueImpl.KEY_LETTERS;
    }

    @Override
    public ArrayLengthValue self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ArrayLengthValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ArrayLengthValueImpl.EMPTY_ARRAYLENGTHVALUE;
    }

}
