package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.ReferredToClassInAssoc;
import io.ciera.tool.sql.ooaofooa.association.impl.ReferredToClassInAssocImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.AttributeReferenceInClass;
import io.ciera.tool.sql.ooaofooa.subsystem.AttributeReferenceInClassSet;
import io.ciera.tool.sql.ooaofooa.subsystem.ClassIdentifierAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.ReferredToIdentifierAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.AttributeReferenceInClassSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ClassIdentifierAttributeImpl;


public class ReferredToIdentifierAttributeImpl extends ModelInstance<ReferredToIdentifierAttribute,Sql> implements ReferredToIdentifierAttribute {

    public static final String KEY_LETTERS = "O_RTIDA";
    public static final ReferredToIdentifierAttribute EMPTY_REFERREDTOIDENTIFIERATTRIBUTE = new EmptyReferredToIdentifierAttribute();

    private Sql context;

    // constructors
    private ReferredToIdentifierAttributeImpl( Sql context ) {
        this.context = context;
        ref_Attr_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        ref_Oid_ID = 0;
        ref_Rel_ID = UniqueId.random();
        ref_OIR_ID = UniqueId.random();
        R110_identifies_for_this_association_ReferredToClassInAssoc_inst = ReferredToClassInAssocImpl.EMPTY_REFERREDTOCLASSINASSOC;
        R110_is_identified_in_this_association_by_ClassIdentifierAttribute_inst = ClassIdentifierAttributeImpl.EMPTY_CLASSIDENTIFIERATTRIBUTE;
        R111_is_used_to_refer_class_by_AttributeReferenceInClass_set = new AttributeReferenceInClassSetImpl();
    }

    private ReferredToIdentifierAttributeImpl( Sql context, UniqueId instanceId, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, int ref_Oid_ID, UniqueId ref_Rel_ID, UniqueId ref_OIR_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Attr_ID = ref_Attr_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_Oid_ID = ref_Oid_ID;
        this.ref_Rel_ID = ref_Rel_ID;
        this.ref_OIR_ID = ref_OIR_ID;
        R110_identifies_for_this_association_ReferredToClassInAssoc_inst = ReferredToClassInAssocImpl.EMPTY_REFERREDTOCLASSINASSOC;
        R110_is_identified_in_this_association_by_ClassIdentifierAttribute_inst = ClassIdentifierAttributeImpl.EMPTY_CLASSIDENTIFIERATTRIBUTE;
        R111_is_used_to_refer_class_by_AttributeReferenceInClass_set = new AttributeReferenceInClassSetImpl();
    }

    public static ReferredToIdentifierAttribute create( Sql context ) throws XtumlException {
        ReferredToIdentifierAttribute newReferredToIdentifierAttribute = new ReferredToIdentifierAttributeImpl( context );
        if ( context.addInstance( newReferredToIdentifierAttribute ) ) {
            newReferredToIdentifierAttribute.getRunContext().addChange(new InstanceCreatedDelta(newReferredToIdentifierAttribute, KEY_LETTERS));
            return newReferredToIdentifierAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ReferredToIdentifierAttribute create( Sql context, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, int ref_Oid_ID, UniqueId ref_Rel_ID, UniqueId ref_OIR_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Attr_ID, ref_Obj_ID, ref_Oid_ID, ref_Rel_ID, ref_OIR_ID);
    }

    public static ReferredToIdentifierAttribute create( Sql context, UniqueId instanceId, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID, int ref_Oid_ID, UniqueId ref_Rel_ID, UniqueId ref_OIR_ID ) throws XtumlException {
        ReferredToIdentifierAttribute newReferredToIdentifierAttribute = new ReferredToIdentifierAttributeImpl( context, instanceId, ref_Attr_ID, ref_Obj_ID, ref_Oid_ID, ref_Rel_ID, ref_OIR_ID );
        if ( context.addInstance( newReferredToIdentifierAttribute ) ) {
            return newReferredToIdentifierAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Attr_ID;
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
        return ref_Attr_ID;
    }
    @Override
    public void setAttr_ID(UniqueId ref_Attr_ID) throws XtumlException {
        checkLiving();
        if (ref_Attr_ID.inequality( this.ref_Attr_ID)) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
            if ( !R111_is_used_to_refer_class_by_AttributeReferenceInClass().isEmpty() ) R111_is_used_to_refer_class_by_AttributeReferenceInClass().setRAttr_ID( ref_Attr_ID );
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
            if ( !R111_is_used_to_refer_class_by_AttributeReferenceInClass().isEmpty() ) R111_is_used_to_refer_class_by_AttributeReferenceInClass().setRObj_ID( ref_Obj_ID );
        }
    }
    private int ref_Oid_ID;
    @Override
    public int getOid_ID() throws XtumlException {
        checkLiving();
        return ref_Oid_ID;
    }
    @Override
    public void setOid_ID(int ref_Oid_ID) throws XtumlException {
        checkLiving();
        if (ref_Oid_ID != this.ref_Oid_ID) {
            final int oldValue = this.ref_Oid_ID;
            this.ref_Oid_ID = ref_Oid_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Oid_ID", oldValue, this.ref_Oid_ID));
            if ( !R111_is_used_to_refer_class_by_AttributeReferenceInClass().isEmpty() ) R111_is_used_to_refer_class_by_AttributeReferenceInClass().setROid_ID( ref_Oid_ID );
        }
    }
    private UniqueId ref_Rel_ID;
    @Override
    public void setRel_ID(UniqueId ref_Rel_ID) throws XtumlException {
        checkLiving();
        if (ref_Rel_ID.inequality( this.ref_Rel_ID)) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
            if ( !R111_is_used_to_refer_class_by_AttributeReferenceInClass().isEmpty() ) R111_is_used_to_refer_class_by_AttributeReferenceInClass().setRel_ID( ref_Rel_ID );
        }
    }
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
        return ref_Rel_ID;
    }
    private UniqueId ref_OIR_ID;
    @Override
    public UniqueId getOIR_ID() throws XtumlException {
        checkLiving();
        return ref_OIR_ID;
    }
    @Override
    public void setOIR_ID(UniqueId ref_OIR_ID) throws XtumlException {
        checkLiving();
        if (ref_OIR_ID.inequality( this.ref_OIR_ID)) {
            final UniqueId oldValue = this.ref_OIR_ID;
            this.ref_OIR_ID = ref_OIR_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_OIR_ID", oldValue, this.ref_OIR_ID));
            if ( !R111_is_used_to_refer_class_by_AttributeReferenceInClass().isEmpty() ) R111_is_used_to_refer_class_by_AttributeReferenceInClass().setROIR_ID( ref_OIR_ID );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAttr_ID(), getObj_ID(), getOid_ID(), getRel_ID(), getOIR_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ReferredToClassInAssoc R110_identifies_for_this_association_ReferredToClassInAssoc_inst;
    @Override
    public void setR110_identifies_for_this_association_ReferredToClassInAssoc( ReferredToClassInAssoc inst ) {
        R110_identifies_for_this_association_ReferredToClassInAssoc_inst = inst;
    }
    @Override
    public ReferredToClassInAssoc R110_identifies_for_this_association_ReferredToClassInAssoc() throws XtumlException {
        return R110_identifies_for_this_association_ReferredToClassInAssoc_inst;
    }
    private ClassIdentifierAttribute R110_is_identified_in_this_association_by_ClassIdentifierAttribute_inst;
    @Override
    public void setR110_is_identified_in_this_association_by_ClassIdentifierAttribute( ClassIdentifierAttribute inst ) {
        R110_is_identified_in_this_association_by_ClassIdentifierAttribute_inst = inst;
    }
    @Override
    public ClassIdentifierAttribute R110_is_identified_in_this_association_by_ClassIdentifierAttribute() throws XtumlException {
        return R110_is_identified_in_this_association_by_ClassIdentifierAttribute_inst;
    }
    private AttributeReferenceInClassSet R111_is_used_to_refer_class_by_AttributeReferenceInClass_set;
    @Override
    public void addR111_is_used_to_refer_class_by_AttributeReferenceInClass( AttributeReferenceInClass inst ) {
        R111_is_used_to_refer_class_by_AttributeReferenceInClass_set.add(inst);
    }
    @Override
    public void removeR111_is_used_to_refer_class_by_AttributeReferenceInClass( AttributeReferenceInClass inst ) {
        R111_is_used_to_refer_class_by_AttributeReferenceInClass_set.remove(inst);
    }
    @Override
    public AttributeReferenceInClassSet R111_is_used_to_refer_class_by_AttributeReferenceInClass() throws XtumlException {
        return R111_is_used_to_refer_class_by_AttributeReferenceInClass_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ReferredToIdentifierAttribute self() {
        return this;
    }

    @Override
    public ReferredToIdentifierAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_REFERREDTOIDENTIFIERATTRIBUTE;
    }

}

class EmptyReferredToIdentifierAttribute extends ModelInstance<ReferredToIdentifierAttribute,Sql> implements ReferredToIdentifierAttribute {

    // attributes
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getOid_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOid_ID( int ref_Oid_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getOIR_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOIR_ID( UniqueId ref_OIR_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ReferredToClassInAssoc R110_identifies_for_this_association_ReferredToClassInAssoc() {
        return ReferredToClassInAssocImpl.EMPTY_REFERREDTOCLASSINASSOC;
    }
    @Override
    public ClassIdentifierAttribute R110_is_identified_in_this_association_by_ClassIdentifierAttribute() {
        return ClassIdentifierAttributeImpl.EMPTY_CLASSIDENTIFIERATTRIBUTE;
    }
    @Override
    public AttributeReferenceInClassSet R111_is_used_to_refer_class_by_AttributeReferenceInClass() {
        return (new AttributeReferenceInClassSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ReferredToIdentifierAttributeImpl.KEY_LETTERS;
    }

    @Override
    public ReferredToIdentifierAttribute self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ReferredToIdentifierAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ReferredToIdentifierAttributeImpl.EMPTY_REFERREDTOIDENTIFIERATTRIBUTE;
    }

}
