package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.Dimensions;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;
import io.ciera.tool.sql.ooaofooa.message.OperationArgument;
import io.ciera.tool.sql.ooaofooa.message.OperationArgumentSet;
import io.ciera.tool.sql.ooaofooa.message.impl.OperationArgumentSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.O_TFR;
import io.ciera.tool.sql.ooaofooa.subsystem.OperationParameter;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_TFRImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.OperationParameterImpl;
import io.ciera.tool.sql.ooaofooa.value.ParameterValue;
import io.ciera.tool.sql.ooaofooa.value.ParameterValueSet;
import io.ciera.tool.sql.ooaofooa.value.impl.ParameterValueSetImpl;


public class OperationParameterImpl extends ModelInstance<OperationParameter,Sql> implements OperationParameter {

    public static final String KEY_LETTERS = "O_TPARM";
    public static final OperationParameter EMPTY_OPERATIONPARAMETER = new EmptyOperationParameter();

    private Sql context;

    // constructors
    private OperationParameterImpl( Sql context ) {
        this.context = context;
        m_TParm_ID = UniqueId.random();
        ref_Tfr_ID = UniqueId.random();
        m_Name = "";
        ref_DT_ID = UniqueId.random();
        m_By_Ref = 0;
        m_Dimensions = "";
        ref_Previous_TParm_ID = UniqueId.random();
        m_Descrip = "";
        R1015_represents_OperationArgument_set = new OperationArgumentSetImpl();
        R117_is_part_of__O_TFR_inst = O_TFRImpl.EMPTY_O_TFR;
        R118_is_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R121_may_have_Dimensions_set = new DimensionsSetImpl();
        R124_precedes_OperationParameter_inst = OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
        R124_succeeds_OperationParameter_inst = OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
        R833_ParameterValue_set = new ParameterValueSetImpl();
    }

    private OperationParameterImpl( Sql context, UniqueId instanceId, UniqueId m_TParm_ID, UniqueId ref_Tfr_ID, String m_Name, UniqueId ref_DT_ID, int m_By_Ref, String m_Dimensions, UniqueId ref_Previous_TParm_ID, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.m_TParm_ID = m_TParm_ID;
        this.ref_Tfr_ID = ref_Tfr_ID;
        this.m_Name = m_Name;
        this.ref_DT_ID = ref_DT_ID;
        this.m_By_Ref = m_By_Ref;
        this.m_Dimensions = m_Dimensions;
        this.ref_Previous_TParm_ID = ref_Previous_TParm_ID;
        this.m_Descrip = m_Descrip;
        R1015_represents_OperationArgument_set = new OperationArgumentSetImpl();
        R117_is_part_of__O_TFR_inst = O_TFRImpl.EMPTY_O_TFR;
        R118_is_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R121_may_have_Dimensions_set = new DimensionsSetImpl();
        R124_precedes_OperationParameter_inst = OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
        R124_succeeds_OperationParameter_inst = OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
        R833_ParameterValue_set = new ParameterValueSetImpl();
    }

    public static OperationParameter create( Sql context ) throws XtumlException {
        OperationParameter newOperationParameter = new OperationParameterImpl( context );
        if ( context.addInstance( newOperationParameter ) ) {
            newOperationParameter.getRunContext().addChange(new InstanceCreatedDelta(newOperationParameter, KEY_LETTERS));
            return newOperationParameter;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static OperationParameter create( Sql context, UniqueId m_TParm_ID, UniqueId ref_Tfr_ID, String m_Name, UniqueId ref_DT_ID, int m_By_Ref, String m_Dimensions, UniqueId ref_Previous_TParm_ID, String m_Descrip ) throws XtumlException {
        return create(context, UniqueId.random(), m_TParm_ID, ref_Tfr_ID, m_Name, ref_DT_ID, m_By_Ref, m_Dimensions, ref_Previous_TParm_ID, m_Descrip);
    }

    public static OperationParameter create( Sql context, UniqueId instanceId, UniqueId m_TParm_ID, UniqueId ref_Tfr_ID, String m_Name, UniqueId ref_DT_ID, int m_By_Ref, String m_Dimensions, UniqueId ref_Previous_TParm_ID, String m_Descrip ) throws XtumlException {
        OperationParameter newOperationParameter = new OperationParameterImpl( context, instanceId, m_TParm_ID, ref_Tfr_ID, m_Name, ref_DT_ID, m_By_Ref, m_Dimensions, ref_Previous_TParm_ID, m_Descrip );
        if ( context.addInstance( newOperationParameter ) ) {
            return newOperationParameter;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_TParm_ID;
    @Override
    public UniqueId getTParm_ID() throws XtumlException {
        checkLiving();
        return m_TParm_ID;
    }
    @Override
    public void setTParm_ID(UniqueId m_TParm_ID) throws XtumlException {
        checkLiving();
        if (m_TParm_ID.inequality( this.m_TParm_ID)) {
            final UniqueId oldValue = this.m_TParm_ID;
            this.m_TParm_ID = m_TParm_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_TParm_ID", oldValue, this.m_TParm_ID));
            if ( !R124_precedes_OperationParameter().isEmpty() ) R124_precedes_OperationParameter().setPrevious_TParm_ID( m_TParm_ID );
            if ( !R121_may_have_Dimensions().isEmpty() ) R121_may_have_Dimensions().setTParm_ID( m_TParm_ID );
            if ( !R1015_represents_OperationArgument().isEmpty() ) R1015_represents_OperationArgument().setTParm_ID( m_TParm_ID );
            if ( !R833_ParameterValue().isEmpty() ) R833_ParameterValue().setTParm_ID( m_TParm_ID );
        }
    }
    private UniqueId ref_Tfr_ID;
    @Override
    public UniqueId getTfr_ID() throws XtumlException {
        checkLiving();
        return ref_Tfr_ID;
    }
    @Override
    public void setTfr_ID(UniqueId ref_Tfr_ID) throws XtumlException {
        checkLiving();
        if (ref_Tfr_ID.inequality( this.ref_Tfr_ID)) {
            final UniqueId oldValue = this.ref_Tfr_ID;
            this.ref_Tfr_ID = ref_Tfr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Tfr_ID", oldValue, this.ref_Tfr_ID));
        }
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private UniqueId ref_DT_ID;
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    private int m_By_Ref;
    @Override
    public int getBy_Ref() throws XtumlException {
        checkLiving();
        return m_By_Ref;
    }
    @Override
    public void setBy_Ref(int m_By_Ref) throws XtumlException {
        checkLiving();
        if (m_By_Ref != this.m_By_Ref) {
            final int oldValue = this.m_By_Ref;
            this.m_By_Ref = m_By_Ref;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_By_Ref", oldValue, this.m_By_Ref));
        }
    }
    private String m_Dimensions;
    @Override
    public String getDimensions() throws XtumlException {
        checkLiving();
        return m_Dimensions;
    }
    @Override
    public void setDimensions(String m_Dimensions) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Dimensions, this.m_Dimensions)) {
            final String oldValue = this.m_Dimensions;
            this.m_Dimensions = m_Dimensions;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dimensions", oldValue, this.m_Dimensions));
        }
    }
    private UniqueId ref_Previous_TParm_ID;
    @Override
    public UniqueId getPrevious_TParm_ID() throws XtumlException {
        checkLiving();
        return ref_Previous_TParm_ID;
    }
    @Override
    public void setPrevious_TParm_ID(UniqueId ref_Previous_TParm_ID) throws XtumlException {
        checkLiving();
        if (ref_Previous_TParm_ID.inequality( this.ref_Previous_TParm_ID)) {
            final UniqueId oldValue = this.ref_Previous_TParm_ID;
            this.ref_Previous_TParm_ID = ref_Previous_TParm_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Previous_TParm_ID", oldValue, this.ref_Previous_TParm_ID));
        }
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getTParm_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private OperationArgumentSet R1015_represents_OperationArgument_set;
    @Override
    public void addR1015_represents_OperationArgument( OperationArgument inst ) {
        R1015_represents_OperationArgument_set.add(inst);
    }
    @Override
    public void removeR1015_represents_OperationArgument( OperationArgument inst ) {
        R1015_represents_OperationArgument_set.remove(inst);
    }
    @Override
    public OperationArgumentSet R1015_represents_OperationArgument() throws XtumlException {
        return R1015_represents_OperationArgument_set;
    }
    private O_TFR R117_is_part_of__O_TFR_inst;
    @Override
    public void setR117_is_part_of__O_TFR( O_TFR inst ) {
        R117_is_part_of__O_TFR_inst = inst;
    }
    @Override
    public O_TFR R117_is_part_of__O_TFR() throws XtumlException {
        return R117_is_part_of__O_TFR_inst;
    }
    private DataType R118_is_defined_by_DataType_inst;
    @Override
    public void setR118_is_defined_by_DataType( DataType inst ) {
        R118_is_defined_by_DataType_inst = inst;
    }
    @Override
    public DataType R118_is_defined_by_DataType() throws XtumlException {
        return R118_is_defined_by_DataType_inst;
    }
    private DimensionsSet R121_may_have_Dimensions_set;
    @Override
    public void addR121_may_have_Dimensions( Dimensions inst ) {
        R121_may_have_Dimensions_set.add(inst);
    }
    @Override
    public void removeR121_may_have_Dimensions( Dimensions inst ) {
        R121_may_have_Dimensions_set.remove(inst);
    }
    @Override
    public DimensionsSet R121_may_have_Dimensions() throws XtumlException {
        return R121_may_have_Dimensions_set;
    }
    private OperationParameter R124_precedes_OperationParameter_inst;
    @Override
    public void setR124_precedes_OperationParameter( OperationParameter inst ) {
        R124_precedes_OperationParameter_inst = inst;
    }
    @Override
    public OperationParameter R124_precedes_OperationParameter() throws XtumlException {
        return R124_precedes_OperationParameter_inst;
    }
    private OperationParameter R124_succeeds_OperationParameter_inst;
    @Override
    public void setR124_succeeds_OperationParameter( OperationParameter inst ) {
        R124_succeeds_OperationParameter_inst = inst;
    }
    @Override
    public OperationParameter R124_succeeds_OperationParameter() throws XtumlException {
        return R124_succeeds_OperationParameter_inst;
    }
    private ParameterValueSet R833_ParameterValue_set;
    @Override
    public void addR833_ParameterValue( ParameterValue inst ) {
        R833_ParameterValue_set.add(inst);
    }
    @Override
    public void removeR833_ParameterValue( ParameterValue inst ) {
        R833_ParameterValue_set.remove(inst);
    }
    @Override
    public ParameterValueSet R833_ParameterValue() throws XtumlException {
        return R833_ParameterValue_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public OperationParameter self() {
        return this;
    }

    @Override
    public OperationParameter oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_OPERATIONPARAMETER;
    }

}

class EmptyOperationParameter extends ModelInstance<OperationParameter,Sql> implements OperationParameter {

    // attributes
    public UniqueId getTParm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTParm_ID( UniqueId m_TParm_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTfr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTfr_ID( UniqueId ref_Tfr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getBy_Ref() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBy_Ref( int m_By_Ref ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDimensions() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDimensions( String m_Dimensions ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPrevious_TParm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrevious_TParm_ID( UniqueId ref_Previous_TParm_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public OperationArgumentSet R1015_represents_OperationArgument() {
        return (new OperationArgumentSetImpl());
    }
    @Override
    public O_TFR R117_is_part_of__O_TFR() {
        return O_TFRImpl.EMPTY_O_TFR;
    }
    @Override
    public DataType R118_is_defined_by_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public DimensionsSet R121_may_have_Dimensions() {
        return (new DimensionsSetImpl());
    }
    @Override
    public OperationParameter R124_precedes_OperationParameter() {
        return OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
    }
    @Override
    public OperationParameter R124_succeeds_OperationParameter() {
        return OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
    }
    @Override
    public ParameterValueSet R833_ParameterValue() {
        return (new ParameterValueSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return OperationParameterImpl.KEY_LETTERS;
    }

    @Override
    public OperationParameter self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public OperationParameter oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
    }

}
