package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.subsystem.BaseAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.NewBaseAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.BaseAttributeImpl;


public class NewBaseAttributeImpl extends ModelInstance<NewBaseAttribute,Sql> implements NewBaseAttribute {

    public static final String KEY_LETTERS = "O_NBATTR";
    public static final NewBaseAttribute EMPTY_NEWBASEATTRIBUTE = new EmptyNewBaseAttribute();

    private Sql context;

    // constructors
    private NewBaseAttributeImpl( Sql context ) {
        this.context = context;
        ref_Attr_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        R107_is_a_BaseAttribute_inst = BaseAttributeImpl.EMPTY_BASEATTRIBUTE;
    }

    private NewBaseAttributeImpl( Sql context, UniqueId instanceId, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Attr_ID = ref_Attr_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        R107_is_a_BaseAttribute_inst = BaseAttributeImpl.EMPTY_BASEATTRIBUTE;
    }

    public static NewBaseAttribute create( Sql context ) throws XtumlException {
        NewBaseAttribute newNewBaseAttribute = new NewBaseAttributeImpl( context );
        if ( context.addInstance( newNewBaseAttribute ) ) {
            newNewBaseAttribute.getRunContext().addChange(new InstanceCreatedDelta(newNewBaseAttribute, KEY_LETTERS));
            return newNewBaseAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static NewBaseAttribute create( Sql context, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Attr_ID, ref_Obj_ID);
    }

    public static NewBaseAttribute create( Sql context, UniqueId instanceId, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID ) throws XtumlException {
        NewBaseAttribute newNewBaseAttribute = new NewBaseAttributeImpl( context, instanceId, ref_Attr_ID, ref_Obj_ID );
        if ( context.addInstance( newNewBaseAttribute ) ) {
            return newNewBaseAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Attr_ID;
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
        return ref_Attr_ID;
    }
    @Override
    public void setAttr_ID(UniqueId ref_Attr_ID) throws XtumlException {
        checkLiving();
        if (ref_Attr_ID.inequality( this.ref_Attr_ID)) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAttr_ID(), getObj_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private BaseAttribute R107_is_a_BaseAttribute_inst;
    @Override
    public void setR107_is_a_BaseAttribute( BaseAttribute inst ) {
        R107_is_a_BaseAttribute_inst = inst;
    }
    @Override
    public BaseAttribute R107_is_a_BaseAttribute() throws XtumlException {
        return R107_is_a_BaseAttribute_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public NewBaseAttribute self() {
        return this;
    }

    @Override
    public NewBaseAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_NEWBASEATTRIBUTE;
    }

}

class EmptyNewBaseAttribute extends ModelInstance<NewBaseAttribute,Sql> implements NewBaseAttribute {

    // attributes
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public BaseAttribute R107_is_a_BaseAttribute() {
        return BaseAttributeImpl.EMPTY_BASEATTRIBUTE;
    }


    @Override
    public String getKeyLetters() {
        return NewBaseAttributeImpl.KEY_LETTERS;
    }

    @Override
    public NewBaseAttribute self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public NewBaseAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return NewBaseAttributeImpl.EMPTY_NEWBASEATTRIBUTE;
    }

}
