package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.Dimensions;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;
import io.ciera.tool.sql.ooaofooa.instance.DataItemValue;
import io.ciera.tool.sql.ooaofooa.instance.DataItemValueSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.DataItemValueSetImpl;
import io.ciera.tool.sql.ooaofooa.message.EventArgument;
import io.ciera.tool.sql.ooaofooa.message.EventArgumentSet;
import io.ciera.tool.sql.ooaofooa.message.impl.EventArgumentSetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.SM_SM;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEventDataItem;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SM_SMImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventDataItemImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventImpl;
import io.ciera.tool.sql.ooaofooa.value.EventParameterReference;
import io.ciera.tool.sql.ooaofooa.value.EventParameterReferenceSet;
import io.ciera.tool.sql.ooaofooa.value.impl.EventParameterReferenceSetImpl;


public class StateMachineEventDataItemImpl extends ModelInstance<StateMachineEventDataItem,Sql> implements StateMachineEventDataItem {

    public static final String KEY_LETTERS = "SM_EVTDI";
    public static final StateMachineEventDataItem EMPTY_STATEMACHINEEVENTDATAITEM = new EmptyStateMachineEventDataItem();

    private Sql context;

    // constructors
    private StateMachineEventDataItemImpl( Sql context ) {
        this.context = context;
        m_SMedi_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        ref_DT_ID = UniqueId.random();
        m_Dimensions = "";
        ref_SMevt_ID = UniqueId.random();
        ref_Previous_SMedi_ID = UniqueId.random();
        R1017_represents_EventArgument_set = new EventArgumentSetImpl();
        R2934_DataItemValue_set = new DataItemValueSetImpl();
        R516_is_carried_on_events_into_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R524_is_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R531_may_have_Dimensions_set = new DimensionsSetImpl();
        R532_carried_by_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
        R533_precedes_StateMachineEventDataItem_inst = StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
        R533_succeeds_StateMachineEventDataItem_inst = StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
        R846_EventParameterReference_set = new EventParameterReferenceSetImpl();
    }

    private StateMachineEventDataItemImpl( Sql context, UniqueId instanceId, UniqueId m_SMedi_ID, UniqueId ref_SM_ID, String m_Name, String m_Descrip, UniqueId ref_DT_ID, String m_Dimensions, UniqueId ref_SMevt_ID, UniqueId ref_Previous_SMedi_ID ) {
        super(instanceId);
        this.context = context;
        this.m_SMedi_ID = m_SMedi_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.ref_DT_ID = ref_DT_ID;
        this.m_Dimensions = m_Dimensions;
        this.ref_SMevt_ID = ref_SMevt_ID;
        this.ref_Previous_SMedi_ID = ref_Previous_SMedi_ID;
        R1017_represents_EventArgument_set = new EventArgumentSetImpl();
        R2934_DataItemValue_set = new DataItemValueSetImpl();
        R516_is_carried_on_events_into_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R524_is_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R531_may_have_Dimensions_set = new DimensionsSetImpl();
        R532_carried_by_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
        R533_precedes_StateMachineEventDataItem_inst = StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
        R533_succeeds_StateMachineEventDataItem_inst = StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
        R846_EventParameterReference_set = new EventParameterReferenceSetImpl();
    }

    public static StateMachineEventDataItem create( Sql context ) throws XtumlException {
        StateMachineEventDataItem newStateMachineEventDataItem = new StateMachineEventDataItemImpl( context );
        if ( context.addInstance( newStateMachineEventDataItem ) ) {
            newStateMachineEventDataItem.getRunContext().addChange(new InstanceCreatedDelta(newStateMachineEventDataItem, KEY_LETTERS));
            return newStateMachineEventDataItem;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static StateMachineEventDataItem create( Sql context, UniqueId m_SMedi_ID, UniqueId ref_SM_ID, String m_Name, String m_Descrip, UniqueId ref_DT_ID, String m_Dimensions, UniqueId ref_SMevt_ID, UniqueId ref_Previous_SMedi_ID ) throws XtumlException {
        return create(context, UniqueId.random(), m_SMedi_ID, ref_SM_ID, m_Name, m_Descrip, ref_DT_ID, m_Dimensions, ref_SMevt_ID, ref_Previous_SMedi_ID);
    }

    public static StateMachineEventDataItem create( Sql context, UniqueId instanceId, UniqueId m_SMedi_ID, UniqueId ref_SM_ID, String m_Name, String m_Descrip, UniqueId ref_DT_ID, String m_Dimensions, UniqueId ref_SMevt_ID, UniqueId ref_Previous_SMedi_ID ) throws XtumlException {
        StateMachineEventDataItem newStateMachineEventDataItem = new StateMachineEventDataItemImpl( context, instanceId, m_SMedi_ID, ref_SM_ID, m_Name, m_Descrip, ref_DT_ID, m_Dimensions, ref_SMevt_ID, ref_Previous_SMedi_ID );
        if ( context.addInstance( newStateMachineEventDataItem ) ) {
            return newStateMachineEventDataItem;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_SMedi_ID;
    @Override
    public void setSMedi_ID(UniqueId m_SMedi_ID) throws XtumlException {
        checkLiving();
        if (m_SMedi_ID.inequality( this.m_SMedi_ID)) {
            final UniqueId oldValue = this.m_SMedi_ID;
            this.m_SMedi_ID = m_SMedi_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMedi_ID", oldValue, this.m_SMedi_ID));
            if ( !R531_may_have_Dimensions().isEmpty() ) R531_may_have_Dimensions().setSMedi_ID( m_SMedi_ID );
            if ( !R2934_DataItemValue().isEmpty() ) R2934_DataItemValue().setSMedi_ID( m_SMedi_ID );
            if ( !R1017_represents_EventArgument().isEmpty() ) R1017_represents_EventArgument().setSMedi_ID( m_SMedi_ID );
            if ( !R533_precedes_StateMachineEventDataItem().isEmpty() ) R533_precedes_StateMachineEventDataItem().setPrevious_SMedi_ID( m_SMedi_ID );
            if ( !R846_EventParameterReference().isEmpty() ) R846_EventParameterReference().setSMedi_ID( m_SMedi_ID );
        }
    }
    @Override
    public UniqueId getSMedi_ID() throws XtumlException {
        checkLiving();
        return m_SMedi_ID;
    }
    private UniqueId ref_SM_ID;
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
            if ( !R846_EventParameterReference().isEmpty() ) R846_EventParameterReference().setSM_ID( ref_SM_ID );
            if ( !R533_precedes_StateMachineEventDataItem().isEmpty() ) R533_precedes_StateMachineEventDataItem().setSM_ID( ref_SM_ID );
            if ( !R1017_represents_EventArgument().isEmpty() ) R1017_represents_EventArgument().setSM_ID( ref_SM_ID );
            if ( !R531_may_have_Dimensions().isEmpty() ) R531_may_have_Dimensions().setSM_ID( ref_SM_ID );
            if ( !R2934_DataItemValue().isEmpty() ) R2934_DataItemValue().setSM_ID( ref_SM_ID );
        }
    }
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private UniqueId ref_DT_ID;
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    private String m_Dimensions;
    @Override
    public String getDimensions() throws XtumlException {
        checkLiving();
        return m_Dimensions;
    }
    @Override
    public void setDimensions(String m_Dimensions) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Dimensions, this.m_Dimensions)) {
            final String oldValue = this.m_Dimensions;
            this.m_Dimensions = m_Dimensions;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dimensions", oldValue, this.m_Dimensions));
        }
    }
    private UniqueId ref_SMevt_ID;
    @Override
    public void setSMevt_ID(UniqueId ref_SMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMevt_ID.inequality( this.ref_SMevt_ID)) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
        }
    }
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
        return ref_SMevt_ID;
    }
    private UniqueId ref_Previous_SMedi_ID;
    @Override
    public UniqueId getPrevious_SMedi_ID() throws XtumlException {
        checkLiving();
        return ref_Previous_SMedi_ID;
    }
    @Override
    public void setPrevious_SMedi_ID(UniqueId ref_Previous_SMedi_ID) throws XtumlException {
        checkLiving();
        if (ref_Previous_SMedi_ID.inequality( this.ref_Previous_SMedi_ID)) {
            final UniqueId oldValue = this.ref_Previous_SMedi_ID;
            this.ref_Previous_SMedi_ID = ref_Previous_SMedi_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Previous_SMedi_ID", oldValue, this.ref_Previous_SMedi_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSMedi_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private EventArgumentSet R1017_represents_EventArgument_set;
    @Override
    public void addR1017_represents_EventArgument( EventArgument inst ) {
        R1017_represents_EventArgument_set.add(inst);
    }
    @Override
    public void removeR1017_represents_EventArgument( EventArgument inst ) {
        R1017_represents_EventArgument_set.remove(inst);
    }
    @Override
    public EventArgumentSet R1017_represents_EventArgument() throws XtumlException {
        return R1017_represents_EventArgument_set;
    }
    private DataItemValueSet R2934_DataItemValue_set;
    @Override
    public void addR2934_DataItemValue( DataItemValue inst ) {
        R2934_DataItemValue_set.add(inst);
    }
    @Override
    public void removeR2934_DataItemValue( DataItemValue inst ) {
        R2934_DataItemValue_set.remove(inst);
    }
    @Override
    public DataItemValueSet R2934_DataItemValue() throws XtumlException {
        return R2934_DataItemValue_set;
    }
    private SM_SM R516_is_carried_on_events_into_SM_SM_inst;
    @Override
    public void setR516_is_carried_on_events_into_SM_SM( SM_SM inst ) {
        R516_is_carried_on_events_into_SM_SM_inst = inst;
    }
    @Override
    public SM_SM R516_is_carried_on_events_into_SM_SM() throws XtumlException {
        return R516_is_carried_on_events_into_SM_SM_inst;
    }
    private DataType R524_is_defined_by_DataType_inst;
    @Override
    public void setR524_is_defined_by_DataType( DataType inst ) {
        R524_is_defined_by_DataType_inst = inst;
    }
    @Override
    public DataType R524_is_defined_by_DataType() throws XtumlException {
        return R524_is_defined_by_DataType_inst;
    }
    private DimensionsSet R531_may_have_Dimensions_set;
    @Override
    public void addR531_may_have_Dimensions( Dimensions inst ) {
        R531_may_have_Dimensions_set.add(inst);
    }
    @Override
    public void removeR531_may_have_Dimensions( Dimensions inst ) {
        R531_may_have_Dimensions_set.remove(inst);
    }
    @Override
    public DimensionsSet R531_may_have_Dimensions() throws XtumlException {
        return R531_may_have_Dimensions_set;
    }
    private StateMachineEvent R532_carried_by_StateMachineEvent_inst;
    @Override
    public void setR532_carried_by_StateMachineEvent( StateMachineEvent inst ) {
        R532_carried_by_StateMachineEvent_inst = inst;
    }
    @Override
    public StateMachineEvent R532_carried_by_StateMachineEvent() throws XtumlException {
        return R532_carried_by_StateMachineEvent_inst;
    }
    private StateMachineEventDataItem R533_precedes_StateMachineEventDataItem_inst;
    @Override
    public void setR533_precedes_StateMachineEventDataItem( StateMachineEventDataItem inst ) {
        R533_precedes_StateMachineEventDataItem_inst = inst;
    }
    @Override
    public StateMachineEventDataItem R533_precedes_StateMachineEventDataItem() throws XtumlException {
        return R533_precedes_StateMachineEventDataItem_inst;
    }
    private StateMachineEventDataItem R533_succeeds_StateMachineEventDataItem_inst;
    @Override
    public void setR533_succeeds_StateMachineEventDataItem( StateMachineEventDataItem inst ) {
        R533_succeeds_StateMachineEventDataItem_inst = inst;
    }
    @Override
    public StateMachineEventDataItem R533_succeeds_StateMachineEventDataItem() throws XtumlException {
        return R533_succeeds_StateMachineEventDataItem_inst;
    }
    private EventParameterReferenceSet R846_EventParameterReference_set;
    @Override
    public void addR846_EventParameterReference( EventParameterReference inst ) {
        R846_EventParameterReference_set.add(inst);
    }
    @Override
    public void removeR846_EventParameterReference( EventParameterReference inst ) {
        R846_EventParameterReference_set.remove(inst);
    }
    @Override
    public EventParameterReferenceSet R846_EventParameterReference() throws XtumlException {
        return R846_EventParameterReference_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public StateMachineEventDataItem self() {
        return this;
    }

    @Override
    public StateMachineEventDataItem oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_STATEMACHINEEVENTDATAITEM;
    }

}

class EmptyStateMachineEventDataItem extends ModelInstance<StateMachineEventDataItem,Sql> implements StateMachineEventDataItem {

    // attributes
    public void setSMedi_ID( UniqueId m_SMedi_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMedi_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDimensions() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDimensions( String m_Dimensions ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getPrevious_SMedi_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrevious_SMedi_ID( UniqueId ref_Previous_SMedi_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public EventArgumentSet R1017_represents_EventArgument() {
        return (new EventArgumentSetImpl());
    }
    @Override
    public DataItemValueSet R2934_DataItemValue() {
        return (new DataItemValueSetImpl());
    }
    @Override
    public SM_SM R516_is_carried_on_events_into_SM_SM() {
        return SM_SMImpl.EMPTY_SM_SM;
    }
    @Override
    public DataType R524_is_defined_by_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public DimensionsSet R531_may_have_Dimensions() {
        return (new DimensionsSetImpl());
    }
    @Override
    public StateMachineEvent R532_carried_by_StateMachineEvent() {
        return StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }
    @Override
    public StateMachineEventDataItem R533_precedes_StateMachineEventDataItem() {
        return StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
    }
    @Override
    public StateMachineEventDataItem R533_succeeds_StateMachineEventDataItem() {
        return StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
    }
    @Override
    public EventParameterReferenceSet R846_EventParameterReference() {
        return (new EventParameterReferenceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return StateMachineEventDataItemImpl.KEY_LETTERS;
    }

    @Override
    public StateMachineEventDataItem self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public StateMachineEventDataItem oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
    }

}
