package io.ciera.tool.sql.ooaofooa.selection.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.selection.SelectFromInstancesWhere;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class SelectFromInstancesWhereImpl extends ModelInstance<SelectFromInstancesWhere,Sql> implements SelectFromInstancesWhere {

    public static final String KEY_LETTERS = "ACT_FIW";
    public static final SelectFromInstancesWhere EMPTY_SELECTFROMINSTANCESWHERE = new EmptySelectFromInstancesWhere();

    private Sql context;

    // constructors
    private SelectFromInstancesWhereImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Var_ID = UniqueId.random();
        m_is_implicit = false;
        m_cardinality = "";
        ref_Where_Clause_Value_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        m_extentLineNumber = 0;
        m_extentColumn = 0;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R610_where_clause_Value_inst = ValueImpl.EMPTY_VALUE;
        R665_result_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R676_from_extent_of_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    private SelectFromInstancesWhereImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Var_ID, boolean m_is_implicit, String m_cardinality, UniqueId ref_Where_Clause_Value_ID, UniqueId ref_Obj_ID, int m_extentLineNumber, int m_extentColumn ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Var_ID = ref_Var_ID;
        this.m_is_implicit = m_is_implicit;
        this.m_cardinality = m_cardinality;
        this.ref_Where_Clause_Value_ID = ref_Where_Clause_Value_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.m_extentLineNumber = m_extentLineNumber;
        this.m_extentColumn = m_extentColumn;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R610_where_clause_Value_inst = ValueImpl.EMPTY_VALUE;
        R665_result_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R676_from_extent_of_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    public static SelectFromInstancesWhere create( Sql context ) throws XtumlException {
        SelectFromInstancesWhere newSelectFromInstancesWhere = new SelectFromInstancesWhereImpl( context );
        if ( context.addInstance( newSelectFromInstancesWhere ) ) {
            newSelectFromInstancesWhere.getRunContext().addChange(new InstanceCreatedDelta(newSelectFromInstancesWhere, KEY_LETTERS));
            return newSelectFromInstancesWhere;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SelectFromInstancesWhere create( Sql context, UniqueId ref_Statement_ID, UniqueId ref_Var_ID, boolean m_is_implicit, String m_cardinality, UniqueId ref_Where_Clause_Value_ID, UniqueId ref_Obj_ID, int m_extentLineNumber, int m_extentColumn ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Statement_ID, ref_Var_ID, m_is_implicit, m_cardinality, ref_Where_Clause_Value_ID, ref_Obj_ID, m_extentLineNumber, m_extentColumn);
    }

    public static SelectFromInstancesWhere create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Var_ID, boolean m_is_implicit, String m_cardinality, UniqueId ref_Where_Clause_Value_ID, UniqueId ref_Obj_ID, int m_extentLineNumber, int m_extentColumn ) throws XtumlException {
        SelectFromInstancesWhere newSelectFromInstancesWhere = new SelectFromInstancesWhereImpl( context, instanceId, ref_Statement_ID, ref_Var_ID, m_is_implicit, m_cardinality, ref_Where_Clause_Value_ID, ref_Obj_ID, m_extentLineNumber, m_extentColumn );
        if ( context.addInstance( newSelectFromInstancesWhere ) ) {
            return newSelectFromInstancesWhere;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    private UniqueId ref_Var_ID;
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
        return ref_Var_ID;
    }
    @Override
    public void setVar_ID(UniqueId ref_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Var_ID.inequality( this.ref_Var_ID)) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
        }
    }
    private boolean m_is_implicit;
    @Override
    public void setIs_implicit(boolean m_is_implicit) throws XtumlException {
        checkLiving();
        if (m_is_implicit != this.m_is_implicit) {
            final boolean oldValue = this.m_is_implicit;
            this.m_is_implicit = m_is_implicit;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_is_implicit", oldValue, this.m_is_implicit));
        }
    }
    @Override
    public boolean getIs_implicit() throws XtumlException {
        checkLiving();
        return m_is_implicit;
    }
    private String m_cardinality;
    @Override
    public void setCardinality(String m_cardinality) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_cardinality, this.m_cardinality)) {
            final String oldValue = this.m_cardinality;
            this.m_cardinality = m_cardinality;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_cardinality", oldValue, this.m_cardinality));
        }
    }
    @Override
    public String getCardinality() throws XtumlException {
        checkLiving();
        return m_cardinality;
    }
    private UniqueId ref_Where_Clause_Value_ID;
    @Override
    public UniqueId getWhere_Clause_Value_ID() throws XtumlException {
        checkLiving();
        return ref_Where_Clause_Value_ID;
    }
    @Override
    public void setWhere_Clause_Value_ID(UniqueId ref_Where_Clause_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Where_Clause_Value_ID.inequality( this.ref_Where_Clause_Value_ID)) {
            final UniqueId oldValue = this.ref_Where_Clause_Value_ID;
            this.ref_Where_Clause_Value_ID = ref_Where_Clause_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Where_Clause_Value_ID", oldValue, this.ref_Where_Clause_Value_ID));
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    private int m_extentLineNumber;
    @Override
    public int getExtentLineNumber() throws XtumlException {
        checkLiving();
        return m_extentLineNumber;
    }
    @Override
    public void setExtentLineNumber(int m_extentLineNumber) throws XtumlException {
        checkLiving();
        if (m_extentLineNumber != this.m_extentLineNumber) {
            final int oldValue = this.m_extentLineNumber;
            this.m_extentLineNumber = m_extentLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_extentLineNumber", oldValue, this.m_extentLineNumber));
        }
    }
    private int m_extentColumn;
    @Override
    public void setExtentColumn(int m_extentColumn) throws XtumlException {
        checkLiving();
        if (m_extentColumn != this.m_extentColumn) {
            final int oldValue = this.m_extentColumn;
            this.m_extentColumn = m_extentColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_extentColumn", oldValue, this.m_extentColumn));
        }
    }
    @Override
    public int getExtentColumn() throws XtumlException {
        checkLiving();
        return m_extentColumn;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private Value R610_where_clause_Value_inst;
    @Override
    public void setR610_where_clause_Value( Value inst ) {
        R610_where_clause_Value_inst = inst;
    }
    @Override
    public Value R610_where_clause_Value() throws XtumlException {
        return R610_where_clause_Value_inst;
    }
    private V_VAR R665_result_V_VAR_inst;
    @Override
    public void setR665_result_V_VAR( V_VAR inst ) {
        R665_result_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R665_result_V_VAR() throws XtumlException {
        return R665_result_V_VAR_inst;
    }
    private ModelClass R676_from_extent_of_ModelClass_inst;
    @Override
    public void setR676_from_extent_of_ModelClass( ModelClass inst ) {
        R676_from_extent_of_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R676_from_extent_of_ModelClass() throws XtumlException {
        return R676_from_extent_of_ModelClass_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SelectFromInstancesWhere self() {
        return this;
    }

    @Override
    public SelectFromInstancesWhere oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SELECTFROMINSTANCESWHERE;
    }

}

class EmptySelectFromInstancesWhere extends ModelInstance<SelectFromInstancesWhere,Sql> implements SelectFromInstancesWhere {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setIs_implicit( boolean m_is_implicit ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIs_implicit() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setCardinality( String m_cardinality ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getCardinality() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getWhere_Clause_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setWhere_Clause_Value_ID( UniqueId ref_Where_Clause_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getExtentLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExtentLineNumber( int m_extentLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setExtentColumn( int m_extentColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getExtentColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public Value R610_where_clause_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public V_VAR R665_result_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }
    @Override
    public ModelClass R676_from_extent_of_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }


    @Override
    public String getKeyLetters() {
        return SelectFromInstancesWhereImpl.KEY_LETTERS;
    }

    @Override
    public SelectFromInstancesWhere self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SelectFromInstancesWhere oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SelectFromInstancesWhereImpl.EMPTY_SELECTFROMINSTANCESWHERE;
    }

}
