package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.message.MSG_M;
import io.ciera.tool.sql.ooaofooa.message.ReturnMessage;
import io.ciera.tool.sql.ooaofooa.message.impl.MSG_MImpl;


public class ReturnMessageImpl extends ModelInstance<ReturnMessage,Sql> implements ReturnMessage {

    public static final String KEY_LETTERS = "MSG_R";
    public static final ReturnMessage EMPTY_RETURNMESSAGE = new EmptyReturnMessage();

    private Sql context;

    // constructors
    private ReturnMessageImpl( Sql context ) {
        this.context = context;
        ref_Msg_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_GuardCondition = "";
        m_ResultTarget = "";
        m_ReturnValue = "";
        m_SequenceNumb = "";
        R1018_is_a_MSG_M_inst = MSG_MImpl.EMPTY_MSG_M;
    }

    private ReturnMessageImpl( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, String m_Name, String m_Descrip, String m_GuardCondition, String m_ResultTarget, String m_ReturnValue, String m_SequenceNumb ) {
        super(instanceId);
        this.context = context;
        this.ref_Msg_ID = ref_Msg_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_GuardCondition = m_GuardCondition;
        this.m_ResultTarget = m_ResultTarget;
        this.m_ReturnValue = m_ReturnValue;
        this.m_SequenceNumb = m_SequenceNumb;
        R1018_is_a_MSG_M_inst = MSG_MImpl.EMPTY_MSG_M;
    }

    public static ReturnMessage create( Sql context ) throws XtumlException {
        ReturnMessage newReturnMessage = new ReturnMessageImpl( context );
        if ( context.addInstance( newReturnMessage ) ) {
            newReturnMessage.getRunContext().addChange(new InstanceCreatedDelta(newReturnMessage, KEY_LETTERS));
            return newReturnMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ReturnMessage create( Sql context, UniqueId ref_Msg_ID, String m_Name, String m_Descrip, String m_GuardCondition, String m_ResultTarget, String m_ReturnValue, String m_SequenceNumb ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Msg_ID, m_Name, m_Descrip, m_GuardCondition, m_ResultTarget, m_ReturnValue, m_SequenceNumb);
    }

    public static ReturnMessage create( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, String m_Name, String m_Descrip, String m_GuardCondition, String m_ResultTarget, String m_ReturnValue, String m_SequenceNumb ) throws XtumlException {
        ReturnMessage newReturnMessage = new ReturnMessageImpl( context, instanceId, ref_Msg_ID, m_Name, m_Descrip, m_GuardCondition, m_ResultTarget, m_ReturnValue, m_SequenceNumb );
        if ( context.addInstance( newReturnMessage ) ) {
            return newReturnMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Msg_ID;
    @Override
    public void setMsg_ID(UniqueId ref_Msg_ID) throws XtumlException {
        checkLiving();
        if (ref_Msg_ID.inequality( this.ref_Msg_ID)) {
            final UniqueId oldValue = this.ref_Msg_ID;
            this.ref_Msg_ID = ref_Msg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Msg_ID", oldValue, this.ref_Msg_ID));
        }
    }
    @Override
    public UniqueId getMsg_ID() throws XtumlException {
        checkLiving();
        return ref_Msg_ID;
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private String m_GuardCondition;
    @Override
    public void setGuardCondition(String m_GuardCondition) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_GuardCondition, this.m_GuardCondition)) {
            final String oldValue = this.m_GuardCondition;
            this.m_GuardCondition = m_GuardCondition;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_GuardCondition", oldValue, this.m_GuardCondition));
        }
    }
    @Override
    public String getGuardCondition() throws XtumlException {
        checkLiving();
        return m_GuardCondition;
    }
    private String m_ResultTarget;
    @Override
    public void setResultTarget(String m_ResultTarget) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_ResultTarget, this.m_ResultTarget)) {
            final String oldValue = this.m_ResultTarget;
            this.m_ResultTarget = m_ResultTarget;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_ResultTarget", oldValue, this.m_ResultTarget));
        }
    }
    @Override
    public String getResultTarget() throws XtumlException {
        checkLiving();
        return m_ResultTarget;
    }
    private String m_ReturnValue;
    @Override
    public void setReturnValue(String m_ReturnValue) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_ReturnValue, this.m_ReturnValue)) {
            final String oldValue = this.m_ReturnValue;
            this.m_ReturnValue = m_ReturnValue;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_ReturnValue", oldValue, this.m_ReturnValue));
        }
    }
    @Override
    public String getReturnValue() throws XtumlException {
        checkLiving();
        return m_ReturnValue;
    }
    private String m_SequenceNumb;
    @Override
    public void setSequenceNumb(String m_SequenceNumb) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_SequenceNumb, this.m_SequenceNumb)) {
            final String oldValue = this.m_SequenceNumb;
            this.m_SequenceNumb = m_SequenceNumb;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SequenceNumb", oldValue, this.m_SequenceNumb));
        }
    }
    @Override
    public String getSequenceNumb() throws XtumlException {
        checkLiving();
        return m_SequenceNumb;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getMsg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private MSG_M R1018_is_a_MSG_M_inst;
    @Override
    public void setR1018_is_a_MSG_M( MSG_M inst ) {
        R1018_is_a_MSG_M_inst = inst;
    }
    @Override
    public MSG_M R1018_is_a_MSG_M() throws XtumlException {
        return R1018_is_a_MSG_M_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ReturnMessage self() {
        return this;
    }

    @Override
    public ReturnMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_RETURNMESSAGE;
    }

}

class EmptyReturnMessage extends ModelInstance<ReturnMessage,Sql> implements ReturnMessage {

    // attributes
    public void setMsg_ID( UniqueId ref_Msg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getMsg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setGuardCondition( String m_GuardCondition ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getGuardCondition() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setResultTarget( String m_ResultTarget ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getResultTarget() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReturnValue( String m_ReturnValue ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getReturnValue() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSequenceNumb( String m_SequenceNumb ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSequenceNumb() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MSG_M R1018_is_a_MSG_M() {
        return MSG_MImpl.EMPTY_MSG_M;
    }


    @Override
    public String getKeyLetters() {
        return ReturnMessageImpl.KEY_LETTERS;
    }

    @Override
    public ReturnMessage self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ReturnMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ReturnMessageImpl.EMPTY_RETURNMESSAGE;
    }

}
