package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.InterfaceOperation;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceOperationImpl;
import io.ciera.tool.sql.ooaofooa.message.InterfaceOperationMessage;
import io.ciera.tool.sql.ooaofooa.message.SynchronousMessage;
import io.ciera.tool.sql.ooaofooa.message.impl.SynchronousMessageImpl;


public class InterfaceOperationMessageImpl extends ModelInstance<InterfaceOperationMessage,Sql> implements InterfaceOperationMessage {

    public static final String KEY_LETTERS = "MSG_IOP";
    public static final InterfaceOperationMessage EMPTY_INTERFACEOPERATIONMESSAGE = new EmptyInterfaceOperationMessage();

    private Sql context;

    // constructors
    private InterfaceOperationMessageImpl( Sql context ) {
        this.context = context;
        ref_Msg_ID = UniqueId.random();
        ref_Id = UniqueId.random();
        R1020_is_a_SynchronousMessage_inst = SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
        R1022_sends_InterfaceOperation_inst = InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
    }

    private InterfaceOperationMessageImpl( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, UniqueId ref_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Msg_ID = ref_Msg_ID;
        this.ref_Id = ref_Id;
        R1020_is_a_SynchronousMessage_inst = SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
        R1022_sends_InterfaceOperation_inst = InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
    }

    public static InterfaceOperationMessage create( Sql context ) throws XtumlException {
        InterfaceOperationMessage newInterfaceOperationMessage = new InterfaceOperationMessageImpl( context );
        if ( context.addInstance( newInterfaceOperationMessage ) ) {
            newInterfaceOperationMessage.getRunContext().addChange(new InstanceCreatedDelta(newInterfaceOperationMessage, KEY_LETTERS));
            return newInterfaceOperationMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InterfaceOperationMessage create( Sql context, UniqueId ref_Msg_ID, UniqueId ref_Id ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Msg_ID, ref_Id);
    }

    public static InterfaceOperationMessage create( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, UniqueId ref_Id ) throws XtumlException {
        InterfaceOperationMessage newInterfaceOperationMessage = new InterfaceOperationMessageImpl( context, instanceId, ref_Msg_ID, ref_Id );
        if ( context.addInstance( newInterfaceOperationMessage ) ) {
            return newInterfaceOperationMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Msg_ID;
    @Override
    public UniqueId getMsg_ID() throws XtumlException {
        checkLiving();
        return ref_Msg_ID;
    }
    @Override
    public void setMsg_ID(UniqueId ref_Msg_ID) throws XtumlException {
        checkLiving();
        if (ref_Msg_ID.inequality( this.ref_Msg_ID)) {
            final UniqueId oldValue = this.ref_Msg_ID;
            this.ref_Msg_ID = ref_Msg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Msg_ID", oldValue, this.ref_Msg_ID));
        }
    }
    private UniqueId ref_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getMsg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private SynchronousMessage R1020_is_a_SynchronousMessage_inst;
    @Override
    public void setR1020_is_a_SynchronousMessage( SynchronousMessage inst ) {
        R1020_is_a_SynchronousMessage_inst = inst;
    }
    @Override
    public SynchronousMessage R1020_is_a_SynchronousMessage() throws XtumlException {
        return R1020_is_a_SynchronousMessage_inst;
    }
    private InterfaceOperation R1022_sends_InterfaceOperation_inst;
    @Override
    public void setR1022_sends_InterfaceOperation( InterfaceOperation inst ) {
        R1022_sends_InterfaceOperation_inst = inst;
    }
    @Override
    public InterfaceOperation R1022_sends_InterfaceOperation() throws XtumlException {
        return R1022_sends_InterfaceOperation_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InterfaceOperationMessage self() {
        return this;
    }

    @Override
    public InterfaceOperationMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INTERFACEOPERATIONMESSAGE;
    }

}

class EmptyInterfaceOperationMessage extends ModelInstance<InterfaceOperationMessage,Sql> implements InterfaceOperationMessage {

    // attributes
    public UniqueId getMsg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setMsg_ID( UniqueId ref_Msg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public SynchronousMessage R1020_is_a_SynchronousMessage() {
        return SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }
    @Override
    public InterfaceOperation R1022_sends_InterfaceOperation() {
        return InterfaceOperationImpl.EMPTY_INTERFACEOPERATION;
    }


    @Override
    public String getKeyLetters() {
        return InterfaceOperationMessageImpl.KEY_LETTERS;
    }

    @Override
    public InterfaceOperationMessage self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InterfaceOperationMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InterfaceOperationMessageImpl.EMPTY_INTERFACEOPERATIONMESSAGE;
    }

}
