package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.FunctionParameter;
import io.ciera.tool.sql.ooaofooa.domain.impl.FunctionParameterImpl;
import io.ciera.tool.sql.ooaofooa.message.FunctionArgument;
import io.ciera.tool.sql.ooaofooa.message.MessageArgument;
import io.ciera.tool.sql.ooaofooa.message.impl.MessageArgumentImpl;


public class FunctionArgumentImpl extends ModelInstance<FunctionArgument,Sql> implements FunctionArgument {

    public static final String KEY_LETTERS = "MSG_FA";
    public static final FunctionArgument EMPTY_FUNCTIONARGUMENT = new EmptyFunctionArgument();

    private Sql context;

    // constructors
    private FunctionArgumentImpl( Sql context ) {
        this.context = context;
        ref_Arg_ID = UniqueId.random();
        ref_SParm_ID = UniqueId.random();
        R1013_is_a_MessageArgument_inst = MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
        R1016_is_represented_by_FunctionParameter_inst = FunctionParameterImpl.EMPTY_FUNCTIONPARAMETER;
    }

    private FunctionArgumentImpl( Sql context, UniqueId instanceId, UniqueId ref_Arg_ID, UniqueId ref_SParm_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Arg_ID = ref_Arg_ID;
        this.ref_SParm_ID = ref_SParm_ID;
        R1013_is_a_MessageArgument_inst = MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
        R1016_is_represented_by_FunctionParameter_inst = FunctionParameterImpl.EMPTY_FUNCTIONPARAMETER;
    }

    public static FunctionArgument create( Sql context ) throws XtumlException {
        FunctionArgument newFunctionArgument = new FunctionArgumentImpl( context );
        if ( context.addInstance( newFunctionArgument ) ) {
            newFunctionArgument.getRunContext().addChange(new InstanceCreatedDelta(newFunctionArgument, KEY_LETTERS));
            return newFunctionArgument;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static FunctionArgument create( Sql context, UniqueId ref_Arg_ID, UniqueId ref_SParm_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Arg_ID, ref_SParm_ID);
    }

    public static FunctionArgument create( Sql context, UniqueId instanceId, UniqueId ref_Arg_ID, UniqueId ref_SParm_ID ) throws XtumlException {
        FunctionArgument newFunctionArgument = new FunctionArgumentImpl( context, instanceId, ref_Arg_ID, ref_SParm_ID );
        if ( context.addInstance( newFunctionArgument ) ) {
            return newFunctionArgument;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Arg_ID;
    @Override
    public UniqueId getArg_ID() throws XtumlException {
        checkLiving();
        return ref_Arg_ID;
    }
    @Override
    public void setArg_ID(UniqueId ref_Arg_ID) throws XtumlException {
        checkLiving();
        if (ref_Arg_ID.inequality( this.ref_Arg_ID)) {
            final UniqueId oldValue = this.ref_Arg_ID;
            this.ref_Arg_ID = ref_Arg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Arg_ID", oldValue, this.ref_Arg_ID));
        }
    }
    private UniqueId ref_SParm_ID;
    @Override
    public UniqueId getSParm_ID() throws XtumlException {
        checkLiving();
        return ref_SParm_ID;
    }
    @Override
    public void setSParm_ID(UniqueId ref_SParm_ID) throws XtumlException {
        checkLiving();
        if (ref_SParm_ID.inequality( this.ref_SParm_ID)) {
            final UniqueId oldValue = this.ref_SParm_ID;
            this.ref_SParm_ID = ref_SParm_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SParm_ID", oldValue, this.ref_SParm_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getArg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private MessageArgument R1013_is_a_MessageArgument_inst;
    @Override
    public void setR1013_is_a_MessageArgument( MessageArgument inst ) {
        R1013_is_a_MessageArgument_inst = inst;
    }
    @Override
    public MessageArgument R1013_is_a_MessageArgument() throws XtumlException {
        return R1013_is_a_MessageArgument_inst;
    }
    private FunctionParameter R1016_is_represented_by_FunctionParameter_inst;
    @Override
    public void setR1016_is_represented_by_FunctionParameter( FunctionParameter inst ) {
        R1016_is_represented_by_FunctionParameter_inst = inst;
    }
    @Override
    public FunctionParameter R1016_is_represented_by_FunctionParameter() throws XtumlException {
        return R1016_is_represented_by_FunctionParameter_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public FunctionArgument self() {
        return this;
    }

    @Override
    public FunctionArgument oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_FUNCTIONARGUMENT;
    }

}

class EmptyFunctionArgument extends ModelInstance<FunctionArgument,Sql> implements FunctionArgument {

    // attributes
    public UniqueId getArg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setArg_ID( UniqueId ref_Arg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSParm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSParm_ID( UniqueId ref_SParm_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MessageArgument R1013_is_a_MessageArgument() {
        return MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
    }
    @Override
    public FunctionParameter R1016_is_represented_by_FunctionParameter() {
        return FunctionParameterImpl.EMPTY_FUNCTIONPARAMETER;
    }


    @Override
    public String getKeyLetters() {
        return FunctionArgumentImpl.KEY_LETTERS;
    }

    @Override
    public FunctionArgument self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public FunctionArgument oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return FunctionArgumentImpl.EMPTY_FUNCTIONARGUMENT;
    }

}
