package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.message.EventArgument;
import io.ciera.tool.sql.ooaofooa.message.MessageArgument;
import io.ciera.tool.sql.ooaofooa.message.impl.MessageArgumentImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEventDataItem;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventDataItemImpl;


public class EventArgumentImpl extends ModelInstance<EventArgument,Sql> implements EventArgument {

    public static final String KEY_LETTERS = "MSG_EA";
    public static final EventArgument EMPTY_EVENTARGUMENT = new EmptyEventArgument();

    private Sql context;

    // constructors
    private EventArgumentImpl( Sql context ) {
        this.context = context;
        ref_Arg_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        ref_SMedi_ID = UniqueId.random();
        R1013_is_a_MessageArgument_inst = MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
        R1017_is_represented_by_StateMachineEventDataItem_inst = StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
    }

    private EventArgumentImpl( Sql context, UniqueId instanceId, UniqueId ref_Arg_ID, UniqueId ref_SM_ID, UniqueId ref_SMedi_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Arg_ID = ref_Arg_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.ref_SMedi_ID = ref_SMedi_ID;
        R1013_is_a_MessageArgument_inst = MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
        R1017_is_represented_by_StateMachineEventDataItem_inst = StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
    }

    public static EventArgument create( Sql context ) throws XtumlException {
        EventArgument newEventArgument = new EventArgumentImpl( context );
        if ( context.addInstance( newEventArgument ) ) {
            newEventArgument.getRunContext().addChange(new InstanceCreatedDelta(newEventArgument, KEY_LETTERS));
            return newEventArgument;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static EventArgument create( Sql context, UniqueId ref_Arg_ID, UniqueId ref_SM_ID, UniqueId ref_SMedi_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Arg_ID, ref_SM_ID, ref_SMedi_ID);
    }

    public static EventArgument create( Sql context, UniqueId instanceId, UniqueId ref_Arg_ID, UniqueId ref_SM_ID, UniqueId ref_SMedi_ID ) throws XtumlException {
        EventArgument newEventArgument = new EventArgumentImpl( context, instanceId, ref_Arg_ID, ref_SM_ID, ref_SMedi_ID );
        if ( context.addInstance( newEventArgument ) ) {
            return newEventArgument;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Arg_ID;
    @Override
    public UniqueId getArg_ID() throws XtumlException {
        checkLiving();
        return ref_Arg_ID;
    }
    @Override
    public void setArg_ID(UniqueId ref_Arg_ID) throws XtumlException {
        checkLiving();
        if (ref_Arg_ID.inequality( this.ref_Arg_ID)) {
            final UniqueId oldValue = this.ref_Arg_ID;
            this.ref_Arg_ID = ref_Arg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Arg_ID", oldValue, this.ref_Arg_ID));
        }
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    private UniqueId ref_SMedi_ID;
    @Override
    public void setSMedi_ID(UniqueId ref_SMedi_ID) throws XtumlException {
        checkLiving();
        if (ref_SMedi_ID.inequality( this.ref_SMedi_ID)) {
            final UniqueId oldValue = this.ref_SMedi_ID;
            this.ref_SMedi_ID = ref_SMedi_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMedi_ID", oldValue, this.ref_SMedi_ID));
        }
    }
    @Override
    public UniqueId getSMedi_ID() throws XtumlException {
        checkLiving();
        return ref_SMedi_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getArg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private MessageArgument R1013_is_a_MessageArgument_inst;
    @Override
    public void setR1013_is_a_MessageArgument( MessageArgument inst ) {
        R1013_is_a_MessageArgument_inst = inst;
    }
    @Override
    public MessageArgument R1013_is_a_MessageArgument() throws XtumlException {
        return R1013_is_a_MessageArgument_inst;
    }
    private StateMachineEventDataItem R1017_is_represented_by_StateMachineEventDataItem_inst;
    @Override
    public void setR1017_is_represented_by_StateMachineEventDataItem( StateMachineEventDataItem inst ) {
        R1017_is_represented_by_StateMachineEventDataItem_inst = inst;
    }
    @Override
    public StateMachineEventDataItem R1017_is_represented_by_StateMachineEventDataItem() throws XtumlException {
        return R1017_is_represented_by_StateMachineEventDataItem_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public EventArgument self() {
        return this;
    }

    @Override
    public EventArgument oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_EVENTARGUMENT;
    }

}

class EmptyEventArgument extends ModelInstance<EventArgument,Sql> implements EventArgument {

    // attributes
    public UniqueId getArg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setArg_ID( UniqueId ref_Arg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMedi_ID( UniqueId ref_SMedi_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMedi_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MessageArgument R1013_is_a_MessageArgument() {
        return MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
    }
    @Override
    public StateMachineEventDataItem R1017_is_represented_by_StateMachineEventDataItem() {
        return StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
    }


    @Override
    public String getKeyLetters() {
        return EventArgumentImpl.KEY_LETTERS;
    }

    @Override
    public EventArgument self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public EventArgument oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return EventArgumentImpl.EMPTY_EVENTARGUMENT;
    }

}
