package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.Bridge;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeImpl;
import io.ciera.tool.sql.ooaofooa.message.BridgeMessage;
import io.ciera.tool.sql.ooaofooa.message.SynchronousMessage;
import io.ciera.tool.sql.ooaofooa.message.impl.SynchronousMessageImpl;


public class BridgeMessageImpl extends ModelInstance<BridgeMessage,Sql> implements BridgeMessage {

    public static final String KEY_LETTERS = "MSG_B";
    public static final BridgeMessage EMPTY_BRIDGEMESSAGE = new EmptyBridgeMessage();

    private Sql context;

    // constructors
    private BridgeMessageImpl( Sql context ) {
        this.context = context;
        ref_Msg_ID = UniqueId.random();
        ref_Brg_ID = UniqueId.random();
        R1012_is_invocation_of_Bridge_inst = BridgeImpl.EMPTY_BRIDGE;
        R1020_is_a_SynchronousMessage_inst = SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }

    private BridgeMessageImpl( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, UniqueId ref_Brg_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Msg_ID = ref_Msg_ID;
        this.ref_Brg_ID = ref_Brg_ID;
        R1012_is_invocation_of_Bridge_inst = BridgeImpl.EMPTY_BRIDGE;
        R1020_is_a_SynchronousMessage_inst = SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }

    public static BridgeMessage create( Sql context ) throws XtumlException {
        BridgeMessage newBridgeMessage = new BridgeMessageImpl( context );
        if ( context.addInstance( newBridgeMessage ) ) {
            newBridgeMessage.getRunContext().addChange(new InstanceCreatedDelta(newBridgeMessage, KEY_LETTERS));
            return newBridgeMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BridgeMessage create( Sql context, UniqueId ref_Msg_ID, UniqueId ref_Brg_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Msg_ID, ref_Brg_ID);
    }

    public static BridgeMessage create( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, UniqueId ref_Brg_ID ) throws XtumlException {
        BridgeMessage newBridgeMessage = new BridgeMessageImpl( context, instanceId, ref_Msg_ID, ref_Brg_ID );
        if ( context.addInstance( newBridgeMessage ) ) {
            return newBridgeMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Msg_ID;
    @Override
    public UniqueId getMsg_ID() throws XtumlException {
        checkLiving();
        return ref_Msg_ID;
    }
    @Override
    public void setMsg_ID(UniqueId ref_Msg_ID) throws XtumlException {
        checkLiving();
        if (ref_Msg_ID.inequality( this.ref_Msg_ID)) {
            final UniqueId oldValue = this.ref_Msg_ID;
            this.ref_Msg_ID = ref_Msg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Msg_ID", oldValue, this.ref_Msg_ID));
        }
    }
    private UniqueId ref_Brg_ID;
    @Override
    public UniqueId getBrg_ID() throws XtumlException {
        checkLiving();
        return ref_Brg_ID;
    }
    @Override
    public void setBrg_ID(UniqueId ref_Brg_ID) throws XtumlException {
        checkLiving();
        if (ref_Brg_ID.inequality( this.ref_Brg_ID)) {
            final UniqueId oldValue = this.ref_Brg_ID;
            this.ref_Brg_ID = ref_Brg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Brg_ID", oldValue, this.ref_Brg_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getMsg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Bridge R1012_is_invocation_of_Bridge_inst;
    @Override
    public void setR1012_is_invocation_of_Bridge( Bridge inst ) {
        R1012_is_invocation_of_Bridge_inst = inst;
    }
    @Override
    public Bridge R1012_is_invocation_of_Bridge() throws XtumlException {
        return R1012_is_invocation_of_Bridge_inst;
    }
    private SynchronousMessage R1020_is_a_SynchronousMessage_inst;
    @Override
    public void setR1020_is_a_SynchronousMessage( SynchronousMessage inst ) {
        R1020_is_a_SynchronousMessage_inst = inst;
    }
    @Override
    public SynchronousMessage R1020_is_a_SynchronousMessage() throws XtumlException {
        return R1020_is_a_SynchronousMessage_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BridgeMessage self() {
        return this;
    }

    @Override
    public BridgeMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BRIDGEMESSAGE;
    }

}

class EmptyBridgeMessage extends ModelInstance<BridgeMessage,Sql> implements BridgeMessage {

    // attributes
    public UniqueId getMsg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setMsg_ID( UniqueId ref_Msg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getBrg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBrg_ID( UniqueId ref_Brg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Bridge R1012_is_invocation_of_Bridge() {
        return BridgeImpl.EMPTY_BRIDGE;
    }
    @Override
    public SynchronousMessage R1020_is_a_SynchronousMessage() {
        return SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }


    @Override
    public String getKeyLetters() {
        return BridgeMessageImpl.KEY_LETTERS;
    }

    @Override
    public BridgeMessage self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BridgeMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BridgeMessageImpl.EMPTY_BRIDGEMESSAGE;
    }

}
