package io.ciera.tool.sql.ooaofooa.invocation.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.domain.S_SYNC;
import io.ciera.tool.sql.ooaofooa.domain.impl.S_SYNCImpl;
import io.ciera.tool.sql.ooaofooa.invocation.FunctionInvocation;
import io.ciera.tool.sql.ooaofooa.value.V_PAR;
import io.ciera.tool.sql.ooaofooa.value.V_PARSet;
import io.ciera.tool.sql.ooaofooa.value.impl.V_PARSetImpl;


public class FunctionInvocationImpl extends ModelInstance<FunctionInvocation,Sql> implements FunctionInvocation {

    public static final String KEY_LETTERS = "ACT_FNC";
    public static final FunctionInvocation EMPTY_FUNCTIONINVOCATION = new EmptyFunctionInvocation();

    private Sql context;

    // constructors
    private FunctionInvocationImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Sync_ID = UniqueId.random();
        m_functionNameLineNumber = 0;
        m_functionNameColumn = 0;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R669_takes_V_PAR_set = new V_PARSetImpl();
        R675_is_an_invocation_of_S_SYNC_inst = S_SYNCImpl.EMPTY_S_SYNC;
    }

    private FunctionInvocationImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Sync_ID, int m_functionNameLineNumber, int m_functionNameColumn ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Sync_ID = ref_Sync_ID;
        this.m_functionNameLineNumber = m_functionNameLineNumber;
        this.m_functionNameColumn = m_functionNameColumn;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R669_takes_V_PAR_set = new V_PARSetImpl();
        R675_is_an_invocation_of_S_SYNC_inst = S_SYNCImpl.EMPTY_S_SYNC;
    }

    public static FunctionInvocation create( Sql context ) throws XtumlException {
        FunctionInvocation newFunctionInvocation = new FunctionInvocationImpl( context );
        if ( context.addInstance( newFunctionInvocation ) ) {
            newFunctionInvocation.getRunContext().addChange(new InstanceCreatedDelta(newFunctionInvocation, KEY_LETTERS));
            return newFunctionInvocation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static FunctionInvocation create( Sql context, UniqueId ref_Statement_ID, UniqueId ref_Sync_ID, int m_functionNameLineNumber, int m_functionNameColumn ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Statement_ID, ref_Sync_ID, m_functionNameLineNumber, m_functionNameColumn);
    }

    public static FunctionInvocation create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Sync_ID, int m_functionNameLineNumber, int m_functionNameColumn ) throws XtumlException {
        FunctionInvocation newFunctionInvocation = new FunctionInvocationImpl( context, instanceId, ref_Statement_ID, ref_Sync_ID, m_functionNameLineNumber, m_functionNameColumn );
        if ( context.addInstance( newFunctionInvocation ) ) {
            return newFunctionInvocation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R669_takes_V_PAR().isEmpty() ) R669_takes_V_PAR().setStatement_ID( ref_Statement_ID );
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    private UniqueId ref_Sync_ID;
    @Override
    public void setSync_ID(UniqueId ref_Sync_ID) throws XtumlException {
        checkLiving();
        if (ref_Sync_ID.inequality( this.ref_Sync_ID)) {
            final UniqueId oldValue = this.ref_Sync_ID;
            this.ref_Sync_ID = ref_Sync_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Sync_ID", oldValue, this.ref_Sync_ID));
        }
    }
    @Override
    public UniqueId getSync_ID() throws XtumlException {
        checkLiving();
        return ref_Sync_ID;
    }
    private int m_functionNameLineNumber;
    @Override
    public int getFunctionNameLineNumber() throws XtumlException {
        checkLiving();
        return m_functionNameLineNumber;
    }
    @Override
    public void setFunctionNameLineNumber(int m_functionNameLineNumber) throws XtumlException {
        checkLiving();
        if (m_functionNameLineNumber != this.m_functionNameLineNumber) {
            final int oldValue = this.m_functionNameLineNumber;
            this.m_functionNameLineNumber = m_functionNameLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_functionNameLineNumber", oldValue, this.m_functionNameLineNumber));
        }
    }
    private int m_functionNameColumn;
    @Override
    public int getFunctionNameColumn() throws XtumlException {
        checkLiving();
        return m_functionNameColumn;
    }
    @Override
    public void setFunctionNameColumn(int m_functionNameColumn) throws XtumlException {
        checkLiving();
        if (m_functionNameColumn != this.m_functionNameColumn) {
            final int oldValue = this.m_functionNameColumn;
            this.m_functionNameColumn = m_functionNameColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_functionNameColumn", oldValue, this.m_functionNameColumn));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private V_PARSet R669_takes_V_PAR_set;
    @Override
    public void addR669_takes_V_PAR( V_PAR inst ) {
        R669_takes_V_PAR_set.add(inst);
    }
    @Override
    public void removeR669_takes_V_PAR( V_PAR inst ) {
        R669_takes_V_PAR_set.remove(inst);
    }
    @Override
    public V_PARSet R669_takes_V_PAR() throws XtumlException {
        return R669_takes_V_PAR_set;
    }
    private S_SYNC R675_is_an_invocation_of_S_SYNC_inst;
    @Override
    public void setR675_is_an_invocation_of_S_SYNC( S_SYNC inst ) {
        R675_is_an_invocation_of_S_SYNC_inst = inst;
    }
    @Override
    public S_SYNC R675_is_an_invocation_of_S_SYNC() throws XtumlException {
        return R675_is_an_invocation_of_S_SYNC_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public FunctionInvocation self() {
        return this;
    }

    @Override
    public FunctionInvocation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_FUNCTIONINVOCATION;
    }

}

class EmptyFunctionInvocation extends ModelInstance<FunctionInvocation,Sql> implements FunctionInvocation {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSync_ID( UniqueId ref_Sync_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSync_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getFunctionNameLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFunctionNameLineNumber( int m_functionNameLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getFunctionNameColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFunctionNameColumn( int m_functionNameColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public V_PARSet R669_takes_V_PAR() {
        return (new V_PARSetImpl());
    }
    @Override
    public S_SYNC R675_is_an_invocation_of_S_SYNC() {
        return S_SYNCImpl.EMPTY_S_SYNC;
    }


    @Override
    public String getKeyLetters() {
        return FunctionInvocationImpl.KEY_LETTERS;
    }

    @Override
    public FunctionInvocation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public FunctionInvocation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return FunctionInvocationImpl.EMPTY_FUNCTIONINVOCATION;
    }

}
