package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.PropertyParameter;
import io.ciera.tool.sql.ooaofooa.component.impl.PropertyParameterImpl;
import io.ciera.tool.sql.ooaofooa.instance.DataItemValue;
import io.ciera.tool.sql.ooaofooa.instance.PendingEvent;
import io.ciera.tool.sql.ooaofooa.instance.impl.PendingEventImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEventDataItem;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventDataItemImpl;


public class DataItemValueImpl extends ModelInstance<DataItemValue,Sql> implements DataItemValue {

    public static final String KEY_LETTERS = "I_DIV";
    public static final DataItemValue EMPTY_DATAITEMVALUE = new EmptyDataItemValue();

    private Sql context;

    // constructors
    private DataItemValueImpl( Sql context ) {
        this.context = context;
        m_DIV_ID = UniqueId.random();
        ref_Event_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        ref_SMedi_ID = UniqueId.random();
        m_RuntimeValue_ID = UniqueId.random();
        ref_PP_Id = UniqueId.random();
        R2933_PendingEvent_inst = PendingEventImpl.EMPTY_PENDINGEVENT;
        R2934_StateMachineEventDataItem_inst = StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
        R2956_PropertyParameter_inst = PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }

    private DataItemValueImpl( Sql context, UniqueId instanceId, UniqueId m_DIV_ID, UniqueId ref_Event_ID, UniqueId ref_SM_ID, UniqueId ref_SMedi_ID, UniqueId m_RuntimeValue_ID, UniqueId ref_PP_Id ) {
        super(instanceId);
        this.context = context;
        this.m_DIV_ID = m_DIV_ID;
        this.ref_Event_ID = ref_Event_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.ref_SMedi_ID = ref_SMedi_ID;
        this.m_RuntimeValue_ID = m_RuntimeValue_ID;
        this.ref_PP_Id = ref_PP_Id;
        R2933_PendingEvent_inst = PendingEventImpl.EMPTY_PENDINGEVENT;
        R2934_StateMachineEventDataItem_inst = StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
        R2956_PropertyParameter_inst = PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }

    public static DataItemValue create( Sql context ) throws XtumlException {
        DataItemValue newDataItemValue = new DataItemValueImpl( context );
        if ( context.addInstance( newDataItemValue ) ) {
            newDataItemValue.getRunContext().addChange(new InstanceCreatedDelta(newDataItemValue, KEY_LETTERS));
            return newDataItemValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static DataItemValue create( Sql context, UniqueId m_DIV_ID, UniqueId ref_Event_ID, UniqueId ref_SM_ID, UniqueId ref_SMedi_ID, UniqueId m_RuntimeValue_ID, UniqueId ref_PP_Id ) throws XtumlException {
        return create(context, UniqueId.random(), m_DIV_ID, ref_Event_ID, ref_SM_ID, ref_SMedi_ID, m_RuntimeValue_ID, ref_PP_Id);
    }

    public static DataItemValue create( Sql context, UniqueId instanceId, UniqueId m_DIV_ID, UniqueId ref_Event_ID, UniqueId ref_SM_ID, UniqueId ref_SMedi_ID, UniqueId m_RuntimeValue_ID, UniqueId ref_PP_Id ) throws XtumlException {
        DataItemValue newDataItemValue = new DataItemValueImpl( context, instanceId, m_DIV_ID, ref_Event_ID, ref_SM_ID, ref_SMedi_ID, m_RuntimeValue_ID, ref_PP_Id );
        if ( context.addInstance( newDataItemValue ) ) {
            return newDataItemValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_DIV_ID;
    @Override
    public void setDIV_ID(UniqueId m_DIV_ID) throws XtumlException {
        checkLiving();
        if (m_DIV_ID.inequality( this.m_DIV_ID)) {
            final UniqueId oldValue = this.m_DIV_ID;
            this.m_DIV_ID = m_DIV_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_DIV_ID", oldValue, this.m_DIV_ID));
        }
    }
    @Override
    public UniqueId getDIV_ID() throws XtumlException {
        checkLiving();
        return m_DIV_ID;
    }
    private UniqueId ref_Event_ID;
    @Override
    public void setEvent_ID(UniqueId ref_Event_ID) throws XtumlException {
        checkLiving();
        if (ref_Event_ID.inequality( this.ref_Event_ID)) {
            final UniqueId oldValue = this.ref_Event_ID;
            this.ref_Event_ID = ref_Event_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Event_ID", oldValue, this.ref_Event_ID));
        }
    }
    @Override
    public UniqueId getEvent_ID() throws XtumlException {
        checkLiving();
        return ref_Event_ID;
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    private UniqueId ref_SMedi_ID;
    @Override
    public void setSMedi_ID(UniqueId ref_SMedi_ID) throws XtumlException {
        checkLiving();
        if (ref_SMedi_ID.inequality( this.ref_SMedi_ID)) {
            final UniqueId oldValue = this.ref_SMedi_ID;
            this.ref_SMedi_ID = ref_SMedi_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMedi_ID", oldValue, this.ref_SMedi_ID));
        }
    }
    @Override
    public UniqueId getSMedi_ID() throws XtumlException {
        checkLiving();
        return ref_SMedi_ID;
    }
    private UniqueId m_RuntimeValue_ID;
    @Override
    public void setRuntimeValue_ID(UniqueId m_RuntimeValue_ID) throws XtumlException {
        checkLiving();
        if (m_RuntimeValue_ID.inequality( this.m_RuntimeValue_ID)) {
            final UniqueId oldValue = this.m_RuntimeValue_ID;
            this.m_RuntimeValue_ID = m_RuntimeValue_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_RuntimeValue_ID", oldValue, this.m_RuntimeValue_ID));
        }
    }
    @Override
    public UniqueId getRuntimeValue_ID() throws XtumlException {
        checkLiving();
        return m_RuntimeValue_ID;
    }
    private UniqueId ref_PP_Id;
    @Override
    public void setPP_Id(UniqueId ref_PP_Id) throws XtumlException {
        checkLiving();
        if (ref_PP_Id.inequality( this.ref_PP_Id)) {
            final UniqueId oldValue = this.ref_PP_Id;
            this.ref_PP_Id = ref_PP_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_PP_Id", oldValue, this.ref_PP_Id));
        }
    }
    @Override
    public UniqueId getPP_Id() throws XtumlException {
        checkLiving();
        return ref_PP_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getDIV_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private PendingEvent R2933_PendingEvent_inst;
    @Override
    public void setR2933_PendingEvent( PendingEvent inst ) {
        R2933_PendingEvent_inst = inst;
    }
    @Override
    public PendingEvent R2933_PendingEvent() throws XtumlException {
        return R2933_PendingEvent_inst;
    }
    private StateMachineEventDataItem R2934_StateMachineEventDataItem_inst;
    @Override
    public void setR2934_StateMachineEventDataItem( StateMachineEventDataItem inst ) {
        R2934_StateMachineEventDataItem_inst = inst;
    }
    @Override
    public StateMachineEventDataItem R2934_StateMachineEventDataItem() throws XtumlException {
        return R2934_StateMachineEventDataItem_inst;
    }
    private PropertyParameter R2956_PropertyParameter_inst;
    @Override
    public void setR2956_PropertyParameter( PropertyParameter inst ) {
        R2956_PropertyParameter_inst = inst;
    }
    @Override
    public PropertyParameter R2956_PropertyParameter() throws XtumlException {
        return R2956_PropertyParameter_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public DataItemValue self() {
        return this;
    }

    @Override
    public DataItemValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_DATAITEMVALUE;
    }

}

class EmptyDataItemValue extends ModelInstance<DataItemValue,Sql> implements DataItemValue {

    // attributes
    public void setDIV_ID( UniqueId m_DIV_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDIV_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEvent_ID( UniqueId ref_Event_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getEvent_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMedi_ID( UniqueId ref_SMedi_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMedi_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRuntimeValue_ID( UniqueId m_RuntimeValue_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRuntimeValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPP_Id( UniqueId ref_PP_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPP_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public PendingEvent R2933_PendingEvent() {
        return PendingEventImpl.EMPTY_PENDINGEVENT;
    }
    @Override
    public StateMachineEventDataItem R2934_StateMachineEventDataItem() {
        return StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
    }
    @Override
    public PropertyParameter R2956_PropertyParameter() {
        return PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }


    @Override
    public String getKeyLetters() {
        return DataItemValueImpl.KEY_LETTERS;
    }

    @Override
    public DataItemValue self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public DataItemValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return DataItemValueImpl.EMPTY_DATAITEMVALUE;
    }

}
