package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.domain.SystemModel;
import io.ciera.tool.sql.ooaofooa.domain.SystemModelSet;
import io.ciera.tool.sql.ooaofooa.elementpackaging.EP_PKGSet;
import io.ciera.tool.sql.ooaofooa.elementpackaging.impl.EP_PKGSetImpl;
import io.ciera.tool.sql.ooaofooa.globals.GlobalElementInSystemSet;
import io.ciera.tool.sql.ooaofooa.globals.impl.GlobalElementInSystemSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class SystemModelSetImpl extends InstanceSet<SystemModelSet,SystemModel> implements SystemModelSet {

    public SystemModelSetImpl() {
    }

    public SystemModelSetImpl(Comparator<? super SystemModel> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( SystemModel systemmodel : this ) systemmodel.setName( m_Name );
    }
    @Override
    public void setUseGlobals( boolean m_useGlobals ) throws XtumlException {
        for ( SystemModel systemmodel : this ) systemmodel.setUseGlobals( m_useGlobals );
    }
    @Override
    public void setSys_ID( UniqueId m_Sys_ID ) throws XtumlException {
        for ( SystemModel systemmodel : this ) systemmodel.setSys_ID( m_Sys_ID );
    }


    // selections
    @Override
    public EP_PKGSet R1401_contains_EP_PKG() throws XtumlException {
        EP_PKGSet ep_pkgset = new EP_PKGSetImpl();
        for ( SystemModel systemmodel : this ) ep_pkgset.addAll( systemmodel.R1401_contains_EP_PKG() );
        return ep_pkgset;
    }
    @Override
    public EP_PKGSet R1405_contains_EP_PKG() throws XtumlException {
        EP_PKGSet ep_pkgset = new EP_PKGSetImpl();
        for ( SystemModel systemmodel : this ) ep_pkgset.addAll( systemmodel.R1405_contains_EP_PKG() );
        return ep_pkgset;
    }
    @Override
    public GlobalElementInSystemSet R9100_GlobalElementInSystem() throws XtumlException {
        GlobalElementInSystemSet globalelementinsystemset = new GlobalElementInSystemSetImpl();
        for ( SystemModel systemmodel : this ) globalelementinsystemset.addAll( systemmodel.R9100_GlobalElementInSystem() );
        return globalelementinsystemset;
    }


    @Override
    public SystemModel nullElement() {
        return SystemModelImpl.EMPTY_SYSTEMMODEL;
    }

    @Override
    public SystemModelSet emptySet() {
      return new SystemModelSetImpl();
    }

    @Override
    public SystemModelSet emptySet(Comparator<? super SystemModel> comp) {
      return new SystemModelSetImpl(comp);
    }

    @Override
    public List<SystemModel> elements() {
        SystemModel[] elements = toArray(new SystemModel[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
