package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.SystemModel;
import io.ciera.tool.sql.ooaofooa.elementpackaging.EP_PKG;
import io.ciera.tool.sql.ooaofooa.elementpackaging.EP_PKGSet;
import io.ciera.tool.sql.ooaofooa.elementpackaging.impl.EP_PKGSetImpl;
import io.ciera.tool.sql.ooaofooa.globals.GlobalElementInSystem;
import io.ciera.tool.sql.ooaofooa.globals.GlobalElementInSystemSet;
import io.ciera.tool.sql.ooaofooa.globals.impl.GlobalElementInSystemSetImpl;


public class SystemModelImpl extends ModelInstance<SystemModel,Sql> implements SystemModel {

    public static final String KEY_LETTERS = "S_SYS";
    public static final SystemModel EMPTY_SYSTEMMODEL = new EmptySystemModel();

    private Sql context;

    // constructors
    private SystemModelImpl( Sql context ) {
        this.context = context;
        m_Sys_ID = UniqueId.random();
        m_Name = "";
        m_useGlobals = false;
        R1401_contains_EP_PKG_set = new EP_PKGSetImpl();
        R1405_contains_EP_PKG_set = new EP_PKGSetImpl();
        R9100_GlobalElementInSystem_set = new GlobalElementInSystemSetImpl();
    }

    private SystemModelImpl( Sql context, UniqueId instanceId, UniqueId m_Sys_ID, String m_Name, boolean m_useGlobals ) {
        super(instanceId);
        this.context = context;
        this.m_Sys_ID = m_Sys_ID;
        this.m_Name = m_Name;
        this.m_useGlobals = m_useGlobals;
        R1401_contains_EP_PKG_set = new EP_PKGSetImpl();
        R1405_contains_EP_PKG_set = new EP_PKGSetImpl();
        R9100_GlobalElementInSystem_set = new GlobalElementInSystemSetImpl();
    }

    public static SystemModel create( Sql context ) throws XtumlException {
        SystemModel newSystemModel = new SystemModelImpl( context );
        if ( context.addInstance( newSystemModel ) ) {
            newSystemModel.getRunContext().addChange(new InstanceCreatedDelta(newSystemModel, KEY_LETTERS));
            return newSystemModel;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SystemModel create( Sql context, UniqueId m_Sys_ID, String m_Name, boolean m_useGlobals ) throws XtumlException {
        return create(context, UniqueId.random(), m_Sys_ID, m_Name, m_useGlobals);
    }

    public static SystemModel create( Sql context, UniqueId instanceId, UniqueId m_Sys_ID, String m_Name, boolean m_useGlobals ) throws XtumlException {
        SystemModel newSystemModel = new SystemModelImpl( context, instanceId, m_Sys_ID, m_Name, m_useGlobals );
        if ( context.addInstance( newSystemModel ) ) {
            return newSystemModel;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Sys_ID;
    @Override
    public UniqueId getSys_ID() throws XtumlException {
        checkLiving();
        return m_Sys_ID;
    }
    @Override
    public void setSys_ID(UniqueId m_Sys_ID) throws XtumlException {
        checkLiving();
        if (m_Sys_ID.inequality( this.m_Sys_ID)) {
            final UniqueId oldValue = this.m_Sys_ID;
            this.m_Sys_ID = m_Sys_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Sys_ID", oldValue, this.m_Sys_ID));
            if ( !R1401_contains_EP_PKG().isEmpty() ) R1401_contains_EP_PKG().setSys_ID( m_Sys_ID );
            if ( !R9100_GlobalElementInSystem().isEmpty() ) R9100_GlobalElementInSystem().setSys_ID( m_Sys_ID );
            if ( !R1405_contains_EP_PKG().isEmpty() ) R1405_contains_EP_PKG().setDirect_Sys_ID( m_Sys_ID );
        }
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private boolean m_useGlobals;
    @Override
    public void setUseGlobals(boolean m_useGlobals) throws XtumlException {
        checkLiving();
        if (m_useGlobals != this.m_useGlobals) {
            final boolean oldValue = this.m_useGlobals;
            this.m_useGlobals = m_useGlobals;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_useGlobals", oldValue, this.m_useGlobals));
        }
    }
    @Override
    public boolean getUseGlobals() throws XtumlException {
        checkLiving();
        return m_useGlobals;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSys_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private EP_PKGSet R1401_contains_EP_PKG_set;
    @Override
    public void addR1401_contains_EP_PKG( EP_PKG inst ) {
        R1401_contains_EP_PKG_set.add(inst);
    }
    @Override
    public void removeR1401_contains_EP_PKG( EP_PKG inst ) {
        R1401_contains_EP_PKG_set.remove(inst);
    }
    @Override
    public EP_PKGSet R1401_contains_EP_PKG() throws XtumlException {
        return R1401_contains_EP_PKG_set;
    }
    private EP_PKGSet R1405_contains_EP_PKG_set;
    @Override
    public void addR1405_contains_EP_PKG( EP_PKG inst ) {
        R1405_contains_EP_PKG_set.add(inst);
    }
    @Override
    public void removeR1405_contains_EP_PKG( EP_PKG inst ) {
        R1405_contains_EP_PKG_set.remove(inst);
    }
    @Override
    public EP_PKGSet R1405_contains_EP_PKG() throws XtumlException {
        return R1405_contains_EP_PKG_set;
    }
    private GlobalElementInSystemSet R9100_GlobalElementInSystem_set;
    @Override
    public void addR9100_GlobalElementInSystem( GlobalElementInSystem inst ) {
        R9100_GlobalElementInSystem_set.add(inst);
    }
    @Override
    public void removeR9100_GlobalElementInSystem( GlobalElementInSystem inst ) {
        R9100_GlobalElementInSystem_set.remove(inst);
    }
    @Override
    public GlobalElementInSystemSet R9100_GlobalElementInSystem() throws XtumlException {
        return R9100_GlobalElementInSystem_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SystemModel self() {
        return this;
    }

    @Override
    public SystemModel oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SYSTEMMODEL;
    }

}

class EmptySystemModel extends ModelInstance<SystemModel,Sql> implements SystemModel {

    // attributes
    public UniqueId getSys_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSys_ID( UniqueId m_Sys_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setUseGlobals( boolean m_useGlobals ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getUseGlobals() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public EP_PKGSet R1401_contains_EP_PKG() {
        return (new EP_PKGSetImpl());
    }
    @Override
    public EP_PKGSet R1405_contains_EP_PKG() {
        return (new EP_PKGSetImpl());
    }
    @Override
    public GlobalElementInSystemSet R9100_GlobalElementInSystem() {
        return (new GlobalElementInSystemSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return SystemModelImpl.KEY_LETTERS;
    }

    @Override
    public SystemModel self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SystemModel oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SystemModelImpl.EMPTY_SYSTEMMODEL;
    }

}
