package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.InstanceReferenceDataType;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;


public class InstanceReferenceDataTypeImpl extends ModelInstance<InstanceReferenceDataType,Sql> implements InstanceReferenceDataType {

    public static final String KEY_LETTERS = "S_IRDT";
    public static final InstanceReferenceDataType EMPTY_INSTANCEREFERENCEDATATYPE = new EmptyInstanceReferenceDataType();

    private Sql context;

    // constructors
    private InstanceReferenceDataTypeImpl( Sql context ) {
        this.context = context;
        ref_DT_ID = UniqueId.random();
        m_isSet = false;
        ref_Obj_ID = UniqueId.random();
        R123_provides_reference_datatype_for_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
        R17_is_a_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
    }

    private InstanceReferenceDataTypeImpl( Sql context, UniqueId instanceId, UniqueId ref_DT_ID, boolean m_isSet, UniqueId ref_Obj_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_DT_ID = ref_DT_ID;
        this.m_isSet = m_isSet;
        this.ref_Obj_ID = ref_Obj_ID;
        R123_provides_reference_datatype_for_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
        R17_is_a_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
    }

    public static InstanceReferenceDataType create( Sql context ) throws XtumlException {
        InstanceReferenceDataType newInstanceReferenceDataType = new InstanceReferenceDataTypeImpl( context );
        if ( context.addInstance( newInstanceReferenceDataType ) ) {
            newInstanceReferenceDataType.getRunContext().addChange(new InstanceCreatedDelta(newInstanceReferenceDataType, KEY_LETTERS));
            return newInstanceReferenceDataType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InstanceReferenceDataType create( Sql context, UniqueId ref_DT_ID, boolean m_isSet, UniqueId ref_Obj_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_DT_ID, m_isSet, ref_Obj_ID);
    }

    public static InstanceReferenceDataType create( Sql context, UniqueId instanceId, UniqueId ref_DT_ID, boolean m_isSet, UniqueId ref_Obj_ID ) throws XtumlException {
        InstanceReferenceDataType newInstanceReferenceDataType = new InstanceReferenceDataTypeImpl( context, instanceId, ref_DT_ID, m_isSet, ref_Obj_ID );
        if ( context.addInstance( newInstanceReferenceDataType ) ) {
            return newInstanceReferenceDataType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_DT_ID;
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    private boolean m_isSet;
    @Override
    public void setIsSet(boolean m_isSet) throws XtumlException {
        checkLiving();
        if (m_isSet != this.m_isSet) {
            final boolean oldValue = this.m_isSet;
            this.m_isSet = m_isSet;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_isSet", oldValue, this.m_isSet));
        }
    }
    @Override
    public boolean getIsSet() throws XtumlException {
        checkLiving();
        return m_isSet;
    }
    private UniqueId ref_Obj_ID;
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getDT_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ModelClass R123_provides_reference_datatype_for_ModelClass_inst;
    @Override
    public void setR123_provides_reference_datatype_for_ModelClass( ModelClass inst ) {
        R123_provides_reference_datatype_for_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R123_provides_reference_datatype_for_ModelClass() throws XtumlException {
        return R123_provides_reference_datatype_for_ModelClass_inst;
    }
    private DataType R17_is_a_DataType_inst;
    @Override
    public void setR17_is_a_DataType( DataType inst ) {
        R17_is_a_DataType_inst = inst;
    }
    @Override
    public DataType R17_is_a_DataType() throws XtumlException {
        return R17_is_a_DataType_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InstanceReferenceDataType self() {
        return this;
    }

    @Override
    public InstanceReferenceDataType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INSTANCEREFERENCEDATATYPE;
    }

}

class EmptyInstanceReferenceDataType extends ModelInstance<InstanceReferenceDataType,Sql> implements InstanceReferenceDataType {

    // attributes
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIsSet( boolean m_isSet ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIsSet() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ModelClass R123_provides_reference_datatype_for_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }
    @Override
    public DataType R17_is_a_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }


    @Override
    public String getKeyLetters() {
        return InstanceReferenceDataTypeImpl.KEY_LETTERS;
    }

    @Override
    public InstanceReferenceDataType self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InstanceReferenceDataType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InstanceReferenceDataTypeImpl.EMPTY_INSTANCEREFERENCEDATATYPE;
    }

}
