package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.architecture.component.UtilityFunctionSet;
import io.ciera.tool.sql.architecture.component.impl.UtilityFunctionSetImpl;
import io.ciera.tool.sql.ooaofooa.body.BridgeBodySet;
import io.ciera.tool.sql.ooaofooa.body.impl.BridgeBodySetImpl;
import io.ciera.tool.sql.ooaofooa.domain.Bridge;
import io.ciera.tool.sql.ooaofooa.domain.BridgeParameterSet;
import io.ciera.tool.sql.ooaofooa.domain.BridgeSet;
import io.ciera.tool.sql.ooaofooa.domain.DataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.ExternalEntitySet;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeParameterSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.ExternalEntitySetImpl;
import io.ciera.tool.sql.ooaofooa.invocation.BridgeInvocationSet;
import io.ciera.tool.sql.ooaofooa.invocation.impl.BridgeInvocationSetImpl;
import io.ciera.tool.sql.ooaofooa.message.BridgeMessageSet;
import io.ciera.tool.sql.ooaofooa.message.impl.BridgeMessageSetImpl;
import io.ciera.tool.sql.ooaofooa.value.BridgeValueSet;
import io.ciera.tool.sql.ooaofooa.value.impl.BridgeValueSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import ooaofooa.datatypes.ActionDialect;
import ooaofooa.datatypes.ParseStatus;


public class BridgeSetImpl extends InstanceSet<BridgeSet,Bridge> implements BridgeSet {

    public BridgeSetImpl() {
    }

    public BridgeSetImpl(Comparator<? super Bridge> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        for ( Bridge bridge : this ) bridge.setDT_ID( ref_DT_ID );
    }
    @Override
    public void setBrg_ID( UniqueId m_Brg_ID ) throws XtumlException {
        for ( Bridge bridge : this ) bridge.setBrg_ID( m_Brg_ID );
    }
    @Override
    public void setReturn_Dimensions( String m_Return_Dimensions ) throws XtumlException {
        for ( Bridge bridge : this ) bridge.setReturn_Dimensions( m_Return_Dimensions );
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( Bridge bridge : this ) bridge.setName( m_Name );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( Bridge bridge : this ) bridge.setDescrip( m_Descrip );
    }
    @Override
    public void setSuc_Pars( ParseStatus m_Suc_Pars ) throws XtumlException {
        for ( Bridge bridge : this ) bridge.setSuc_Pars( m_Suc_Pars );
    }
    @Override
    public void setAction_Semantics( String m_Action_Semantics ) throws XtumlException {
        for ( Bridge bridge : this ) bridge.setAction_Semantics( m_Action_Semantics );
    }
    @Override
    public void setAction_Semantics_internal( String m_Action_Semantics_internal ) throws XtumlException {
        for ( Bridge bridge : this ) bridge.setAction_Semantics_internal( m_Action_Semantics_internal );
    }
    @Override
    public void setDialect( ActionDialect m_Dialect ) throws XtumlException {
        for ( Bridge bridge : this ) bridge.setDialect( m_Dialect );
    }
    @Override
    public void setBrg_Typ( int m_Brg_Typ ) throws XtumlException {
        for ( Bridge bridge : this ) bridge.setBrg_Typ( m_Brg_Typ );
    }
    @Override
    public void setEE_ID( UniqueId ref_EE_ID ) throws XtumlException {
        for ( Bridge bridge : this ) bridge.setEE_ID( ref_EE_ID );
    }


    // selections
    @Override
    public BridgeMessageSet R1012_is_invoked_by_BridgeMessage() throws XtumlException {
        BridgeMessageSet bridgemessageset = new BridgeMessageSetImpl();
        for ( Bridge bridge : this ) bridgemessageset.addAll( bridge.R1012_is_invoked_by_BridgeMessage() );
        return bridgemessageset;
    }
    @Override
    public ExternalEntitySet R19_provides_access_to_ExternalEntity() throws XtumlException {
        ExternalEntitySet externalentityset = new ExternalEntitySetImpl();
        for ( Bridge bridge : this ) externalentityset.add( bridge.R19_provides_access_to_ExternalEntity() );
        return externalentityset;
    }
    @Override
    public DataTypeSet R20_return_value_defined_by_DataType() throws XtumlException {
        DataTypeSet datatypeset = new DataTypeSetImpl();
        for ( Bridge bridge : this ) datatypeset.add( bridge.R20_return_value_defined_by_DataType() );
        return datatypeset;
    }
    @Override
    public BridgeParameterSet R21_is_part_of_BridgeParameter() throws XtumlException {
        BridgeParameterSet bridgeparameterset = new BridgeParameterSetImpl();
        for ( Bridge bridge : this ) bridgeparameterset.addAll( bridge.R21_is_part_of_BridgeParameter() );
        return bridgeparameterset;
    }
    @Override
    public UtilityFunctionSet R4570_UtilityFunction() throws XtumlException {
        UtilityFunctionSet utilityfunctionset = new UtilityFunctionSetImpl();
        for ( Bridge bridge : this ) utilityfunctionset.add( bridge.R4570_UtilityFunction() );
        return utilityfunctionset;
    }
    @Override
    public DimensionsSet R50_return_value_may_have_Dimensions() throws XtumlException {
        DimensionsSet dimensionsset = new DimensionsSetImpl();
        for ( Bridge bridge : this ) dimensionsset.addAll( bridge.R50_return_value_may_have_Dimensions() );
        return dimensionsset;
    }
    @Override
    public BridgeInvocationSet R674_BridgeInvocation() throws XtumlException {
        BridgeInvocationSet bridgeinvocationset = new BridgeInvocationSetImpl();
        for ( Bridge bridge : this ) bridgeinvocationset.addAll( bridge.R674_BridgeInvocation() );
        return bridgeinvocationset;
    }
    @Override
    public BridgeBodySet R697_BridgeBody() throws XtumlException {
        BridgeBodySet bridgebodyset = new BridgeBodySetImpl();
        for ( Bridge bridge : this ) bridgebodyset.add( bridge.R697_BridgeBody() );
        return bridgebodyset;
    }
    @Override
    public BridgeValueSet R828_BridgeValue() throws XtumlException {
        BridgeValueSet bridgevalueset = new BridgeValueSetImpl();
        for ( Bridge bridge : this ) bridgevalueset.addAll( bridge.R828_BridgeValue() );
        return bridgevalueset;
    }


    @Override
    public Bridge nullElement() {
        return BridgeImpl.EMPTY_BRIDGE;
    }

    @Override
    public BridgeSet emptySet() {
      return new BridgeSetImpl();
    }

    @Override
    public BridgeSet emptySet(Comparator<? super Bridge> comp) {
      return new BridgeSetImpl(comp);
    }

    @Override
    public List<Bridge> elements() {
        Bridge[] elements = toArray(new Bridge[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
