package io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.RequiredOperationBody;
import io.ciera.tool.sql.ooaofooa.body.impl.RequiredOperationBodyImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredExecutableProperty;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredOperation;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.RequiredExecutablePropertyImpl;
import io.ciera.tool.sql.ooaofooa.invocation.InterfaceOperationInvocation;
import io.ciera.tool.sql.ooaofooa.invocation.InterfaceOperationInvocationSet;
import io.ciera.tool.sql.ooaofooa.invocation.impl.InterfaceOperationInvocationSetImpl;

import ooaofooa.datatypes.ActionDialect;
import ooaofooa.datatypes.ParseStatus;


public class RequiredOperationImpl extends ModelInstance<RequiredOperation,Sql> implements RequiredOperation {

    public static final String KEY_LETTERS = "SPR_RO";
    public static final RequiredOperation EMPTY_REQUIREDOPERATION = new EmptyRequiredOperation();

    private Sql context;

    // constructors
    private RequiredOperationImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_Action_Semantics = "";
        m_Action_Semantics_internal = "";
        m_Suc_Pars = ParseStatus.UNINITIALIZED_ENUM;
        m_Dialect = ActionDialect.UNINITIALIZED_ENUM;
        m_Numb = 0;
        R4502_is_a_RequiredExecutableProperty_inst = RequiredExecutablePropertyImpl.EMPTY_REQUIREDEXECUTABLEPROPERTY;
        R657_InterfaceOperationInvocation_set = new InterfaceOperationInvocationSetImpl();
        R685_RequiredOperationBody_inst = RequiredOperationBodyImpl.EMPTY_REQUIREDOPERATIONBODY;
    }

    private RequiredOperationImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip, String m_Action_Semantics, String m_Action_Semantics_internal, ParseStatus m_Suc_Pars, ActionDialect m_Dialect, int m_Numb ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_Action_Semantics = m_Action_Semantics;
        this.m_Action_Semantics_internal = m_Action_Semantics_internal;
        this.m_Suc_Pars = m_Suc_Pars;
        this.m_Dialect = m_Dialect;
        this.m_Numb = m_Numb;
        R4502_is_a_RequiredExecutableProperty_inst = RequiredExecutablePropertyImpl.EMPTY_REQUIREDEXECUTABLEPROPERTY;
        R657_InterfaceOperationInvocation_set = new InterfaceOperationInvocationSetImpl();
        R685_RequiredOperationBody_inst = RequiredOperationBodyImpl.EMPTY_REQUIREDOPERATIONBODY;
    }

    public static RequiredOperation create( Sql context ) throws XtumlException {
        RequiredOperation newRequiredOperation = new RequiredOperationImpl( context );
        if ( context.addInstance( newRequiredOperation ) ) {
            newRequiredOperation.getRunContext().addChange(new InstanceCreatedDelta(newRequiredOperation, KEY_LETTERS));
            return newRequiredOperation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static RequiredOperation create( Sql context, UniqueId ref_Id, String m_Name, String m_Descrip, String m_Action_Semantics, String m_Action_Semantics_internal, ParseStatus m_Suc_Pars, ActionDialect m_Dialect, int m_Numb ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Id, m_Name, m_Descrip, m_Action_Semantics, m_Action_Semantics_internal, m_Suc_Pars, m_Dialect, m_Numb);
    }

    public static RequiredOperation create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip, String m_Action_Semantics, String m_Action_Semantics_internal, ParseStatus m_Suc_Pars, ActionDialect m_Dialect, int m_Numb ) throws XtumlException {
        RequiredOperation newRequiredOperation = new RequiredOperationImpl( context, instanceId, ref_Id, m_Name, m_Descrip, m_Action_Semantics, m_Action_Semantics_internal, m_Suc_Pars, m_Dialect, m_Numb );
        if ( context.addInstance( newRequiredOperation ) ) {
            return newRequiredOperation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R685_RequiredOperationBody().isEmpty() ) R685_RequiredOperationBody().setId( ref_Id );
            if ( !R657_InterfaceOperationInvocation().isEmpty() ) R657_InterfaceOperationInvocation().setRequiredOp_Id( ref_Id );
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    private String m_Action_Semantics;
    @Override
    public void setAction_Semantics(String m_Action_Semantics) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics, this.m_Action_Semantics)) {
            final String oldValue = this.m_Action_Semantics;
            this.m_Action_Semantics = m_Action_Semantics;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics", oldValue, this.m_Action_Semantics));
        }
    }
    @Override
    public String getAction_Semantics() throws XtumlException {
        checkLiving();
        return m_Action_Semantics;
    }
    private String m_Action_Semantics_internal;
    @Override
    public void setAction_Semantics_internal(String m_Action_Semantics_internal) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics_internal, this.m_Action_Semantics_internal)) {
            final String oldValue = this.m_Action_Semantics_internal;
            this.m_Action_Semantics_internal = m_Action_Semantics_internal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics_internal", oldValue, this.m_Action_Semantics_internal));
        }
    }
    @Override
    public String getAction_Semantics_internal() throws XtumlException {
        checkLiving();
        return m_Action_Semantics_internal;
    }
    private ParseStatus m_Suc_Pars;
    @Override
    public void setSuc_Pars(ParseStatus m_Suc_Pars) throws XtumlException {
        checkLiving();
        if (m_Suc_Pars.inequality( this.m_Suc_Pars)) {
            final ParseStatus oldValue = this.m_Suc_Pars;
            this.m_Suc_Pars = m_Suc_Pars;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Suc_Pars", oldValue, this.m_Suc_Pars));
        }
    }
    @Override
    public ParseStatus getSuc_Pars() throws XtumlException {
        checkLiving();
        return m_Suc_Pars;
    }
    private ActionDialect m_Dialect;
    @Override
    public void setDialect(ActionDialect m_Dialect) throws XtumlException {
        checkLiving();
        if (m_Dialect.inequality( this.m_Dialect)) {
            final ActionDialect oldValue = this.m_Dialect;
            this.m_Dialect = m_Dialect;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dialect", oldValue, this.m_Dialect));
        }
    }
    @Override
    public ActionDialect getDialect() throws XtumlException {
        checkLiving();
        return m_Dialect;
    }
    private int m_Numb;
    @Override
    public void setNumb(int m_Numb) throws XtumlException {
        checkLiving();
        if (m_Numb != this.m_Numb) {
            final int oldValue = this.m_Numb;
            this.m_Numb = m_Numb;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Numb", oldValue, this.m_Numb));
        }
    }
    @Override
    public int getNumb() throws XtumlException {
        checkLiving();
        return m_Numb;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private RequiredExecutableProperty R4502_is_a_RequiredExecutableProperty_inst;
    @Override
    public void setR4502_is_a_RequiredExecutableProperty( RequiredExecutableProperty inst ) {
        R4502_is_a_RequiredExecutableProperty_inst = inst;
    }
    @Override
    public RequiredExecutableProperty R4502_is_a_RequiredExecutableProperty() throws XtumlException {
        return R4502_is_a_RequiredExecutableProperty_inst;
    }
    private InterfaceOperationInvocationSet R657_InterfaceOperationInvocation_set;
    @Override
    public void addR657_InterfaceOperationInvocation( InterfaceOperationInvocation inst ) {
        R657_InterfaceOperationInvocation_set.add(inst);
    }
    @Override
    public void removeR657_InterfaceOperationInvocation( InterfaceOperationInvocation inst ) {
        R657_InterfaceOperationInvocation_set.remove(inst);
    }
    @Override
    public InterfaceOperationInvocationSet R657_InterfaceOperationInvocation() throws XtumlException {
        return R657_InterfaceOperationInvocation_set;
    }
    private RequiredOperationBody R685_RequiredOperationBody_inst;
    @Override
    public void setR685_RequiredOperationBody( RequiredOperationBody inst ) {
        R685_RequiredOperationBody_inst = inst;
    }
    @Override
    public RequiredOperationBody R685_RequiredOperationBody() throws XtumlException {
        return R685_RequiredOperationBody_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public RequiredOperation self() {
        return this;
    }

    @Override
    public RequiredOperation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_REQUIREDOPERATION;
    }

}

class EmptyRequiredOperation extends ModelInstance<RequiredOperation,Sql> implements RequiredOperation {

    // attributes
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_Semantics( String m_Action_Semantics ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAction_Semantics() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_Semantics_internal( String m_Action_Semantics_internal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAction_Semantics_internal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSuc_Pars( ParseStatus m_Suc_Pars ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ParseStatus getSuc_Pars() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDialect( ActionDialect m_Dialect ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ActionDialect getDialect() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setNumb( int m_Numb ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getNumb() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public RequiredExecutableProperty R4502_is_a_RequiredExecutableProperty() {
        return RequiredExecutablePropertyImpl.EMPTY_REQUIREDEXECUTABLEPROPERTY;
    }
    @Override
    public InterfaceOperationInvocationSet R657_InterfaceOperationInvocation() {
        return (new InterfaceOperationInvocationSetImpl());
    }
    @Override
    public RequiredOperationBody R685_RequiredOperationBody() {
        return RequiredOperationBodyImpl.EMPTY_REQUIREDOPERATIONBODY;
    }


    @Override
    public String getKeyLetters() {
        return RequiredOperationImpl.KEY_LETTERS;
    }

    @Override
    public RequiredOperation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public RequiredOperation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return RequiredOperationImpl.EMPTY_REQUIREDOPERATION;
    }

}
