package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReference;
import io.ciera.tool.sql.ooaofooa.component.Requirement;
import io.ciera.tool.sql.ooaofooa.component.Satisfaction;
import io.ciera.tool.sql.ooaofooa.component.SatisfactionSet;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceReferenceImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.SatisfactionSetImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredExecutableProperty;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredExecutablePropertySet;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.RequiredExecutablePropertySetImpl;


public class RequirementImpl extends ModelInstance<Requirement,Sql> implements Requirement {

    public static final String KEY_LETTERS = "C_R";
    public static final Requirement EMPTY_REQUIREMENT = new EmptyRequirement();

    private Sql context;

    // constructors
    private RequirementImpl( Sql context ) {
        this.context = context;
        ref_Requirement_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_InformalName = "";
        m_reversePathFromComponent = "";
        R4002_satisfies_Satisfaction_set = new SatisfactionSetImpl();
        R4009_is_a_InterfaceReference_inst = InterfaceReferenceImpl.EMPTY_INTERFACEREFERENCE;
        R4500_implements_RequiredExecutableProperty_set = new RequiredExecutablePropertySetImpl();
    }

    private RequirementImpl( Sql context, UniqueId instanceId, UniqueId ref_Requirement_Id, String m_Name, String m_Descrip, String m_InformalName, String m_reversePathFromComponent ) {
        super(instanceId);
        this.context = context;
        this.ref_Requirement_Id = ref_Requirement_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_InformalName = m_InformalName;
        this.m_reversePathFromComponent = m_reversePathFromComponent;
        R4002_satisfies_Satisfaction_set = new SatisfactionSetImpl();
        R4009_is_a_InterfaceReference_inst = InterfaceReferenceImpl.EMPTY_INTERFACEREFERENCE;
        R4500_implements_RequiredExecutableProperty_set = new RequiredExecutablePropertySetImpl();
    }

    public static Requirement create( Sql context ) throws XtumlException {
        Requirement newRequirement = new RequirementImpl( context );
        if ( context.addInstance( newRequirement ) ) {
            newRequirement.getRunContext().addChange(new InstanceCreatedDelta(newRequirement, KEY_LETTERS));
            return newRequirement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Requirement create( Sql context, UniqueId ref_Requirement_Id, String m_Name, String m_Descrip, String m_InformalName, String m_reversePathFromComponent ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Requirement_Id, m_Name, m_Descrip, m_InformalName, m_reversePathFromComponent);
    }

    public static Requirement create( Sql context, UniqueId instanceId, UniqueId ref_Requirement_Id, String m_Name, String m_Descrip, String m_InformalName, String m_reversePathFromComponent ) throws XtumlException {
        Requirement newRequirement = new RequirementImpl( context, instanceId, ref_Requirement_Id, m_Name, m_Descrip, m_InformalName, m_reversePathFromComponent );
        if ( context.addInstance( newRequirement ) ) {
            return newRequirement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Requirement_Id;
    @Override
    public UniqueId getRequirement_Id() throws XtumlException {
        checkLiving();
        return ref_Requirement_Id;
    }
    @Override
    public void setRequirement_Id(UniqueId ref_Requirement_Id) throws XtumlException {
        checkLiving();
        if (ref_Requirement_Id.inequality( this.ref_Requirement_Id)) {
            final UniqueId oldValue = this.ref_Requirement_Id;
            this.ref_Requirement_Id = ref_Requirement_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Requirement_Id", oldValue, this.ref_Requirement_Id));
            if ( !R4002_satisfies_Satisfaction().isEmpty() ) R4002_satisfies_Satisfaction().setRequirement_Id( ref_Requirement_Id );
            if ( !R4500_implements_RequiredExecutableProperty().isEmpty() ) R4500_implements_RequiredExecutableProperty().setRequirement_Id( ref_Requirement_Id );
        }
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    private String m_InformalName;
    @Override
    public String getInformalName() throws XtumlException {
        checkLiving();
        return m_InformalName;
    }
    @Override
    public void setInformalName(String m_InformalName) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_InformalName, this.m_InformalName)) {
            final String oldValue = this.m_InformalName;
            this.m_InformalName = m_InformalName;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_InformalName", oldValue, this.m_InformalName));
        }
    }
    private String m_reversePathFromComponent;
    @Override
    public String getReversePathFromComponent() throws XtumlException {
        checkLiving();
        return m_reversePathFromComponent;
    }
    @Override
    public void setReversePathFromComponent(String m_reversePathFromComponent) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_reversePathFromComponent, this.m_reversePathFromComponent)) {
            final String oldValue = this.m_reversePathFromComponent;
            this.m_reversePathFromComponent = m_reversePathFromComponent;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_reversePathFromComponent", oldValue, this.m_reversePathFromComponent));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getRequirement_Id());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private SatisfactionSet R4002_satisfies_Satisfaction_set;
    @Override
    public void addR4002_satisfies_Satisfaction( Satisfaction inst ) {
        R4002_satisfies_Satisfaction_set.add(inst);
    }
    @Override
    public void removeR4002_satisfies_Satisfaction( Satisfaction inst ) {
        R4002_satisfies_Satisfaction_set.remove(inst);
    }
    @Override
    public SatisfactionSet R4002_satisfies_Satisfaction() throws XtumlException {
        return R4002_satisfies_Satisfaction_set;
    }
    private InterfaceReference R4009_is_a_InterfaceReference_inst;
    @Override
    public void setR4009_is_a_InterfaceReference( InterfaceReference inst ) {
        R4009_is_a_InterfaceReference_inst = inst;
    }
    @Override
    public InterfaceReference R4009_is_a_InterfaceReference() throws XtumlException {
        return R4009_is_a_InterfaceReference_inst;
    }
    private RequiredExecutablePropertySet R4500_implements_RequiredExecutableProperty_set;
    @Override
    public void addR4500_implements_RequiredExecutableProperty( RequiredExecutableProperty inst ) {
        R4500_implements_RequiredExecutableProperty_set.add(inst);
    }
    @Override
    public void removeR4500_implements_RequiredExecutableProperty( RequiredExecutableProperty inst ) {
        R4500_implements_RequiredExecutableProperty_set.remove(inst);
    }
    @Override
    public RequiredExecutablePropertySet R4500_implements_RequiredExecutableProperty() throws XtumlException {
        return R4500_implements_RequiredExecutableProperty_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Requirement self() {
        return this;
    }

    @Override
    public Requirement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_REQUIREMENT;
    }

}

class EmptyRequirement extends ModelInstance<Requirement,Sql> implements Requirement {

    // attributes
    public UniqueId getRequirement_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRequirement_Id( UniqueId ref_Requirement_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getInformalName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInformalName( String m_InformalName ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getReversePathFromComponent() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReversePathFromComponent( String m_reversePathFromComponent ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public SatisfactionSet R4002_satisfies_Satisfaction() {
        return (new SatisfactionSetImpl());
    }
    @Override
    public InterfaceReference R4009_is_a_InterfaceReference() {
        return InterfaceReferenceImpl.EMPTY_INTERFACEREFERENCE;
    }
    @Override
    public RequiredExecutablePropertySet R4500_implements_RequiredExecutableProperty() {
        return (new RequiredExecutablePropertySetImpl());
    }


    @Override
    public String getKeyLetters() {
        return RequirementImpl.KEY_LETTERS;
    }

    @Override
    public Requirement self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Requirement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return RequirementImpl.EMPTY_REQUIREMENT;
    }

}
