package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.ExecutableProperty;
import io.ciera.tool.sql.ooaofooa.component.InterfaceSignal;
import io.ciera.tool.sql.ooaofooa.component.impl.ExecutablePropertyImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceSignalImpl;
import io.ciera.tool.sql.ooaofooa.message.SignalMessage;
import io.ciera.tool.sql.ooaofooa.message.SignalMessageSet;
import io.ciera.tool.sql.ooaofooa.message.impl.SignalMessageSetImpl;

import ooaofooa.datatypes.IFDirectionType;


public class InterfaceSignalImpl extends ModelInstance<InterfaceSignal,Sql> implements InterfaceSignal {

    public static final String KEY_LETTERS = "C_AS";
    public static final InterfaceSignal EMPTY_INTERFACESIGNAL = new EmptyInterfaceSignal();

    private Sql context;

    // constructors
    private InterfaceSignalImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_Direction = IFDirectionType.UNINITIALIZED_ENUM;
        ref_Previous_Id = UniqueId.random();
        R1021_sent_by_SignalMessage_set = new SignalMessageSetImpl();
        R4004_is_a_ExecutableProperty_inst = ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
        R4020_precedes_InterfaceSignal_inst = InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
        R4020_succeeds_InterfaceSignal_inst = InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
    }

    private InterfaceSignalImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip, IFDirectionType m_Direction, UniqueId ref_Previous_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_Direction = m_Direction;
        this.ref_Previous_Id = ref_Previous_Id;
        R1021_sent_by_SignalMessage_set = new SignalMessageSetImpl();
        R4004_is_a_ExecutableProperty_inst = ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
        R4020_precedes_InterfaceSignal_inst = InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
        R4020_succeeds_InterfaceSignal_inst = InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
    }

    public static InterfaceSignal create( Sql context ) throws XtumlException {
        InterfaceSignal newInterfaceSignal = new InterfaceSignalImpl( context );
        if ( context.addInstance( newInterfaceSignal ) ) {
            newInterfaceSignal.getRunContext().addChange(new InstanceCreatedDelta(newInterfaceSignal, KEY_LETTERS));
            return newInterfaceSignal;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InterfaceSignal create( Sql context, UniqueId ref_Id, String m_Name, String m_Descrip, IFDirectionType m_Direction, UniqueId ref_Previous_Id ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Id, m_Name, m_Descrip, m_Direction, ref_Previous_Id);
    }

    public static InterfaceSignal create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip, IFDirectionType m_Direction, UniqueId ref_Previous_Id ) throws XtumlException {
        InterfaceSignal newInterfaceSignal = new InterfaceSignalImpl( context, instanceId, ref_Id, m_Name, m_Descrip, m_Direction, ref_Previous_Id );
        if ( context.addInstance( newInterfaceSignal ) ) {
            return newInterfaceSignal;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R4020_precedes_InterfaceSignal().isEmpty() ) R4020_precedes_InterfaceSignal().setPrevious_Id( ref_Id );
            if ( !R1021_sent_by_SignalMessage().isEmpty() ) R1021_sent_by_SignalMessage().setId( ref_Id );
        }
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private IFDirectionType m_Direction;
    @Override
    public void setDirection(IFDirectionType m_Direction) throws XtumlException {
        checkLiving();
        if (m_Direction.inequality( this.m_Direction)) {
            final IFDirectionType oldValue = this.m_Direction;
            this.m_Direction = m_Direction;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Direction", oldValue, this.m_Direction));
        }
    }
    @Override
    public IFDirectionType getDirection() throws XtumlException {
        checkLiving();
        return m_Direction;
    }
    private UniqueId ref_Previous_Id;
    @Override
    public void setPrevious_Id(UniqueId ref_Previous_Id) throws XtumlException {
        checkLiving();
        if (ref_Previous_Id.inequality( this.ref_Previous_Id)) {
            final UniqueId oldValue = this.ref_Previous_Id;
            this.ref_Previous_Id = ref_Previous_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Previous_Id", oldValue, this.ref_Previous_Id));
        }
    }
    @Override
    public UniqueId getPrevious_Id() throws XtumlException {
        checkLiving();
        return ref_Previous_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private SignalMessageSet R1021_sent_by_SignalMessage_set;
    @Override
    public void addR1021_sent_by_SignalMessage( SignalMessage inst ) {
        R1021_sent_by_SignalMessage_set.add(inst);
    }
    @Override
    public void removeR1021_sent_by_SignalMessage( SignalMessage inst ) {
        R1021_sent_by_SignalMessage_set.remove(inst);
    }
    @Override
    public SignalMessageSet R1021_sent_by_SignalMessage() throws XtumlException {
        return R1021_sent_by_SignalMessage_set;
    }
    private ExecutableProperty R4004_is_a_ExecutableProperty_inst;
    @Override
    public void setR4004_is_a_ExecutableProperty( ExecutableProperty inst ) {
        R4004_is_a_ExecutableProperty_inst = inst;
    }
    @Override
    public ExecutableProperty R4004_is_a_ExecutableProperty() throws XtumlException {
        return R4004_is_a_ExecutableProperty_inst;
    }
    private InterfaceSignal R4020_precedes_InterfaceSignal_inst;
    @Override
    public void setR4020_precedes_InterfaceSignal( InterfaceSignal inst ) {
        R4020_precedes_InterfaceSignal_inst = inst;
    }
    @Override
    public InterfaceSignal R4020_precedes_InterfaceSignal() throws XtumlException {
        return R4020_precedes_InterfaceSignal_inst;
    }
    private InterfaceSignal R4020_succeeds_InterfaceSignal_inst;
    @Override
    public void setR4020_succeeds_InterfaceSignal( InterfaceSignal inst ) {
        R4020_succeeds_InterfaceSignal_inst = inst;
    }
    @Override
    public InterfaceSignal R4020_succeeds_InterfaceSignal() throws XtumlException {
        return R4020_succeeds_InterfaceSignal_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InterfaceSignal self() {
        return this;
    }

    @Override
    public InterfaceSignal oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INTERFACESIGNAL;
    }

}

class EmptyInterfaceSignal extends ModelInstance<InterfaceSignal,Sql> implements InterfaceSignal {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDirection( IFDirectionType m_Direction ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public IFDirectionType getDirection() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrevious_Id( UniqueId ref_Previous_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPrevious_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public SignalMessageSet R1021_sent_by_SignalMessage() {
        return (new SignalMessageSetImpl());
    }
    @Override
    public ExecutableProperty R4004_is_a_ExecutableProperty() {
        return ExecutablePropertyImpl.EMPTY_EXECUTABLEPROPERTY;
    }
    @Override
    public InterfaceSignal R4020_precedes_InterfaceSignal() {
        return InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
    }
    @Override
    public InterfaceSignal R4020_succeeds_InterfaceSignal() {
        return InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
    }


    @Override
    public String getKeyLetters() {
        return InterfaceSignalImpl.KEY_LETTERS;
    }

    @Override
    public InterfaceSignal self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InterfaceSignal oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InterfaceSignalImpl.EMPTY_INTERFACESIGNAL;
    }

}
