package io.ciera.tool.sql.ooaofooa.body.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.Body;
import io.ciera.tool.sql.ooaofooa.body.RequiredSignalBody;
import io.ciera.tool.sql.ooaofooa.body.impl.BodyImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredSignal;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.RequiredSignalImpl;


public class RequiredSignalBodyImpl extends ModelInstance<RequiredSignalBody,Sql> implements RequiredSignalBody {

    public static final String KEY_LETTERS = "ACT_RSB";
    public static final RequiredSignalBody EMPTY_REQUIREDSIGNALBODY = new EmptyRequiredSignalBody();

    private Sql context;

    // constructors
    private RequiredSignalBodyImpl( Sql context ) {
        this.context = context;
        ref_Action_ID = UniqueId.random();
        ref_Id = UniqueId.random();
        R684_specifies_processing_for_RequiredSignal_inst = RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
        R698_is_a_Body_inst = BodyImpl.EMPTY_BODY;
    }

    private RequiredSignalBodyImpl( Sql context, UniqueId instanceId, UniqueId ref_Action_ID, UniqueId ref_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Action_ID = ref_Action_ID;
        this.ref_Id = ref_Id;
        R684_specifies_processing_for_RequiredSignal_inst = RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
        R698_is_a_Body_inst = BodyImpl.EMPTY_BODY;
    }

    public static RequiredSignalBody create( Sql context ) throws XtumlException {
        RequiredSignalBody newRequiredSignalBody = new RequiredSignalBodyImpl( context );
        if ( context.addInstance( newRequiredSignalBody ) ) {
            newRequiredSignalBody.getRunContext().addChange(new InstanceCreatedDelta(newRequiredSignalBody, KEY_LETTERS));
            return newRequiredSignalBody;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static RequiredSignalBody create( Sql context, UniqueId ref_Action_ID, UniqueId ref_Id ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Action_ID, ref_Id);
    }

    public static RequiredSignalBody create( Sql context, UniqueId instanceId, UniqueId ref_Action_ID, UniqueId ref_Id ) throws XtumlException {
        RequiredSignalBody newRequiredSignalBody = new RequiredSignalBodyImpl( context, instanceId, ref_Action_ID, ref_Id );
        if ( context.addInstance( newRequiredSignalBody ) ) {
            return newRequiredSignalBody;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Action_ID;
    @Override
    public UniqueId getAction_ID() throws XtumlException {
        checkLiving();
        return ref_Action_ID;
    }
    @Override
    public void setAction_ID(UniqueId ref_Action_ID) throws XtumlException {
        checkLiving();
        if (ref_Action_ID.inequality( this.ref_Action_ID)) {
            final UniqueId oldValue = this.ref_Action_ID;
            this.ref_Action_ID = ref_Action_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Action_ID", oldValue, this.ref_Action_ID));
        }
    }
    private UniqueId ref_Id;
    @Override
    public void setId(UniqueId ref_Id) throws XtumlException {
        checkLiving();
        if (ref_Id.inequality( this.ref_Id)) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
        return ref_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAction_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private RequiredSignal R684_specifies_processing_for_RequiredSignal_inst;
    @Override
    public void setR684_specifies_processing_for_RequiredSignal( RequiredSignal inst ) {
        R684_specifies_processing_for_RequiredSignal_inst = inst;
    }
    @Override
    public RequiredSignal R684_specifies_processing_for_RequiredSignal() throws XtumlException {
        return R684_specifies_processing_for_RequiredSignal_inst;
    }
    private Body R698_is_a_Body_inst;
    @Override
    public void setR698_is_a_Body( Body inst ) {
        R698_is_a_Body_inst = inst;
    }
    @Override
    public Body R698_is_a_Body() throws XtumlException {
        return R698_is_a_Body_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public RequiredSignalBody self() {
        return this;
    }

    @Override
    public RequiredSignalBody oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_REQUIREDSIGNALBODY;
    }

}

class EmptyRequiredSignalBody extends ModelInstance<RequiredSignalBody,Sql> implements RequiredSignalBody {

    // attributes
    public UniqueId getAction_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_ID( UniqueId ref_Action_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public RequiredSignal R684_specifies_processing_for_RequiredSignal() {
        return RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
    }
    @Override
    public Body R698_is_a_Body() {
        return BodyImpl.EMPTY_BODY;
    }


    @Override
    public String getKeyLetters() {
        return RequiredSignalBodyImpl.KEY_LETTERS;
    }

    @Override
    public RequiredSignalBody self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public RequiredSignalBody oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return RequiredSignalBodyImpl.EMPTY_REQUIREDSIGNALBODY;
    }

}
