package io.ciera.tool.sql.ooaofooa.body.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.Block;
import io.ciera.tool.sql.ooaofooa.body.ForStmt;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.body.impl.BlockImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;


public class ForStmtImpl extends ModelInstance<ForStmt,Sql> implements ForStmt {

    public static final String KEY_LETTERS = "ACT_FOR";
    public static final ForStmt EMPTY_FORSTMT = new EmptyForStmt();

    private Sql context;

    // constructors
    private ForStmtImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Block_ID = UniqueId.random();
        m_is_implicit = false;
        ref_Loop_Var_ID = UniqueId.random();
        ref_Set_Var_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R605_controls_Block_inst = BlockImpl.EMPTY_BLOCK;
        R614_loop_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R652_set_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R670_iterates_a_set_of_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    private ForStmtImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Block_ID, boolean m_is_implicit, UniqueId ref_Loop_Var_ID, UniqueId ref_Set_Var_ID, UniqueId ref_Obj_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Block_ID = ref_Block_ID;
        this.m_is_implicit = m_is_implicit;
        this.ref_Loop_Var_ID = ref_Loop_Var_ID;
        this.ref_Set_Var_ID = ref_Set_Var_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R605_controls_Block_inst = BlockImpl.EMPTY_BLOCK;
        R614_loop_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R652_set_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R670_iterates_a_set_of_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    public static ForStmt create( Sql context ) throws XtumlException {
        ForStmt newForStmt = new ForStmtImpl( context );
        if ( context.addInstance( newForStmt ) ) {
            newForStmt.getRunContext().addChange(new InstanceCreatedDelta(newForStmt, KEY_LETTERS));
            return newForStmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ForStmt create( Sql context, UniqueId ref_Statement_ID, UniqueId ref_Block_ID, boolean m_is_implicit, UniqueId ref_Loop_Var_ID, UniqueId ref_Set_Var_ID, UniqueId ref_Obj_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Statement_ID, ref_Block_ID, m_is_implicit, ref_Loop_Var_ID, ref_Set_Var_ID, ref_Obj_ID);
    }

    public static ForStmt create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Block_ID, boolean m_is_implicit, UniqueId ref_Loop_Var_ID, UniqueId ref_Set_Var_ID, UniqueId ref_Obj_ID ) throws XtumlException {
        ForStmt newForStmt = new ForStmtImpl( context, instanceId, ref_Statement_ID, ref_Block_ID, m_is_implicit, ref_Loop_Var_ID, ref_Set_Var_ID, ref_Obj_ID );
        if ( context.addInstance( newForStmt ) ) {
            return newForStmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    private UniqueId ref_Block_ID;
    @Override
    public UniqueId getBlock_ID() throws XtumlException {
        checkLiving();
        return ref_Block_ID;
    }
    @Override
    public void setBlock_ID(UniqueId ref_Block_ID) throws XtumlException {
        checkLiving();
        if (ref_Block_ID.inequality( this.ref_Block_ID)) {
            final UniqueId oldValue = this.ref_Block_ID;
            this.ref_Block_ID = ref_Block_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Block_ID", oldValue, this.ref_Block_ID));
        }
    }
    private boolean m_is_implicit;
    @Override
    public void setIs_implicit(boolean m_is_implicit) throws XtumlException {
        checkLiving();
        if (m_is_implicit != this.m_is_implicit) {
            final boolean oldValue = this.m_is_implicit;
            this.m_is_implicit = m_is_implicit;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_is_implicit", oldValue, this.m_is_implicit));
        }
    }
    @Override
    public boolean getIs_implicit() throws XtumlException {
        checkLiving();
        return m_is_implicit;
    }
    private UniqueId ref_Loop_Var_ID;
    @Override
    public UniqueId getLoop_Var_ID() throws XtumlException {
        checkLiving();
        return ref_Loop_Var_ID;
    }
    @Override
    public void setLoop_Var_ID(UniqueId ref_Loop_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Loop_Var_ID.inequality( this.ref_Loop_Var_ID)) {
            final UniqueId oldValue = this.ref_Loop_Var_ID;
            this.ref_Loop_Var_ID = ref_Loop_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Loop_Var_ID", oldValue, this.ref_Loop_Var_ID));
        }
    }
    private UniqueId ref_Set_Var_ID;
    @Override
    public void setSet_Var_ID(UniqueId ref_Set_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Set_Var_ID.inequality( this.ref_Set_Var_ID)) {
            final UniqueId oldValue = this.ref_Set_Var_ID;
            this.ref_Set_Var_ID = ref_Set_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Set_Var_ID", oldValue, this.ref_Set_Var_ID));
        }
    }
    @Override
    public UniqueId getSet_Var_ID() throws XtumlException {
        checkLiving();
        return ref_Set_Var_ID;
    }
    private UniqueId ref_Obj_ID;
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private Block R605_controls_Block_inst;
    @Override
    public void setR605_controls_Block( Block inst ) {
        R605_controls_Block_inst = inst;
    }
    @Override
    public Block R605_controls_Block() throws XtumlException {
        return R605_controls_Block_inst;
    }
    private V_VAR R614_loop_V_VAR_inst;
    @Override
    public void setR614_loop_V_VAR( V_VAR inst ) {
        R614_loop_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R614_loop_V_VAR() throws XtumlException {
        return R614_loop_V_VAR_inst;
    }
    private V_VAR R652_set_V_VAR_inst;
    @Override
    public void setR652_set_V_VAR( V_VAR inst ) {
        R652_set_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R652_set_V_VAR() throws XtumlException {
        return R652_set_V_VAR_inst;
    }
    private ModelClass R670_iterates_a_set_of_ModelClass_inst;
    @Override
    public void setR670_iterates_a_set_of_ModelClass( ModelClass inst ) {
        R670_iterates_a_set_of_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R670_iterates_a_set_of_ModelClass() throws XtumlException {
        return R670_iterates_a_set_of_ModelClass_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ForStmt self() {
        return this;
    }

    @Override
    public ForStmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_FORSTMT;
    }

}

class EmptyForStmt extends ModelInstance<ForStmt,Sql> implements ForStmt {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getBlock_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_ID( UniqueId ref_Block_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setIs_implicit( boolean m_is_implicit ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIs_implicit() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getLoop_Var_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoop_Var_ID( UniqueId ref_Loop_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSet_Var_ID( UniqueId ref_Set_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSet_Var_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public Block R605_controls_Block() {
        return BlockImpl.EMPTY_BLOCK;
    }
    @Override
    public V_VAR R614_loop_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }
    @Override
    public V_VAR R652_set_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }
    @Override
    public ModelClass R670_iterates_a_set_of_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }


    @Override
    public String getKeyLetters() {
        return ForStmtImpl.KEY_LETTERS;
    }

    @Override
    public ForStmt self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ForStmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ForStmtImpl.EMPTY_FORSTMT;
    }

}
