package io.ciera.tool.sql.ooaofmarking.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.ooaofmarking.Feature;
import io.ciera.tool.sql.ooaofmarking.FeatureSet;
import io.ciera.tool.sql.ooaofmarking.MarkSet;
import io.ciera.tool.sql.ooaofmarking.MarkableElementTypeSet;
import io.ciera.tool.sql.ooaofmarking.impl.MarkSetImpl;
import io.ciera.tool.sql.ooaofmarking.impl.MarkableElementTypeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class FeatureSetImpl extends InstanceSet<FeatureSet,Feature> implements FeatureSet {

    public FeatureSetImpl() {
    }

    public FeatureSetImpl(Comparator<? super Feature> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String m_name ) throws XtumlException {
        for ( Feature feature : this ) feature.setName( m_name );
    }


    // selections
    @Override
    public MarkSet R2821_marks_Mark() throws XtumlException {
        MarkSet markset = new MarkSetImpl();
        for ( Feature feature : this ) markset.addAll( feature.R2821_marks_Mark() );
        return markset;
    }
    @Override
    public MarkableElementTypeSet R2822_is_available_for_MarkableElementType() throws XtumlException {
        MarkableElementTypeSet markableelementtypeset = new MarkableElementTypeSetImpl();
        for ( Feature feature : this ) markableelementtypeset.addAll( feature.R2822_is_available_for_MarkableElementType() );
        return markableelementtypeset;
    }


    @Override
    public Feature nullElement() {
        return FeatureImpl.EMPTY_FEATURE;
    }

    @Override
    public FeatureSet emptySet() {
      return new FeatureSetImpl();
    }

    @Override
    public FeatureSet emptySet(Comparator<? super Feature> comp) {
      return new FeatureSetImpl(comp);
    }

    @Override
    public List<Feature> elements() {
        Feature[] elements = toArray(new Feature[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
