package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.ActionHome;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.AttributeSerializer;
import io.ciera.tool.sql.loader.UniqueIDSerializer;
import io.ciera.tool.sql.loader.impl.AttributeSerializerImpl;
import io.ciera.tool.sql.loader.impl.UniqueIDSerializerImpl;
import io.ciera.tool.sql.ooaofmarking.Mark;


public class UniqueIDSerializerImpl extends ModelInstance<UniqueIDSerializer,Sql> implements UniqueIDSerializer {

    public static final String KEY_LETTERS = "UniqueIDSerializer";
    public static final UniqueIDSerializer EMPTY_UNIQUEIDSERIALIZER = new EmptyUniqueIDSerializer();

    private Sql context;

    // constructors
    private UniqueIDSerializerImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        ref_class_name = "";
        ref_attr_name = "";
        m_value = "";
        m_primary_key = false;
        R3004_is_a_AttributeSerializer_inst = AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
    }

    private UniqueIDSerializerImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, String ref_attr_name, String m_value, boolean m_primary_key ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.ref_class_name = ref_class_name;
        this.ref_attr_name = ref_attr_name;
        this.m_value = m_value;
        this.m_primary_key = m_primary_key;
        R3004_is_a_AttributeSerializer_inst = AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
    }

    public static UniqueIDSerializer create( Sql context ) throws XtumlException {
        UniqueIDSerializer newUniqueIDSerializer = new UniqueIDSerializerImpl( context );
        if ( context.addInstance( newUniqueIDSerializer ) ) {
            newUniqueIDSerializer.getRunContext().addChange(new InstanceCreatedDelta(newUniqueIDSerializer, KEY_LETTERS));
            return newUniqueIDSerializer;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static UniqueIDSerializer create( Sql context, String ref_loader_name, String ref_loader_package, String ref_class_name, String ref_attr_name, String m_value, boolean m_primary_key ) throws XtumlException {
        return create(context, UniqueId.random(), ref_loader_name, ref_loader_package, ref_class_name, ref_attr_name, m_value, m_primary_key);
    }

    public static UniqueIDSerializer create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, String ref_attr_name, String m_value, boolean m_primary_key ) throws XtumlException {
        UniqueIDSerializer newUniqueIDSerializer = new UniqueIDSerializerImpl( context, instanceId, ref_loader_name, ref_loader_package, ref_class_name, ref_attr_name, m_value, m_primary_key );
        if ( context.addInstance( newUniqueIDSerializer ) ) {
            return newUniqueIDSerializer;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public void setLoader_name(String ref_loader_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_name, this.ref_loader_name)) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
        }
    }
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
        return ref_loader_name;
    }
    private String ref_loader_package;
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
        return ref_loader_package;
    }
    @Override
    public void setLoader_package(String ref_loader_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_package, this.ref_loader_package)) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
        }
    }
    private String ref_class_name;
    @Override
    public void setClass_name(String ref_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_name, this.ref_class_name)) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
        return ref_class_name;
    }
    private String ref_attr_name;
    @Override
    public void setAttr_name(String ref_attr_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_attr_name, this.ref_attr_name)) {
            final String oldValue = this.ref_attr_name;
            this.ref_attr_name = ref_attr_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attr_name", oldValue, this.ref_attr_name));
        }
    }
    @Override
    public String getAttr_name() throws XtumlException {
        checkLiving();
        return ref_attr_name;
    }
    private String m_value;
    @Override
    public void setValue(String m_value) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_value, this.m_value)) {
            final String oldValue = this.m_value;
            this.m_value = m_value;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_value", oldValue, this.m_value));
        }
    }
    @Override
    public String getValue() throws XtumlException {
        checkLiving();
        return m_value;
    }
    private boolean m_primary_key;
    @Override
    public boolean getPrimary_key() throws XtumlException {
        checkLiving();
        return m_primary_key;
    }
    @Override
    public void setPrimary_key(boolean m_primary_key) throws XtumlException {
        checkLiving();
        if (m_primary_key != this.m_primary_key) {
            final boolean oldValue = this.m_primary_key;
            this.m_primary_key = m_primary_key;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_primary_key", oldValue, this.m_primary_key));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getClass_name(), getAttr_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        new UniqueIDSerializerImpl.CLASS(context()).do_render( self().getClass_name(), self().getValue() );
    }



    // static operations
    public static class CLASS extends ActionHome<Sql> {

        public CLASS( Sql context ) {
            super( context );
        }

        public void do_render( final String p_class_name,  final String p_accessor_name ) throws XtumlException {
            String quote = "'";
            Mark uuid_quote_mark = context().Mark_instances().anyWhere(selected -> ( StringUtil.equality(((Mark)selected).getMarkable_name(), "*") && StringUtil.equality(((Mark)selected).getPath(), "*") ) && StringUtil.equality(((Mark)selected).getFeature_name(), "UseDoubleQuoteUUID"));
            if ( !uuid_quote_mark.isEmpty() ) {
                quote = "\\" + context().STRING().quote();
            }
            String class_name = p_class_name;
            String value = p_accessor_name;
            context().T().include( "loader/t.uniqueidserializer.java", class_name, quote, value );
        }



    }


    // events


    // selections
    private AttributeSerializer R3004_is_a_AttributeSerializer_inst;
    @Override
    public void setR3004_is_a_AttributeSerializer( AttributeSerializer inst ) {
        R3004_is_a_AttributeSerializer_inst = inst;
    }
    @Override
    public AttributeSerializer R3004_is_a_AttributeSerializer() throws XtumlException {
        return R3004_is_a_AttributeSerializer_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public UniqueIDSerializer self() {
        return this;
    }

    @Override
    public UniqueIDSerializer oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_UNIQUEIDSERIALIZER;
    }

}

class EmptyUniqueIDSerializer extends ModelInstance<UniqueIDSerializer,Sql> implements UniqueIDSerializer {

    // attributes
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAttr_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue( String m_value ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getValue() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getPrimary_key() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrimary_key( boolean m_primary_key ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public AttributeSerializer R3004_is_a_AttributeSerializer() {
        return AttributeSerializerImpl.EMPTY_ATTRIBUTESERIALIZER;
    }


    @Override
    public String getKeyLetters() {
        return UniqueIDSerializerImpl.KEY_LETTERS;
    }

    @Override
    public UniqueIDSerializer self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public UniqueIDSerializer oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return UniqueIDSerializerImpl.EMPTY_UNIQUEIDSERIALIZER;
    }

}
