package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.loader.AttributeComparison;
import io.ciera.tool.sql.loader.AttributeComparisonSet;
import io.ciera.tool.sql.loader.BatchRelatorSet;
import io.ciera.tool.sql.loader.impl.AttributeComparisonSetImpl;
import io.ciera.tool.sql.loader.impl.BatchRelatorSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class AttributeComparisonSetImpl extends InstanceSet<AttributeComparisonSet,AttributeComparison> implements AttributeComparisonSet {

    public AttributeComparisonSetImpl() {
    }

    public AttributeComparisonSetImpl(Comparator<? super AttributeComparison> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( AttributeComparison attributecomparison : this ) attributecomparison.setLoader_package( ref_loader_package );
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( AttributeComparison attributecomparison : this ) attributecomparison.setLoader_name( ref_loader_name );
    }
    @Override
    public void setPart_attr_name( String m_part_attr_name ) throws XtumlException {
        for ( AttributeComparison attributecomparison : this ) attributecomparison.setPart_attr_name( m_part_attr_name );
    }
    @Override
    public void setPrimitive( boolean m_primitive ) throws XtumlException {
        for ( AttributeComparison attributecomparison : this ) attributecomparison.setPrimitive( m_primitive );
    }
    @Override
    public void setForm_accessor( String m_form_accessor ) throws XtumlException {
        for ( AttributeComparison attributecomparison : this ) attributecomparison.setForm_accessor( m_form_accessor );
    }
    @Override
    public void setPart_accessor( String m_part_accessor ) throws XtumlException {
        for ( AttributeComparison attributecomparison : this ) attributecomparison.setPart_accessor( m_part_accessor );
    }
    @Override
    public void setIs_string( boolean m_is_string ) throws XtumlException {
        for ( AttributeComparison attributecomparison : this ) attributecomparison.setIs_string( m_is_string );
    }
    @Override
    public void setRel_name( String ref_rel_name ) throws XtumlException {
        for ( AttributeComparison attributecomparison : this ) attributecomparison.setRel_name( ref_rel_name );
    }
    @Override
    public void setPrev_part_attr_name( String ref_prev_part_attr_name ) throws XtumlException {
        for ( AttributeComparison attributecomparison : this ) attributecomparison.setPrev_part_attr_name( ref_prev_part_attr_name );
    }


    // selections
    @Override
    public BatchRelatorSet R3012_evaluated_by_BatchRelator() throws XtumlException {
        BatchRelatorSet batchrelatorset = new BatchRelatorSetImpl();
        for ( AttributeComparison attributecomparison : this ) batchrelatorset.add( attributecomparison.R3012_evaluated_by_BatchRelator() );
        return batchrelatorset;
    }
    @Override
    public AttributeComparisonSet R3018_precedes_AttributeComparison() throws XtumlException {
        AttributeComparisonSet attributecomparisonset = new AttributeComparisonSetImpl();
        for ( AttributeComparison attributecomparison : this ) attributecomparisonset.add( attributecomparison.R3018_precedes_AttributeComparison() );
        return attributecomparisonset;
    }
    @Override
    public AttributeComparisonSet R3018_succeeds_AttributeComparison() throws XtumlException {
        AttributeComparisonSet attributecomparisonset = new AttributeComparisonSetImpl();
        for ( AttributeComparison attributecomparison : this ) attributecomparisonset.add( attributecomparison.R3018_succeeds_AttributeComparison() );
        return attributecomparisonset;
    }


    @Override
    public AttributeComparison nullElement() {
        return AttributeComparisonImpl.EMPTY_ATTRIBUTECOMPARISON;
    }

    @Override
    public AttributeComparisonSet emptySet() {
      return new AttributeComparisonSetImpl();
    }

    @Override
    public AttributeComparisonSet emptySet(Comparator<? super AttributeComparison> comp) {
      return new AttributeComparisonSetImpl(comp);
    }

    @Override
    public List<AttributeComparison> elements() {
        return Arrays.asList(toArray(new AttributeComparison[0]));
    }

}
