package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.file.impl.FileImpl;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.UserDefinedType;
import io.ciera.tool.sql.architecture.type.impl.TypeImpl;

import types.ImportType;


public class UserDefinedTypeImpl extends ModelInstance<UserDefinedType,Sql> implements UserDefinedType {

    public static final String KEY_LETTERS = "UserDefinedType";
    public static final UserDefinedType EMPTY_USERDEFINEDTYPE = new EmptyUserDefinedType();

    private Sql context;

    // constructors
    private UserDefinedTypeImpl( Sql context ) {
        this.context = context;
        ref_name = "";
        ref_package = "";
        ref_base_type_name = "";
        ref_base_type_package = "";
        R3802_based_on_Type_inst = TypeImpl.EMPTY_TYPE;
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R407_is_a_Type_inst = TypeImpl.EMPTY_TYPE;
    }

    private UserDefinedTypeImpl( Sql context, UniqueId instanceId, String ref_name, String ref_package, String ref_base_type_name, String ref_base_type_package ) {
        super(instanceId);
        this.context = context;
        this.ref_name = ref_name;
        this.ref_package = ref_package;
        this.ref_base_type_name = ref_base_type_name;
        this.ref_base_type_package = ref_base_type_package;
        R3802_based_on_Type_inst = TypeImpl.EMPTY_TYPE;
        R401_is_a_File_inst = FileImpl.EMPTY_FILE;
        R407_is_a_Type_inst = TypeImpl.EMPTY_TYPE;
    }

    public static UserDefinedType create( Sql context ) throws XtumlException {
        UserDefinedType newUserDefinedType = new UserDefinedTypeImpl( context );
        if ( context.addInstance( newUserDefinedType ) ) {
            newUserDefinedType.getRunContext().addChange(new InstanceCreatedDelta(newUserDefinedType, KEY_LETTERS));
            return newUserDefinedType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static UserDefinedType create( Sql context, String ref_name, String ref_package, String ref_base_type_name, String ref_base_type_package ) throws XtumlException {
        return create(context, UniqueId.random(), ref_name, ref_package, ref_base_type_name, ref_base_type_package);
    }

    public static UserDefinedType create( Sql context, UniqueId instanceId, String ref_name, String ref_package, String ref_base_type_name, String ref_base_type_package ) throws XtumlException {
        UserDefinedType newUserDefinedType = new UserDefinedTypeImpl( context, instanceId, ref_name, ref_package, ref_base_type_name, ref_base_type_package );
        if ( context.addInstance( newUserDefinedType ) ) {
            return newUserDefinedType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return ref_name;
    }
    @Override
    public void setName(String ref_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_name, this.ref_name)) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
        }
    }
    private String ref_package;
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
        return ref_package;
    }
    @Override
    public void setPackage(String ref_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_package, this.ref_package)) {
            final String oldValue = this.ref_package;
            this.ref_package = ref_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_package", oldValue, this.ref_package));
        }
    }
    private String ref_base_type_name;
    @Override
    public String getBase_type_name() throws XtumlException {
        checkLiving();
        return ref_base_type_name;
    }
    @Override
    public void setBase_type_name(String ref_base_type_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_base_type_name, this.ref_base_type_name)) {
            final String oldValue = this.ref_base_type_name;
            this.ref_base_type_name = ref_base_type_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_base_type_name", oldValue, this.ref_base_type_name));
        }
    }
    private String ref_base_type_package;
    @Override
    public String getBase_type_package() throws XtumlException {
        checkLiving();
        return ref_base_type_package;
    }
    @Override
    public void setBase_type_package(String ref_base_type_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_base_type_package, this.ref_base_type_package)) {
            final String oldValue = this.ref_base_type_package;
            this.ref_base_type_package = ref_base_type_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_base_type_package", oldValue, this.ref_base_type_package));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        File file = self().R401_is_a_File();
        String extends_type = self().getBase_type_name();
        Type base_type = self().R3802_based_on_Type();
        if ( base_type.primitive() ) {
            if ( StringUtil.equality("boolean", self().getBase_type_name()) ) {
                extends_type = "BooleanUDT";
                context().addStringToImports( file, "io.ciera.runtime.summit.types.BooleanUDT", ImportType.IMPL );
            }
            else if ( StringUtil.equality("int", self().getBase_type_name()) ) {
                extends_type = "IntegerUDT";
                context().addStringToImports( file, "io.ciera.runtime.summit.types.IntegerUDT", ImportType.IMPL );
            }
            else if ( StringUtil.equality("double", self().getBase_type_name()) ) {
                extends_type = "RealUDT";
                context().addStringToImports( file, "io.ciera.runtime.summit.types.RealUDT", ImportType.IMPL );
            }
        }
        else if ( StringUtil.equality("String", self().getBase_type_name()) ) {
            extends_type = "StringUDT";
            context().addStringToImports( file, "io.ciera.runtime.summit.types.StringUDT", ImportType.IMPL );
        }
        String imports = file.getFormattedImports( ImportType.IMPL );
        context().T().include( "type/t.userdefinedtype.java", extends_type, imports, self() );
        context().T().emit( ( ( file.getPath() + "/" ) + self().getName() ) + file.getExtension() );
        context().T().clear();
    }



    // static operations


    // events


    // selections
    private Type R3802_based_on_Type_inst;
    @Override
    public void setR3802_based_on_Type( Type inst ) {
        R3802_based_on_Type_inst = inst;
    }
    @Override
    public Type R3802_based_on_Type() throws XtumlException {
        return R3802_based_on_Type_inst;
    }
    private File R401_is_a_File_inst;
    @Override
    public void setR401_is_a_File( File inst ) {
        R401_is_a_File_inst = inst;
    }
    @Override
    public File R401_is_a_File() throws XtumlException {
        return R401_is_a_File_inst;
    }
    private Type R407_is_a_Type_inst;
    @Override
    public void setR407_is_a_Type( Type inst ) {
        R407_is_a_Type_inst = inst;
    }
    @Override
    public Type R407_is_a_Type() throws XtumlException {
        return R407_is_a_Type_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public UserDefinedType self() {
        return this;
    }

    @Override
    public UserDefinedType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_USERDEFINEDTYPE;
    }

}

class EmptyUserDefinedType extends ModelInstance<UserDefinedType,Sql> implements UserDefinedType {

    // attributes
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String ref_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBase_type_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBase_type_name( String ref_base_type_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBase_type_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBase_type_package( String ref_base_type_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Type R3802_based_on_Type() {
        return TypeImpl.EMPTY_TYPE;
    }
    @Override
    public File R401_is_a_File() {
        return FileImpl.EMPTY_FILE;
    }
    @Override
    public Type R407_is_a_Type() {
        return TypeImpl.EMPTY_TYPE;
    }


    @Override
    public String getKeyLetters() {
        return UserDefinedTypeImpl.KEY_LETTERS;
    }

    @Override
    public UserDefinedType self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public UserDefinedType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return UserDefinedTypeImpl.EMPTY_USERDEFINEDTYPE;
    }

}
