package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.EnumeratorReferenceSet;
import io.ciera.tool.sql.architecture.expression.impl.EnumeratorReferenceSetImpl;
import io.ciera.tool.sql.architecture.type.EnumeratedTypeSet;
import io.ciera.tool.sql.architecture.type.Enumerator;
import io.ciera.tool.sql.architecture.type.EnumeratorSet;
import io.ciera.tool.sql.architecture.type.impl.EnumeratedTypeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class EnumeratorSetImpl extends InstanceSet<EnumeratorSet,Enumerator> implements EnumeratorSet {

    public EnumeratorSetImpl() {
    }

    public EnumeratorSetImpl(Comparator<? super Enumerator> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setValue( int m_value ) throws XtumlException {
        for ( Enumerator enumerator : this ) enumerator.setValue( m_value );
    }
    @Override
    public void setType_name( String ref_type_name ) throws XtumlException {
        for ( Enumerator enumerator : this ) enumerator.setType_name( ref_type_name );
    }
    @Override
    public void setType_package( String ref_type_package ) throws XtumlException {
        for ( Enumerator enumerator : this ) enumerator.setType_package( ref_type_package );
    }
    @Override
    public void setName( String m_name ) throws XtumlException {
        for ( Enumerator enumerator : this ) enumerator.setName( m_name );
    }


    // selections
    @Override
    public EnumeratedTypeSet R415_is_unique_value_of_EnumeratedType() throws XtumlException {
        EnumeratedTypeSet enumeratedtypeset = new EnumeratedTypeSetImpl();
        for ( Enumerator enumerator : this ) enumeratedtypeset.add( enumerator.R415_is_unique_value_of_EnumeratedType() );
        return enumeratedtypeset;
    }
    @Override
    public EnumeratorReferenceSet R786_is_referenced_by_EnumeratorReference() throws XtumlException {
        EnumeratorReferenceSet enumeratorreferenceset = new EnumeratorReferenceSetImpl();
        for ( Enumerator enumerator : this ) enumeratorreferenceset.addAll( enumerator.R786_is_referenced_by_EnumeratorReference() );
        return enumeratorreferenceset;
    }


    @Override
    public Enumerator nullElement() {
        return EnumeratorImpl.EMPTY_ENUMERATOR;
    }

    @Override
    public EnumeratorSet emptySet() {
      return new EnumeratorSetImpl();
    }

    @Override
    public EnumeratorSet emptySet(Comparator<? super Enumerator> comp) {
      return new EnumeratorSetImpl(comp);
    }

    @Override
    public List<Enumerator> elements() {
        Enumerator[] elements = toArray(new Enumerator[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
