package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.type.BasicTypeReference;
import io.ciera.tool.sql.architecture.type.BasicTypeReferenceSet;
import io.ciera.tool.sql.architecture.type.TypeReferenceSet;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class BasicTypeReferenceSetImpl extends InstanceSet<BasicTypeReferenceSet,BasicTypeReference> implements BasicTypeReferenceSet {

    public BasicTypeReferenceSetImpl() {
    }

    public BasicTypeReferenceSetImpl(Comparator<? super BasicTypeReference> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setType_reference_name( String ref_type_reference_name ) throws XtumlException {
        for ( BasicTypeReference basictypereference : this ) basictypereference.setType_reference_name( ref_type_reference_name );
    }
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( BasicTypeReference basictypereference : this ) basictypereference.setPackage( ref_package );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( BasicTypeReference basictypereference : this ) basictypereference.setName( ref_name );
    }


    // selections
    @Override
    public TypeReferenceSet R3801_is_a_TypeReference() throws XtumlException {
        TypeReferenceSet typereferenceset = new TypeReferenceSetImpl();
        for ( BasicTypeReference basictypereference : this ) typereferenceset.add( basictypereference.R3801_is_a_TypeReference() );
        return typereferenceset;
    }


    @Override
    public BasicTypeReference nullElement() {
        return BasicTypeReferenceImpl.EMPTY_BASICTYPEREFERENCE;
    }

    @Override
    public BasicTypeReferenceSet emptySet() {
      return new BasicTypeReferenceSetImpl();
    }

    @Override
    public BasicTypeReferenceSet emptySet(Comparator<? super BasicTypeReference> comp) {
      return new BasicTypeReferenceSetImpl(comp);
    }

    @Override
    public List<BasicTypeReference> elements() {
        BasicTypeReference[] elements = toArray(new BasicTypeReference[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
