package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.statement.ReturnSmt;
import io.ciera.tool.sql.architecture.statement.ReturnSmtSet;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ReturnSmtSetImpl extends InstanceSet<ReturnSmtSet,ReturnSmt> implements ReturnSmtSet {

    public ReturnSmtSetImpl() {
    }

    public ReturnSmtSetImpl(Comparator<? super ReturnSmt> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setRet_expression_number( String ref_ret_expression_number ) throws XtumlException {
        for ( ReturnSmt returnsmt : this ) returnsmt.setRet_expression_number( ref_ret_expression_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( ReturnSmt returnsmt : this ) returnsmt.setParent_name( ref_parent_name );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( ReturnSmt returnsmt : this ) returnsmt.setBody_name( ref_body_name );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( ReturnSmt returnsmt : this ) returnsmt.setBlock_number( ref_block_number );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( ReturnSmt returnsmt : this ) returnsmt.setParent_package( ref_parent_package );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( ReturnSmt returnsmt : this ) returnsmt.setStatement_number( ref_statement_number );
    }


    // selections
    @Override
    public StatementSet R451_is_a_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( ReturnSmt returnsmt : this ) statementset.add( returnsmt.R451_is_a_Statement() );
        return statementset;
    }
    @Override
    public ExpressionSet R473_returns_value_specified_by_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( ReturnSmt returnsmt : this ) expressionset.add( returnsmt.R473_returns_value_specified_by_Expression() );
        return expressionset;
    }


    @Override
    public ReturnSmt nullElement() {
        return ReturnSmtImpl.EMPTY_RETURNSMT;
    }

    @Override
    public ReturnSmtSet emptySet() {
      return new ReturnSmtSetImpl();
    }

    @Override
    public ReturnSmtSet emptySet(Comparator<? super ReturnSmt> comp) {
      return new ReturnSmtSetImpl(comp);
    }

    @Override
    public List<ReturnSmt> elements() {
        return Arrays.asList(toArray(new ReturnSmt[0]));
    }

}
