package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.statement.Halt;
import io.ciera.tool.sql.architecture.statement.HaltSet;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class HaltSetImpl extends InstanceSet<HaltSet,Halt> implements HaltSet {

    public HaltSetImpl() {
    }

    public HaltSetImpl(Comparator<? super Halt> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( Halt halt : this ) halt.setBlock_number( ref_block_number );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( Halt halt : this ) halt.setParent_package( ref_parent_package );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( Halt halt : this ) halt.setName( ref_name );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( Halt halt : this ) halt.setParent_name( ref_parent_name );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( Halt halt : this ) halt.setStatement_number( ref_statement_number );
    }


    // selections
    @Override
    public StatementSet R451_is_a_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( Halt halt : this ) statementset.add( halt.R451_is_a_Statement() );
        return statementset;
    }


    @Override
    public Halt nullElement() {
        return HaltImpl.EMPTY_HALT;
    }

    @Override
    public HaltSet emptySet() {
      return new HaltSetImpl();
    }

    @Override
    public HaltSet emptySet(Comparator<? super Halt> comp) {
      return new HaltSetImpl(comp);
    }

    @Override
    public List<Halt> elements() {
        Halt[] elements = toArray(new Halt[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
