package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.statement.ExpressionAsStatement;
import io.ciera.tool.sql.architecture.statement.ExpressionAsStatementSet;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ExpressionAsStatementSetImpl extends InstanceSet<ExpressionAsStatementSet,ExpressionAsStatement> implements ExpressionAsStatementSet {

    public ExpressionAsStatementSetImpl() {
    }

    public ExpressionAsStatementSetImpl(Comparator<? super ExpressionAsStatement> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( ExpressionAsStatement expressionasstatement : this ) expressionasstatement.setStatement_number( ref_statement_number );
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( ExpressionAsStatement expressionasstatement : this ) expressionasstatement.setExpression_number( ref_expression_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( ExpressionAsStatement expressionasstatement : this ) expressionasstatement.setParent_name( ref_parent_name );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( ExpressionAsStatement expressionasstatement : this ) expressionasstatement.setBlock_number( ref_block_number );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( ExpressionAsStatement expressionasstatement : this ) expressionasstatement.setBody_name( ref_body_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( ExpressionAsStatement expressionasstatement : this ) expressionasstatement.setParent_package( ref_parent_package );
    }


    // selections
    @Override
    public StatementSet R451_is_a_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( ExpressionAsStatement expressionasstatement : this ) statementset.add( expressionasstatement.R451_is_a_Statement() );
        return statementset;
    }
    @Override
    public ExpressionSet R476_executes_as_statement_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( ExpressionAsStatement expressionasstatement : this ) expressionset.add( expressionasstatement.R476_executes_as_statement_Expression() );
        return expressionset;
    }


    @Override
    public ExpressionAsStatement nullElement() {
        return ExpressionAsStatementImpl.EMPTY_EXPRESSIONASSTATEMENT;
    }

    @Override
    public ExpressionAsStatementSet emptySet() {
      return new ExpressionAsStatementSetImpl();
    }

    @Override
    public ExpressionAsStatementSet emptySet(Comparator<? super ExpressionAsStatement> comp) {
      return new ExpressionAsStatementSetImpl(comp);
    }

    @Override
    public List<ExpressionAsStatement> elements() {
        return Arrays.asList(toArray(new ExpressionAsStatement[0]));
    }

}
