package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.statement.ContinueSmt;
import io.ciera.tool.sql.architecture.statement.ContinueSmtSet;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ContinueSmtSetImpl extends InstanceSet<ContinueSmtSet,ContinueSmt> implements ContinueSmtSet {

    public ContinueSmtSetImpl() {
    }

    public ContinueSmtSetImpl(Comparator<? super ContinueSmt> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( ContinueSmt continuesmt : this ) continuesmt.setStatement_number( ref_statement_number );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( ContinueSmt continuesmt : this ) continuesmt.setBlock_number( ref_block_number );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( ContinueSmt continuesmt : this ) continuesmt.setParent_package( ref_parent_package );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( ContinueSmt continuesmt : this ) continuesmt.setParent_name( ref_parent_name );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( ContinueSmt continuesmt : this ) continuesmt.setBody_name( ref_body_name );
    }


    // selections
    @Override
    public StatementSet R451_is_a_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( ContinueSmt continuesmt : this ) statementset.add( continuesmt.R451_is_a_Statement() );
        return statementset;
    }


    @Override
    public ContinueSmt nullElement() {
        return ContinueSmtImpl.EMPTY_CONTINUESMT;
    }

    @Override
    public ContinueSmtSet emptySet() {
      return new ContinueSmtSetImpl();
    }

    @Override
    public ContinueSmtSet emptySet(Comparator<? super ContinueSmt> comp) {
      return new ContinueSmtSetImpl(comp);
    }

    @Override
    public List<ContinueSmt> elements() {
        return Arrays.asList(toArray(new ContinueSmt[0]));
    }

}
