package io.ciera.tool.sql.architecture.statemachine.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.statemachine.StateMachineSet;
import io.ciera.tool.sql.architecture.statemachine.StateSet;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableCellSet;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableRow;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableRowSet;
import io.ciera.tool.sql.architecture.statemachine.impl.StateMachineSetImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.StateSetImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.TransitionTableCellSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class TransitionTableRowSetImpl extends InstanceSet<TransitionTableRowSet,TransitionTableRow> implements TransitionTableRowSet {

    public TransitionTableRowSetImpl() {
    }

    public TransitionTableRowSetImpl(Comparator<? super TransitionTableRow> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setState_name( String ref_state_name ) throws XtumlException {
        for ( TransitionTableRow transitiontablerow : this ) transitiontablerow.setState_name( ref_state_name );
    }
    @Override
    public void setSm_package( String ref_sm_package ) throws XtumlException {
        for ( TransitionTableRow transitiontablerow : this ) transitiontablerow.setSm_package( ref_sm_package );
    }
    @Override
    public void setSm_name( String ref_sm_name ) throws XtumlException {
        for ( TransitionTableRow transitiontablerow : this ) transitiontablerow.setSm_name( ref_sm_name );
    }
    @Override
    public void setIndex( int m_index ) throws XtumlException {
        for ( TransitionTableRow transitiontablerow : this ) transitiontablerow.setIndex( m_index );
    }


    // selections
    @Override
    public StateMachineSet R4753_StateMachine() throws XtumlException {
        StateMachineSet statemachineset = new StateMachineSetImpl();
        for ( TransitionTableRow transitiontablerow : this ) statemachineset.add( transitiontablerow.R4753_StateMachine() );
        return statemachineset;
    }
    @Override
    public StateSet R4754_State() throws XtumlException {
        StateSet stateset = new StateSetImpl();
        for ( TransitionTableRow transitiontablerow : this ) stateset.add( transitiontablerow.R4754_State() );
        return stateset;
    }
    @Override
    public TransitionTableCellSet R4755_defined_by_TransitionTableCell() throws XtumlException {
        TransitionTableCellSet transitiontablecellset = new TransitionTableCellSetImpl();
        for ( TransitionTableRow transitiontablerow : this ) transitiontablecellset.addAll( transitiontablerow.R4755_defined_by_TransitionTableCell() );
        return transitiontablecellset;
    }


    @Override
    public TransitionTableRow nullElement() {
        return TransitionTableRowImpl.EMPTY_TRANSITIONTABLEROW;
    }

    @Override
    public TransitionTableRowSet emptySet() {
      return new TransitionTableRowSetImpl();
    }

    @Override
    public TransitionTableRowSet emptySet(Comparator<? super TransitionTableRow> comp) {
      return new TransitionTableRowSetImpl(comp);
    }

    @Override
    public List<TransitionTableRow> elements() {
        return Arrays.asList(toArray(new TransitionTableRow[0]));
    }

}
