package io.ciera.tool.sql.architecture.file;


import io.ciera.runtime.summit.classes.IModelInstance;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.application.Application;
import io.ciera.tool.sql.architecture.classes.InstSet;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.component.ComponentDefinition;
import io.ciera.tool.sql.architecture.component.Utility;
import io.ciera.tool.sql.architecture.file.GeneralFile;
import io.ciera.tool.sql.architecture.file.TypeImportReference;
import io.ciera.tool.sql.architecture.file.TypeImportReferenceSet;
import io.ciera.tool.sql.architecture.interfaces.Iface;
import io.ciera.tool.sql.architecture.interfaces.Port;
import io.ciera.tool.sql.architecture.statemachine.StateMachine;
import io.ciera.tool.sql.architecture.type.EnumeratedType;
import io.ciera.tool.sql.architecture.type.UserDefinedType;

import types.ImportType;


public interface File extends IModelInstance<File,Sql> {

    // attributes
    public void setName( String m_name ) throws XtumlException;
    public String getName() throws XtumlException;
    public void setPackage( String m_package ) throws XtumlException;
    public String getPackage() throws XtumlException;
    public void setPath( String m_path ) throws XtumlException;
    public String getPath() throws XtumlException;
    public String getExtension() throws XtumlException;
    public void setExtension( String m_extension ) throws XtumlException;
    public boolean getExclude() throws XtumlException;
    public void setExclude( boolean m_exclude ) throws XtumlException;


    // operations
    public String getFormattedImports( final ImportType p_type ) throws XtumlException;
    public void render() throws XtumlException;


    // selections
    default public void setR401_is_a_Application( Application inst ) {}
    public Application R401_is_a_Application() throws XtumlException;
    default public void setR401_is_a_ComponentDefinition( ComponentDefinition inst ) {}
    public ComponentDefinition R401_is_a_ComponentDefinition() throws XtumlException;
    default public void setR401_is_a_EnumeratedType( EnumeratedType inst ) {}
    public EnumeratedType R401_is_a_EnumeratedType() throws XtumlException;
    default public void setR401_is_a_GeneralFile( GeneralFile inst ) {}
    public GeneralFile R401_is_a_GeneralFile() throws XtumlException;
    default public void setR401_is_a_Iface( Iface inst ) {}
    public Iface R401_is_a_Iface() throws XtumlException;
    default public void setR401_is_a_InstSet( InstSet inst ) {}
    public InstSet R401_is_a_InstSet() throws XtumlException;
    default public void setR401_is_a_ModelInst( ModelInst inst ) {}
    public ModelInst R401_is_a_ModelInst() throws XtumlException;
    default public void setR401_is_a_Port( Port inst ) {}
    public Port R401_is_a_Port() throws XtumlException;
    default public void setR401_is_a_StateMachine( StateMachine inst ) {}
    public StateMachine R401_is_a_StateMachine() throws XtumlException;
    default public void setR401_is_a_UserDefinedType( UserDefinedType inst ) {}
    public UserDefinedType R401_is_a_UserDefinedType() throws XtumlException;
    default public void setR401_is_a_Utility( Utility inst ) {}
    public Utility R401_is_a_Utility() throws XtumlException;
    default public void addR402_imports_type_via_TypeImportReference( TypeImportReference inst ) {}
    default public void removeR402_imports_type_via_TypeImportReference( TypeImportReference inst ) {}
    public TypeImportReferenceSet R402_imports_type_via_TypeImportReference() throws XtumlException;


}
