package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.classes.AttributeSet;
import io.ciera.tool.sql.architecture.classes.impl.AttributeSetImpl;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.Where;
import io.ciera.tool.sql.architecture.expression.WhereSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import types.SortType;


public class WhereSetImpl extends InstanceSet<WhereSet,Where> implements WhereSet {

    public WhereSetImpl() {
    }

    public WhereSetImpl(Comparator<? super Where> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        for ( Where where : this ) where.setAttr_name( ref_attr_name );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( Where where : this ) where.setBlock_number( ref_block_number );
    }
    @Override
    public void setCast( String m_cast ) throws XtumlException {
        for ( Where where : this ) where.setCast( m_cast );
    }
    @Override
    public void setAttr_class_package( String ref_attr_class_package ) throws XtumlException {
        for ( Where where : this ) where.setAttr_class_package( ref_attr_class_package );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( Where where : this ) where.setParent_package( ref_parent_package );
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( Where where : this ) where.setExpression_number( ref_expression_number );
    }
    @Override
    public void setSorted( SortType m_sorted ) throws XtumlException {
        for ( Where where : this ) where.setSorted( m_sorted );
    }
    @Override
    public void setMultiplicity( String m_multiplicity ) throws XtumlException {
        for ( Where where : this ) where.setMultiplicity( m_multiplicity );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( Where where : this ) where.setStatement_number( ref_statement_number );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( Where where : this ) where.setBody_name( ref_body_name );
    }
    @Override
    public void setBase_expression_number( String ref_base_expression_number ) throws XtumlException {
        for ( Where where : this ) where.setBase_expression_number( ref_base_expression_number );
    }
    @Override
    public void setWhere_expression_number( String ref_where_expression_number ) throws XtumlException {
        for ( Where where : this ) where.setWhere_expression_number( ref_where_expression_number );
    }
    @Override
    public void setAttr_class_name( String ref_attr_class_name ) throws XtumlException {
        for ( Where where : this ) where.setAttr_class_name( ref_attr_class_name );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( Where where : this ) where.setParent_name( ref_parent_name );
    }


    // selections
    @Override
    public AttributeSet R3906_sorts_set_by_Attribute() throws XtumlException {
        AttributeSet attributeset = new AttributeSetImpl();
        for ( Where where : this ) attributeset.add( where.R3906_sorts_set_by_Attribute() );
        return attributeset;
    }
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( Where where : this ) expressionset.add( where.R776_is_a_Expression() );
        return expressionset;
    }
    @Override
    public ExpressionSet R790_filters_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( Where where : this ) expressionset.add( where.R790_filters_Expression() );
        return expressionset;
    }
    @Override
    public ExpressionSet R796_has_condition_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( Where where : this ) expressionset.add( where.R796_has_condition_Expression() );
        return expressionset;
    }


    @Override
    public Where nullElement() {
        return WhereImpl.EMPTY_WHERE;
    }

    @Override
    public WhereSet emptySet() {
      return new WhereSetImpl();
    }

    @Override
    public WhereSet emptySet(Comparator<? super Where> comp) {
      return new WhereSetImpl(comp);
    }

    @Override
    public List<Where> elements() {
        return Arrays.asList(toArray(new Where[0]));
    }

}
