package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.Promotion;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;
import io.ciera.tool.sql.architecture.type.BuiltInType;
import io.ciera.tool.sql.architecture.type.Type;


public class PromotionImpl extends ModelInstance<Promotion,Sql> implements Promotion {

    public static final String KEY_LETTERS = "Promotion";
    public static final Promotion EMPTY_PROMOTION = new EmptyPromotion();

    private Sql context;

    // constructors
    private PromotionImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_expression_number = "";
        ref_input_expression_number = "";
        m_cast = false;
        R3907_promotes_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    private PromotionImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_input_expression_number, boolean m_cast ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_expression_number = ref_expression_number;
        this.ref_input_expression_number = ref_input_expression_number;
        this.m_cast = m_cast;
        R3907_promotes_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    public static Promotion create( Sql context ) throws XtumlException {
        Promotion newPromotion = new PromotionImpl( context );
        if ( context.addInstance( newPromotion ) ) {
            newPromotion.getRunContext().addChange(new InstanceCreatedDelta(newPromotion, KEY_LETTERS));
            return newPromotion;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Promotion create( Sql context, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_input_expression_number, boolean m_cast ) throws XtumlException {
        return create(context, UniqueId.random(), ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, ref_input_expression_number, m_cast);
    }

    public static Promotion create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_input_expression_number, boolean m_cast ) throws XtumlException {
        Promotion newPromotion = new PromotionImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, ref_input_expression_number, m_cast );
        if ( context.addInstance( newPromotion ) ) {
            return newPromotion;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    private String ref_parent_package;
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    private String ref_body_name;
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    private String ref_block_number;
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    private String ref_statement_number;
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    private String ref_expression_number;
    @Override
    public void setExpression_number(String ref_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_expression_number, this.ref_expression_number)) {
            final String oldValue = this.ref_expression_number;
            this.ref_expression_number = ref_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_expression_number", oldValue, this.ref_expression_number));
        }
    }
    @Override
    public String getExpression_number() throws XtumlException {
        checkLiving();
        return ref_expression_number;
    }
    private String ref_input_expression_number;
    @Override
    public String getInput_expression_number() throws XtumlException {
        checkLiving();
        return ref_input_expression_number;
    }
    @Override
    public void setInput_expression_number(String ref_input_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_input_expression_number, this.ref_input_expression_number)) {
            final String oldValue = this.ref_input_expression_number;
            this.ref_input_expression_number = ref_input_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_input_expression_number", oldValue, this.ref_input_expression_number));
        }
    }
    private boolean m_cast;
    @Override
    public boolean getCast() throws XtumlException {
        checkLiving();
        return m_cast;
    }
    @Override
    public void setCast(boolean m_cast) throws XtumlException {
        checkLiving();
        if (m_cast != this.m_cast) {
            final boolean oldValue = this.m_cast;
            this.m_cast = m_cast;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_cast", oldValue, this.m_cast));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number(), getExpression_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        Expression base_expression = self().R3907_promotes_Expression();
        base_expression.render();
        String root_expression_body = context().T().body();
        context().T().clear();
        context().T().pop_buffer();
        Type type = self().R776_is_a_Expression().R795_expresses_value_of_TypeReference().R3800_based_on_Type();
        BuiltInType input_type_builtin = self().R3907_promotes_Expression().R795_expresses_value_of_TypeReference().R3800_based_on_Type().R407_is_a_BuiltInType();
        String type_name = type.getName();
        String cast_function = "";
        if ( self().getCast() && ( input_type_builtin.isEmpty() || !input_type_builtin.getPrimitive() ) ) {
            if ( StringUtil.equality("boolean", type_name) ) {
                cast_function = "cast";
            }
            else if ( StringUtil.equality("int", type_name) ) {
                cast_function = "cast";
            }
            else if ( StringUtil.equality("double", type_name) ) {
                cast_function = "cast";
            }
            else if ( StringUtil.equality("String", type_name) ) {
                cast_function = "cast";
            }
        }
        context().T().include( "expression/t.promotion.java", cast_function, root_expression_body, self(), type_name );
    }



    // static operations


    // events


    // selections
    private Expression R3907_promotes_Expression_inst;
    @Override
    public void setR3907_promotes_Expression( Expression inst ) {
        R3907_promotes_Expression_inst = inst;
    }
    @Override
    public Expression R3907_promotes_Expression() throws XtumlException {
        return R3907_promotes_Expression_inst;
    }
    private Expression R776_is_a_Expression_inst;
    @Override
    public void setR776_is_a_Expression( Expression inst ) {
        R776_is_a_Expression_inst = inst;
    }
    @Override
    public Expression R776_is_a_Expression() throws XtumlException {
        return R776_is_a_Expression_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Promotion self() {
        return this;
    }

    @Override
    public Promotion oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_PROMOTION;
    }

}

class EmptyPromotion extends ModelInstance<Promotion,Sql> implements Promotion {

    // attributes
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getExpression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getInput_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInput_expression_number( String ref_input_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getCast() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setCast( boolean m_cast ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Expression R3907_promotes_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }
    @Override
    public Expression R776_is_a_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }


    @Override
    public String getKeyLetters() {
        return PromotionImpl.KEY_LETTERS;
    }

    @Override
    public Promotion self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Promotion oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return PromotionImpl.EMPTY_PROMOTION;
    }

}
